/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "kino_common.h"
#include "page.h"

extern "C"
{

#include "preferences.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "commands.h"
#include "message.h"
#include <libavc1394/avc1394.h>
#include <libavc1394/rom1394.h>

    extern GtkWidget *main_window;
    extern KinoCommon *common;

    gint gPrefsSelectedFileFormat;
    gint gPrefsDisplayMode;
    gint gPrefsPhyID;


    void
    on_capture_page_options_button_clicked (GtkButton *button,
            gpointer user_data) {
        on_preferences_activate(NULL, NULL);
    }


    void
    on_preferences_activate (GtkMenuItem *menuitem,
                             gpointer user_data) {
        Preferences &prefs = Preferences::getInstance();
        gchar s[512];
        GtkWidget* glade_menu;
        GtkWidget* glade_menuitem;
        GtkWidget* widget;
        int currentNode, itemCount=0, currentItem=0;
        rom1394_directory rom1394_dir;
        glade_menu = gtk_menu_new ();
        static raw1394handle_t  handle;

        /* initialize temp variables, only use temp if Okay clicked and not cancel */
        gPrefsSelectedFileFormat = prefs.fileFormat;
        gPrefsDisplayMode = prefs.displayMode;

        GtkWidget *dialog = create_preferences_dialog();
        if (prefs.fileFormat == AVI_DV1_FORMAT) {
            widget = lookup_widget(dialog, "radiobutton_avi1");
            gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), 1);
        } else if(prefs.fileFormat == AVI_DV2_FORMAT) {
            widget = lookup_widget(dialog, "radiobutton_avi2");
            gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), 1);
        }
        widget = lookup_widget(dialog, "checkbutton_autosplit");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.autoSplit);
        widget = lookup_widget(dialog, "checkbutton_timestamp");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.timeStamp);

#ifndef HAVE_X11_EXTENSIONS_XVLIB_H
        gtk_widget_set_sensitive( lookup_widget(dialog, "radiobutton_XV"), FALSE);
#endif
        switch (prefs.displayMode) {
        case DISPLAY_XX:
            widget = lookup_widget(dialog, "radiobutton_XX");
            break;
        case DISPLAY_XV:
            widget = lookup_widget(dialog, "radiobutton_XV");
            break;
        case DISPLAY_GDKRGB:
            widget = lookup_widget(dialog, "radiobutton_GDK");
            break;
        default:
            widget = lookup_widget(dialog, "radiobutton_GDK");
            break;
        }
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), TRUE);

        widget = lookup_widget(dialog, "hscale_display_quality");
        GtkAdjustment *displayQualityValue = gtk_range_get_adjustment(GTK_RANGE(widget));
        displayQualityValue->value = prefs.displayQuality;
        gtk_range_set_adjustment(GTK_RANGE(widget), displayQualityValue);


        widget = lookup_widget(dialog, "entry_file");
        widget = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(widget));
        gtk_entry_set_text( GTK_ENTRY(widget), prefs.file);
        widget = lookup_widget(dialog, "entry_frames");
        sprintf(s, "%d", prefs.frames);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "entry_every");
        sprintf(s, "%d", prefs.every);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "entry_interface");
        sprintf(s, "%d", prefs.interface);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "entry_channel");
        sprintf(s, "%d", prefs.channel);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "entry_timing");
        sprintf(s, "%d", prefs.cip_n);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "entry_timing_threshold");
        sprintf(s, "%d", prefs.cip_d);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "entry_syt_offset");
        sprintf(s, "%d", prefs.syt_offset);
        gtk_entry_set_text( GTK_ENTRY(widget), s);
        widget = lookup_widget(dialog, "checkbutton_enable_audio");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.enableAudio);
        widget = lookup_widget(dialog, "entry_audio_device");
        gtk_entry_set_text( GTK_ENTRY(widget), prefs.audioDevice);
        widget = lookup_widget(dialog, "checkbutton_preview_capture");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.preview_capture);
        widget = lookup_widget(dialog, "checkbutton_drop_frame");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.dropFrame);
        widget = lookup_widget(dialog, "checkbutton_enable_jogshuttle");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.enableJogShuttle);
        widget = lookup_widget(dialog, "entry_jogshuttle_device");
        gtk_entry_set_text( GTK_ENTRY(widget), prefs.jogShuttleDevice);
        widget = lookup_widget(dialog, "checkbutton_disable_key_repeat");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.disableKeyRepeat);
        widget = lookup_widget(dialog, "checkbutton_show_timecode");
        gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(widget), prefs.enableTimecode);

        widget = lookup_widget(dialog, "optionmenu_avc_phyid");
        
#ifdef LIBRAW1394_OLD
        if ((handle = raw1394_get_handle())) {
#else
        if ((handle = raw1394_new_handle())) {
#endif
            if (raw1394_set_port(handle, 0) >= 0) {
    
                gtk_widget_set_sensitive( lookup_widget(dialog, "entry_interface"), TRUE);
                gtk_widget_set_sensitive( lookup_widget(dialog, "entry_channel"), TRUE);
                gtk_widget_set_sensitive( lookup_widget(dialog, "optionmenu_avc_phyid"), TRUE);
                gtk_widget_set_sensitive( lookup_widget(dialog, "entry_timing"), TRUE);
                gtk_widget_set_sensitive( lookup_widget(dialog, "entry_timing_threshold"), TRUE);
                gtk_widget_set_sensitive( lookup_widget(dialog, "entry_syt_offset"), TRUE);

                for (currentNode = 0; currentNode < raw1394_get_nodecount(handle); currentNode++) {
                    rom1394_get_directory( handle, currentNode, &rom1394_dir);
                    if ( (rom1394_get_node_type( &rom1394_dir) == ROM1394_NODE_TYPE_AVC) && 
                        avc1394_check_subunit_type(handle, currentNode, AVC1394_SUBUNIT_TYPE_VCR)) {
                        if (rom1394_dir.label == NULL) {
                            sprintf(s, "Node %d", currentNode);
                            glade_menuitem = gtk_menu_item_new_with_label (s);
                        } else {
                            glade_menuitem = gtk_menu_item_new_with_label (rom1394_dir.label);
                        }
                        gtk_widget_show (glade_menuitem);
                        gtk_menu_append (GTK_MENU (glade_menu), glade_menuitem);
                        gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
                                            GTK_SIGNAL_FUNC (on_avc_phyid_activate),
                                            (int*)currentNode);
                        if (currentNode == prefs.phyID)
                            currentItem = itemCount;
                        itemCount++;
        
                        // default the phyID to the first AVC node found
                        if (prefs.phyID < 0)
                            prefs.phyID = currentNode;
                    }
                    rom1394_free_directory(&rom1394_dir);
                }
                // If gPhyID is still unset (-1), then set it to -2 to indicate no AVC devices
                if (prefs.phyID == -1)
                    prefs.phyID = -2;
                gPrefsPhyID = prefs.phyID;
        
                raw1394_destroy_handle(handle);
                handle = NULL;
            } else
            modal_message("Error setting the IEEE 1394 port (host adapater); all IEEE 1394 options are disabled.");
        } else 
            modal_message("The IEEE 1394 subsystem is not loaded; all IEEE 1394 options are disabled.");

        gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), glade_menu);
        gtk_option_menu_set_history( GTK_OPTION_MENU(widget), currentItem);
        gtk_widget_show(dialog);
    }


    void
    on_avc_phyid_activate(GtkMenuItem *menu_item, gpointer user_data) {
        gPrefsPhyID = (int)user_data;
    }

    void
    on_radiobutton_avi1_clicked (GtkButton *button,
                                 gpointer user_data) {
        gPrefsSelectedFileFormat = AVI_DV1_FORMAT;
    }


    void
    on_radiobutton_avi2_clicked (GtkButton *button,
                                 gpointer user_data) {
        gPrefsSelectedFileFormat = AVI_DV2_FORMAT;
    }

    void
    on_radiobutton_XX_clicked (GtkButton *button,
                               gpointer user_data) {
        gPrefsDisplayMode = DISPLAY_XX;
    }

    void
    on_radiobutton_XV_clicked (GtkButton *button,
                               gpointer user_data) {
        gPrefsDisplayMode = DISPLAY_XV;
    }

    void
    on_radiobutton_GDK_clicked (GtkButton *button,
                                gpointer user_data) {
        gPrefsDisplayMode = DISPLAY_GDKRGB;
    }

    void
    on_preferences_dialog_ok_button_clicked( GtkButton *button, gpointer user_data) {
        Preferences &prefs = Preferences::getInstance();
        GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
        GtkWidget *widget = lookup_widget(dialog, "checkbutton_autosplit");

        prefs.autoSplit = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "checkbutton_timestamp");
        prefs.timeStamp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "entry_file");
        widget = gnome_file_entry_gtk_entry( GNOME_FILE_ENTRY(widget));
        strcpy( prefs.file, gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "entry_frames");
        prefs.frames = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        if (prefs.frames <= 0) prefs.frames = 99999;
        widget = lookup_widget(dialog, "entry_every");
        prefs.every = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        if (prefs.every <= 0) prefs.every = 1;
        widget = lookup_widget(dialog, "entry_interface");
        prefs.interface = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "entry_channel");
        prefs.channel = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        GtkAdjustment *displayQualityValue;
        widget = lookup_widget(dialog, "hscale_display_quality");
        displayQualityValue = gtk_range_get_adjustment(GTK_RANGE(widget));
        if (displayQualityValue->value != prefs.displayQuality) {
            prefs.displayQuality = displayQualityValue->value;
			common->moveToFrame();
        }
        widget = lookup_widget(dialog, "entry_timing");
        prefs.cip_n = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "entry_timing_threshold");
        prefs.cip_d = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "entry_syt_offset");
        prefs.syt_offset = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "checkbutton_enable_audio");
        prefs.enableAudio = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "entry_audio_device");
        strcpy( prefs.audioDevice, gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "checkbutton_preview_capture");
        prefs.preview_capture = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "checkbutton_drop_frame");
        prefs.dropFrame = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "checkbutton_enable_jogshuttle");
        prefs.enableJogShuttle = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "entry_jogshuttle_device");
        strcpy( prefs.jogShuttleDevice, gtk_entry_get_text(GTK_ENTRY(widget)));
        widget = lookup_widget(dialog, "checkbutton_disable_key_repeat");
        prefs.disableKeyRepeat = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        widget = lookup_widget(dialog, "checkbutton_show_timecode");
        prefs.enableTimecode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
        
        prefs.fileFormat = gPrefsSelectedFileFormat;
        prefs.phyID = gPrefsPhyID;
        prefs.displayMode = gPrefsDisplayMode;

        prefs.Save();
        gtk_widget_destroy(dialog);

		common->getCurrentPage()->clean();
		common->getCurrentPage()->start();
    }


    void
    on_preferences_dialog_cancel_button_clicked( GtkButton *button, gpointer user_data) {
        GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
        gtk_widget_destroy(dialog);
    }

}
