#ifndef KP_PLUGIN_H_
#define KP_PLUGIN_H_

#include <glib.h>
#include <gmodule.h>
#include <glib-object.h>

#define KP_TYPE_PLUGIN (kp_plugin_get_type())
#define KP_PLUGIN(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_PLUGIN, KPPlugin))
#define KP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_PLUGIN, KPPluginClass))
#define KP_IS_PLUGIN(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_PLUGIN))
#define KP_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_PLUGIN))
#define KP_PLUGIN_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_PLUGIN, KPPluginClass))


typedef struct KPPluginInfo_  KPPluginInfo;
typedef struct KPPlugin_      KPPlugin;
typedef struct KPPluginClass_ KPPluginClass;

struct KPPluginInfo_ {

  unsigned int api_version;
  
  char *id;
  char *name;
  char *version;
  char *summary;
  char *description;
  char *author;
  char *homepage;
 
  gboolean (*load)(KPPlugin *plugin);
  gboolean (*unload)(KPPlugin *plugin);
  void (*destroy)(KPPlugin *plugin);  
};


struct KPPlugin_
{
  GObject           parent_instance;

  gchar            *fn;
  gboolean          loaded;

  KPPluginInfo     *info;
  
  GModule          *handle;
};

struct KPPluginClass_ {
  GObjectClass      parent_class;  
};

GType           kp_plugin_get_type (void);

KPPlugin       *kp_plugin_new (const gchar *file);

gboolean        kp_plugin_load (KPPlugin *plugin);
gboolean        kp_plugin_load_by_name (const gchar *name);

void            kp_plugin_unload (KPPlugin *plugin);
void            kp_plugin_unload_by_name (const gchar *name);

void            kp_plugin_scan (const gchar *dir);

GList          *kp_plugin_get_plugins (void);
GList          *kp_plugin_get_plugins_loaded (void);

void            kp_plugin_load_plugins (void);

gboolean        kp_plugin_register (KPPlugin *plugin);


#define KP_PLUGIN_INIT(name, initfunc, info) \
  G_MODULE_EXPORT gboolean kp_plugin_init(KPPlugin *plugin) { \
    plugin->info = &(info); \
    initfunc((plugin)); \
    return kp_plugin_register(plugin); \
  }

#endif /* KP_PLUGIN_H_ */
