#include "ncursefront.h"

#ifdef HAVE_LIBNCURSES

NCurseFront::NCurseFront() {
    errstr[0] = '\0';

    gps = NULL;
    tracker = NULL;
}

int NCurseFront::InitDisplay(int in_decay) {
    start_time = time(0);

    decay = in_decay;

    initscr();

    netborder = subwin(stdscr, LINES-statheight, COLS-infowidth, 0, 0);
    netwin = subwin(netborder, LINES-statheight-3, COLS-infowidth-2, 2, 1);
    infoborder = subwin(stdscr, LINES-statheight, infowidth,
                        0, COLS-infowidth);


    infowin = subwin(stdscr, LINES-statheight-2, infowidth-2,
                     1, COLS-infowidth+1);

    statusborder = subwin(stdscr, statheight, COLS, LINES-statheight, 0);

    statuswin = subwin(stdscr, statheight-2, COLS-2, LINES-statheight+1, 1);
    scrollok(statuswin, 1);

    return 0;
}

// Maybe recode this in the future
int NCurseFront::WriteStatus(string status) {
    winsertln(statuswin);
    mvwaddstr(statuswin, 0, 1, status.substr(0, COLS-4).c_str());
}

int NCurseFront::DrawDisplay() {
    // The status window takes care of itself

    box(netborder, '|', '-');
    mvwaddstr(netborder, 0, 2, "Networks");
    //    mvwaddstr(netborder, 1, 2, "  SSID                        T W Ch BSSID             Pckts");
    // 0 2 30 32 34 37 42 46 51
    mvwaddstr(netborder, 1, 2, "  SSID                        T W Ch  Data   LLC  Crypt  Wk Flags");

    char gpsdata[1024];
    if (gps != NULL) {
        float lat, lon, alt, spd;
        int mode;

        gps->FetchLoc(&lat, &lon, &alt, &spd, &mode);

        char fix[16];

        if (mode == -1)
            snprintf(fix, 16, "No signal");
        else if (mode == 2)
            snprintf(fix, 5, "2D");
        else if (mode == 3)
            snprintf(fix, 5, "3D");
        else
            snprintf(fix, 5, "NONE");

        snprintf(gpsdata, 1024, "Lat %.3f Lon %.3f Alt %.3f Spd %.3f Fix %s",
                 lat, lon, alt, spd, fix);

        mvwaddstr(netborder, LINES-statheight-1, 2, gpsdata);

        // fprintf(stderr, "found: %f %f %f %f\n", lat, lon, alt, spd);

    }


    box(infoborder, '|', '-');
    mvwaddstr(infoborder, 0, 2, "Info");

    mvwaddch(infoborder, LINES-statheight-1, 3, 'H');
    mvwaddch(infoborder, LINES-statheight-1, 5, 'M');
    mvwaddch(infoborder, LINES-statheight-1, 7, 'S');

    box(statusborder, '|', '-');
    mvwaddstr(statusborder, 0, 2, "Status");

    // Now draw the info window
    char info[infowidth-2];
    werase(infowin);

    mvwaddstr(infowin, 0, 1, "Ntwrks");
    snprintf(info, infowidth-2, "%6d", tracker->FetchNumNetworks());
    mvwaddstr(infowin, 1, 1, info);

    mvwaddstr(infowin, 2, 1, "Pckets");
    snprintf(info, infowidth-2, "%6d", tracker->FetchNumPackets());
    mvwaddstr(infowin, 3, 1, info);

    mvwaddstr(infowin, 4, 1, "Cryptd");
    snprintf(info, infowidth-2, "%6d", tracker->FetchNumCrypt());
    mvwaddstr(infowin, 5, 1, info);

    mvwaddstr(infowin, 6, 1, "  Weak");
    snprintf(info, infowidth-2, "%6d", tracker->FetchNumInteresting());
    mvwaddstr(infowin, 7, 1, info);

    mvwaddstr(infowin, 8, 1, " Noise");
    snprintf(info, infowidth-2, "%6d", tracker->FetchNumNoise());
    mvwaddstr(infowin, 9, 1, info);

    mvwaddstr(infowin, 10, 1, "Discrd");
    snprintf(info, infowidth-2, "%6d", tracker->FetchNumDropped());
    mvwaddstr(infowin, 11, 1, info);

    mvwaddstr(infowin, LINES-statheight-4, 1, "Elapsd");
    time_t elapsed = time(0) - start_time;
    snprintf(info, infowidth-2, "%02d%02d%02d",
             (int) (elapsed / 60) / 60, (int) (elapsed / 60) % 60,
             (int) elapsed % 60);
    mvwaddstr(infowin, LINES-statheight-3, 1, info);

    // Handle trimming the network list
    vector<wireless_network *> network_vector = tracker->FetchNthRecent(LINES-3-statheight);

    int num = 0;

    werase(netwin);

    for (unsigned int i = 0; i < network_vector.size(); i++) {
        wireless_network *net = network_vector[i];

        char statchar;
        if ((time(0) - net->last_time) < decay)
            statchar = '!';
        else if ((time(0) - net->last_time) < (decay * 2))
            statchar = '.';
        else
            statchar = ' ';
        mvwaddch(netwin, num, 1, statchar);

        char statstr[1024];
        memset(statstr, 0, 1024);
        snprintf(statstr, 28, "%s", net->ssid.c_str());

        mvwaddstr(netwin, num, 3, statstr);

        char type;
        if (net->type == network_ap)
            type = 'A';
        else if (net->type == network_adhoc)
            type = 'H';
        else if (net->type == network_probe)
            type = 'P';
        else if (net->type == network_data)
            type = 'D';
        else
            type = '?';

        mvwaddch(netwin, num, 31, type);

        mvwaddch(netwin, num, 33, (net->wep == 1) ? 'Y' : 'N');

        snprintf(statstr, 3, "%02d", net->channel);
        mvwaddstr(netwin, num, 35, statstr);

        snprintf(statstr, 6, "%5d", net->data_packets);
        mvwaddstr(netwin, num, 38, statstr);

        snprintf(statstr, 6, "%5d", net->llc_packets);
        mvwaddstr(netwin, num, 44, statstr);

        snprintf(statstr, 6, "%5d", net->crypt_packets);
        mvwaddstr(netwin, num, 51, statstr);

        snprintf(statstr, 3, "%2d", net->interesting_packets);
        mvwaddstr(netwin, num, 58, statstr);

        char atype;
        if (net->atype == address_dhcp)
            atype = 'D';
        else if (net->atype == address_arp)
            atype = 'A';
        else if (net->atype == address_udp)
            atype = 'U';
        else
            atype = ' ';

        snprintf(statstr, 6, "%c%c%c%c%c",
                 atype,
                 net->octets != 0 ? net->octets + '0' : ' ',
                 net->cisco_equip.size() > 0 ? 'C' : ' ',
                 ' ',
                 ' ');
        mvwaddstr(netwin, num, 61, statstr);

        /*
        mvwaddstr(netwin, num, 38, net->bssid.c_str());

        snprintf(statstr, 5, "%d", (net->data_packets + net->llc_packets));
        mvwaddstr(netwin, num, 56, statstr);
        */

        if (num++ > LINES-3-statheight)
            break;
    }
    wrefresh(netborder);
    wrefresh(infoborder);
    wrefresh(statusborder);
    wrefresh(statuswin);
    wrefresh(netwin);
    wrefresh(infowin);
    refresh();

    return 1;
}

int NCurseFront::EndDisplay() {
    endwin();

    return 1;
}

#endif
