/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kitty.h"
#include "kitty_prefs.h"
#include "kitten.h"
#include "kitty_nekotongue.h"
#include "kitty_globals.h"
#include "kitty_publish.h"
#include "kitty_articleedit.h"
#include "kitty_bookmark.h"

#include <qlabel.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <qfile.h>
#include <kmessagebox.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlistbox.h>
#include <kdialog.h>
#include <klistview.h>
#include <qsplitter.h>
#include <kmenubar.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <kiconloader.h>
#include <ktrader.h>
#include <klibloader.h>
#include <kio/netaccess.h>
#include <kinputdialog.h>
#include <kpopupmenu.h>
#include <kurllabel.h>

#include <kaction.h>

#include <qwidget.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <kprogress.h>
#include <krun.h>
#include <kconfig.h>
#include <ktoolbar.h>
#include <qdir.h>
#include <kstandarddirs.h>

#include <qtimer.h>

#include <ksystemtray.h>
#include <kstatusbar.h>
#include <kpassivepopup.h>
#include <qcstring.h>
#include <kmimemagic.h>
#include <qvaluestack.h>
#include <dom/dom_string.h>
#include <dom/html_element.h>
#include <kbookmarkmanager.h>
#include <kbookmarkmenu.h>
#include <kcharsets.h>

void Kitty::editFeed() {
	raw_editFeed(selected_feed);
}

void Kitty::upDateFeedList(int feed_id) {
	QString str;
	QListViewItemIterator it( feedbox );
	while ( it.current() ) {
	QListViewItem *item = it.current();
	if (item->text(1)==str.sprintf("%d",feed_id)) {
		item->setText(0,feeds[feed_id].title);
	}
	++it;
	}
}

bool Kitty::setDefaultSkin() {
	skin_path=locate("appdata","skin_head.html");
	skin_path=skin_path.left(skin_path.length()-14);
	bool ret;
	ret=loadFile(skin_path+"skin_head.html",skin_head);
	ret=ret && loadFile(skin_path+"skin_footer.html",skin_footer);
	ret=ret && loadFile(skin_path+"skin_js.html",skin_js);
	ret=ret && loadFile(skin_path+"skin_module.html",skin_module);
	return ret;
}

bool Kitty::loadFile(QString fname,QString &ret) {
    ret="";
    QFile file( fname );
    if ( file.open( IO_ReadOnly ) ) {
        QTextStream stream( &file );
        QString line;
        while ( !stream.atEnd() ) {
            line = stream.readLine(); // line of text excluding '\n'
            ret+=line.latin1();
	    ret+="\n";
        }
        file.close();
	return true;
    } else return false;
   
}

void Kitty::applySkin() {
    bool loadDefault=false;
    if (current_interface==1) { 
	if (kitty_globals::settings.skin.isEmpty()) {
		loadDefault=true;
	} else if (!loadSkin(kitty_globals::settings.skin)) { 
		loadDefault=true; 
	}
	if (loadDefault) {
		if (!setDefaultSkin()) {
			KMessageBox::error(this,"Any valid skin found.");
		}
	}
   }
}

bool Kitty::loadSkin(QString skinname) {
	skin_path=locateLocal("appdata", "skins/"+skinname+"/");
	bool ret;
	ret=loadFile(skin_path+"skin_head.html",skin_head);
	ret=ret && loadFile(skin_path+"skin_footer.html",skin_footer);
	ret=ret && loadFile(skin_path+"skin_js.html",skin_js);
	ret=ret && loadFile(skin_path+"skin_module.html",skin_module);
	return ret;
}

void Kitty::raw_stop() {
	disposeVideo();
}


void Kitty::raw_addArticle(int feed) {
	if (feedLogic(feed,feeds[feed],0,"feed_is_addable")) {
		int nei=feeds[feed].items_count;
		feeds[feed].items[nei].title=i18n("New article");
		feeds[feed].items[nei].description=i18n("Write here your article!");
		feeds[feed].items[nei].file="";
		feeds[feed].items[nei].author=i18n("Me");
		feeds[feed].items[nei].link="";
		feeds[feed].items[nei].key=generateUnique();
		feeds[feed].items[nei].dlstatus="";
		feeds[feed].items[nei].thumbnail="";
		feeds[feed].items_count++;
		viewFeed(feed);	
		saveConfig();
	} else {
		KMessageBox::error(this,i18n("You cannot add an article in this feed."));
	}
}


void Kitty::raw_editFeed(int feed) {
	if (feedLogic(selected_feed,feeds[selected_feed],0,"feed_is_editable")) {
		kitty_feededit *a=new kitty_feededit(this,i18n("Edit feed"),feeds[feed]);
		a->exec();
		if (a->getChanged()) {
			feeds[feed]=a->getFeed();
			upDateFeedList(feed);
			viewFeed(feed);	
			saveConfig();
		}
	} else {
		KMessageBox::error(this,i18n("This feed is not editable."));
	}
}

void Kitty::raw_editArticle(int article) {
	if (feedLogic(selected_feed,feeds[selected_feed],article,"is_editable")) {
		kitty_articleedit *a=new kitty_articleedit(this,i18n("Edit article"),feeds[selected_feed],article);
		a->exec();
		if (a->getChanged()) {
			feeds[selected_feed]=a->getFeed();
			viewFeed(selected_feed);
			saveConfig();
		}
	} else {
		KMessageBox::error(this,i18n("Only collected articles can be edited."));
	}
}


void Kitty::raw_playVideo(int article) {
	/* get url */
	QString url;
	QString mimetype;
	pickVideo(selected_feed,article,url,mimetype);
	/* there is something? */
	if (url.isEmpty()) {
		KMessageBox::information(this,i18n("Any file was found in this item."));
	} else {
		/* search a suitable component */
		if (mimetype.isEmpty()) {
			KMimeMagic *a=new KMimeMagic();
			mimetype=a->findFileType(url)->mimeType();
			/* bad mimed videos. try to open as an avi */
			if (mimetype=="application/octet-stream") { mimetype="video/avi"; }
		}
		/* go searching */
		disposeVideo();
		KTrader::OfferList offers = KTrader::self()->query(mimetype, "'KParts/ReadOnlyPart' in ServiceTypes");
		KLibFactory *factory = 0;
		KTrader::OfferList::Iterator it(offers.begin());
		for( ; it != offers.end(); ++it)
		{
		KService::Ptr ptr = (*it);
		factory = KLibLoader::self()->factory( ptr->library() );
		if (factory)
			{
				m_video = static_cast<KParts::ReadOnlyPart *>(factory->create(videobox, ptr->name(), "KParts::ReadOnlyPart"));
				break;
			}
		}
	
		if (!factory)
		{
			/* component not found. Use external. */
			if (KMessageBox::warningYesNo(this,i18n("Any suitable embedded player for this type of media was found. (%1) Do you want to use a suitable external application?").arg(mimetype))==KMessageBox::Yes) {
				new KRun(url);
			}
		} else {
			/* component created. open url. */
			playingfeed=selected_feed;
			playingarticle=article;
			videodetails->setText("<b>"+feeds[selected_feed].items[article].title+"</b><br><i>"+feeds[selected_feed].title+"</i>");
			QString extension=url.mid(url.findRev(".")+1).upper();
			if (kitty_globals::settings.audioExtensions.grep(extension,false).isEmpty()) {
				if (current_interface==1) {
					alltabs->setCurrentPage(moviePage);
				} else {
					tabs->setCurrentPage(1);
				}
			}
			m_video->openURL(url);
		}
	}
}

void Kitty::raw_addToMyCollection(int article) {
	if (feedLogic(selected_feed,feeds[selected_feed],article,"is_collectable")) {
		if (feeds[0].items_count>=99) {
			KMessageBox::error(this,i18n("Your media collection list is full. Please, remove some media and retry."));
		} else {
			feeds[0].items[feeds[0].items_count]=feeds[selected_feed].items[article];
			feeds[0].items[feeds[0].items_count].dlstatus="";
			KURL k=KURL(feeds[0].items[feeds[0].items_count].file);
			QString filename=feeds[0].items[feeds[0].items_count].key+"-"+k.fileName();
			if (filename.right(8)==".torrent") { filename=filename.left(filename.length()-8); }
			feeds[0].items[feeds[0].items_count].key=filename;
			QString addon="";
			if (kitty_globals::settings.set_download_on_collect) {
				if (!feeds[0].items[feeds[0].items_count].file.isEmpty()) {
					startDownload(0,feeds[0].items_count);
					addon="\n"+i18n("The download was automatically started.");
				}
			}
			feeds[0].items_count++;	
			saveConfig();
			KMessageBox::information(this,i18n("This article was added to your collection."+addon));
		}
	} else {
		KMessageBox::information(this,i18n("This article is already on your collection."));
	}
}

void Kitty::raw_openVideo(int article) {
	/* get url */
	QString url;
	QString mimetype;
	pickVideo(selected_feed,article,url,mimetype);
	/* run stuff */
	new KRun(url);
}

void Kitty::raw_purgeArticle(int article) {
	if (feedLogic(selected_feed,feeds[selected_feed],article,"is_purgeable")) {
		if (KMessageBox::warningYesNo(this,i18n("Delete the video related to the \"%1\" article from the disk?").arg(feeds[selected_feed].items[article].title))==KMessageBox::Yes) {
			raw_cancelDownload(article);
			KIO::del(locateLocal("appdata", feeds[selected_feed].key+"-data/"+feeds[selected_feed].items[article].key));
			feeds[selected_feed].items[article].dlstatus="";
			saveConfig();
		}
	} else {
		KMessageBox::information(this,"Not collected articles are unpurgeable.");
	}
}

void Kitty::raw_removeArticle(int article) {
	if (feedLogic(selected_feed,feeds[selected_feed],article,"is_removable")) {
		if (KMessageBox::warningYesNo(this,i18n("Remove the \"%1\" article from the list?").arg(feeds[selected_feed].items[article].title))==KMessageBox::Yes) {
			raw_cancelDownload(article);
			if (feedLogic(selected_feed,feeds[selected_feed],article,"is_downloaded")) {
				KIO::del(locateLocal("appdata", feeds[selected_feed].key+"-data/"+feeds[selected_feed].items[article].key));
			}
			for (int i=article;i<feeds[selected_feed].items_count-1;i++) {
				feeds[selected_feed].items[i]=feeds[selected_feed].items[i+1];
			}
			feeds[selected_feed].items_count--;
			viewFeed(selected_feed);
			saveConfig();
		}
	} else {
		KMessageBox::information(this,"You can remove only your collected videos.");
	}
}

void Kitty::raw_cancelDownload(int article) {
	if (feedLogic(selected_feed,feeds[selected_feed],article,"is_download_cancelable")) {
		feeds[selected_feed].items[article].downloader->cancel();
		delete feeds[selected_feed].items[article].downloader;
		feeds[selected_feed].items[article].downloader=0;
		feeds[selected_feed].items[article].dlstatus="partial";
		saveConfig();
	}
}

void Kitty::raw_deleteFeed(int feed) {
	if (feedLogic(feed,feeds[feed],0,"feed_is_removable")) {
		if (KMessageBox::warningYesNo(this,i18n("Remove the \"%1\" feed from the list?").arg(feeds[feed].title))==KMessageBox::Yes) {
			KIO::del(locateLocal("appdata", feeds[feed].key+"-data"));
			for (int i=feed;i<feeds_count-1;i++) {
				feeds[i]=feeds[i+1];
			}
			feeds_count--;
			updateFeedlist();
			setEmptyPage();
			saveConfig();
		}
	} else {
		KMessageBox::error(this,i18n("Local collection is unremovable"));
	}
}


void Kitty::addArticle() {
	raw_addArticle(selected_feed);
}

void Kitty::editArticle() {
	raw_editArticle(selected_article);
}

void Kitty::publishFeed() {
	kitty_publish *a=new kitty_publish(this);
	a->setFeed(feeds[0]);
	a->setOutput(kitty_globals::settings.hostname,kitty_globals::settings.pub_hostname,kitty_globals::settings.username,kitty_globals::settings.password);
	a->setUploadVideos(kitty_globals::settings.publish_movies);
	a->setUploadThumbnails(kitty_globals::settings.publish_thumbs);
	a->publish();
	if (kitty_globals::settings.publish_update_guide) {
		doSuggest(0,kitty_globals::settings.pub_hostname+"feed.xml");
	}
}

void translateState(QString state,QString &label,QString &icon) {
	if (state=="downloading") { label=i18n("Downloading"); icon="bottom"; }
	if (state=="starting") { label=i18n("Starting"); icon="launch"; }
	if (state=="downloaded") { label=i18n("Downloaded"); icon="bookmark"; }
	if (state=="partial") { label=i18n("Partially downloaded"); icon="file"; }
}

void Kitty::addToMyCollection() {
	raw_addToMyCollection(selected_article);
}

void Kitty::disposeVideo() {
	if (m_video) {
		m_video->closeURL();
		delete m_video;
		m_video=0;
	}
	videodetails->setText("");
	playingfeed=-1;
	playingarticle=-1;
}

void Kitty::setEmptyPage() {
	if (current_interface!=1) {
		diz->setText(i18n("Description"));
		articles->clear();	
		videodetails->clear();
		cururl->clear();
		tabs->setCurrentPage(0);
	}
	feed_detail->begin();
	feed_detail->end();
	disposeVideo();
	alltabs->setCurrentPage(videoPage);
}

void Kitty::setCollectionPage() {
	feedbox->setCurrentItem(special);
	clickFeed(special);
}

void Kitty::cancelDownload() {
	raw_cancelDownload(selected_article);
}

void Kitty::updateDownloadStatus() {
	QString str;
	int allpercent=0;
	int items=0;
	QDir *mydir=new QDir();
	QString strstatus="";
	/*
		Set stored flags on retrived articles
	*/
	for (int i=0;i<feeds[0].items_count;i++) {
		if (feeds[0].items[i].downloader) {
			/* status changed */
			QString newstatus=feeds[0].items[i].downloader->getState();
			if (feeds[0].items[i].dlstatus != newstatus) {
				feeds[0].items[i].dlstatus=newstatus;
				saveConfig();
				if (newstatus=="downloaded") {
					KPassivePopup::message( i18n("New media downloaded"), feeds[0].items[i].title, SmallIcon("bookmark"), trayIcon );
					feeds[0].items[i].downloader->cancel();
					delete feeds[0].items[i].downloader;
					feeds[0].items[i].downloader=0;
				}
			}
			if (feeds[0].items[i].downloader && feeds[0].items[i].downloader->getDone()==0) {
				items++;
				allpercent+=feeds[0].items[i].downloader->getPercent();
			}
		}
	}
	/*
		Latent thumbnail downloader
		(if it isn't busy)
	*/
	bool downstarted=false;
	if (!local_downloader || local_downloader->getDone()==1) {
		for (int i=0;i<feeds[selected_feed].items_count && !downstarted;i++) {
			QString imgfile=locateLocal("appdata", feeds[selected_feed].key+"-data/"+feeds[selected_feed].items[i].key+".png");
			if (!mydir->exists(imgfile)) {
				// se non esiste la thumbnail
				if (!feeds[selected_feed].items[i].thumbnail.isEmpty()) {
					strstatus=strstatus+i18n("Downloading thumbs. ");
					local_downloader=new Kitten(feeds[selected_feed].items[i].thumbnail,imgfile,false);
					downstarted=true;
				}
			}
		}
	} else {
		items++;
		allpercent+=local_downloader->getPercent();
	}

	/*
		Updates the retrival list
	*/
	if (current_interface==1) {
		QString state;
		int percent;
		for (int j=0;j<feeds[selected_feed].items_count;j++) {
			state=feeds[selected_feed].items[j].dlstatus;
			percent=0;
			if (feeds[selected_feed].items[j].downloader && feeds[selected_feed].items[j].downloader->getDone()==0) {
				state=feeds[selected_feed].items[j].downloader->getState();
				percent=feeds[selected_feed].items[j].downloader->getPercent();
			}
			QString play="";
			if (selected_feed==playingfeed && j==playingarticle) { play="playing"; } else { play=""; }
			feed_detail->executeScript("setState('"+play+"','"+state+"',"+str.sprintf("%d,%d",percent,j)+")");
		}
	} else {
		int imgloaded=0;
		QListViewItemIterator it( articles );
		while ( it.current() ) {
			QListViewItem *item = it.current();
			int i=item->text(meta_column).toInt();
			if (selected_feed==playingfeed && i==playingarticle) {		
				item->setPixmap(1,SmallIcon("player_play"));
			} else {
				item->setPixmap(1,nullPixmap);
			}
			if (selected_feed==0) {
				QString state="";
				QString image="";
				state=feeds[selected_feed].items[i].dlstatus;
				QString icona;
				translateState(state,state,icona);
				if (feeds[selected_feed].items[i].downloader && feeds[0].items[i].downloader->getDone()==0) {
					state=state+" ("+str.sprintf("%d",feeds[selected_feed].items[i].downloader->getPercent())+"%)";
				}
				if (!icona.isEmpty()) { item->setPixmap(3,SmallIcon(icona)); } else { item->setPixmap(3,nullPixmap); }
				item->setText(3,state);
			}
			/* if it's not downloading stuff, set images */
			if (imgloaded<3 && (!local_downloader || local_downloader->getDone()==1)) { 
				QString imgfile=locateLocal("appdata", feeds[selected_feed].key+"-data/"+feeds[selected_feed].items[i].key+".png");
				if (mydir->exists(imgfile,true) &&  item->text(meta_column+1)=="0") {
					if (imgloaded==0) strstatus=strstatus+i18n("Updating list. ");
					item->setPixmap(0,readScaledPixmap(imgfile));
					item->setText(meta_column+1,"1");
					imgloaded++;
				}
			}
			++it;
		}
	/*
		update the download gauge
	*/
	}
	if (items!=0 && (allpercent/items!=100)) {
		downloading->setValue(allpercent/items);
		downloading->setHidden(false);
		strstatus=strstatus+i18n("Downloading %1 media. ").arg(items);
	} else {
		downloading->setHidden(true);
	}
	/*
		updates messages
	*/
	if (strstatus.isEmpty()) strstatus=i18n("Ready.");
	strstatus+=" "+subscriber_status;
	strstatus=strstatus.stripWhiteSpace();
	QToolTip::add(trayIcon,strstatus);
	statusMessages->setText(strstatus);
	/*
		Next refresh
	*/
	refresher->start( refresh_time, TRUE );
}

void Kitty::showPrefs() {
    QString str;
    Kitty_prefs dlg;
    dlg.localsettings=kitty_globals::kitty_globals::settings;
    dlg.updateWidgets();
    if (dlg.exec())
    {
	    if (kitty_globals::settings.interface!=dlg.localsettings.interface) {
		KMessageBox::information(this,i18n("The new interface will be applied on the next restart."));
	    }
	    if (kitty_globals::settings.skin!=dlg.localsettings.skin) {
		kitty_globals::settings.skin=dlg.localsettings.skin;
		applySkin();
		clickFeed(special);
	    }
	    kitty_globals::settings=dlg.localsettings;
	    stateChanged("publisher",	kitty_globals::settings.publishenabled==1 ? StateNoReverse : StateReverse);
	    saveConfig();
    }
}

void Kitty::refreshAllFeeds() {
	/*
		Skips the "my collection" feed
	*/
	for (int i=1;i<feeds_count;i++)  {
		refreshFeed(i);
	}
	viewFeed(selected_feed);
}

void Kitty::addFeed() {
	addurl("");
}

void Kitty::refreshCurrentFeed() {
	refreshFeed(selected_feed);
	viewFeed(selected_feed);
}

void Kitty::removeFeed() {
	raw_deleteFeed(selected_feed);
}

void Kitty::purgeArticle() {
	if (articles->selectedItem()) {
		raw_purgeArticle(selected_article);
	}
}

void Kitty::removeArticle() {
	if (articles->selectedItem()) {
		raw_removeArticle(selected_article);
	}
}


void Kitty::updateFeed(int id) {
    QFile opmlFile( feeds[id].tmpfile );
    opmlFile.open( IO_ReadOnly );
    domTree.setContent( &opmlFile );
    opmlFile.close();
    QDomElement root = domTree.documentElement();
    QDomNode node;
    node = root.firstChild();
    while ( !node.isNull() ) {
	// look for channel
        if ( node.isElement() && node.nodeName() == "channel" ) {
	    QDomNode level2 = node.toElement().firstChild();
	    while ( !level2.isNull() ) {
		if ( level2.isElement() ) {
			QDomText textChild = level2.firstChild().toText();
			if (level2.nodeName()=="kitty_key") { feeds[id].key=textChild.nodeValue(); }
			if (level2.nodeName()=="title") { feeds[id].title=textChild.nodeValue(); }
			if (level2.nodeName()=="description") { feeds[id].description=textChild.nodeValue(); }
			if (level2.nodeName()=="author") { feeds[id].author=textChild.nodeValue(); }
			if (level2.nodeName()=="item") {
			    QDomNode level3 = level2.toElement().firstChild();
			    int itd=feeds[id].items_count;
			    while ( !level3.isNull() ) {
				if ( level3.isElement() ) {
					QDomText textChild = level3.firstChild().toText();
					if (level3.nodeName()=="title") { feeds[id].items[itd].title=textChild.nodeValue(); }
					if (level3.nodeName()=="kitty_key") { feeds[id].items[itd].key=textChild.nodeValue(); }
					if (level3.nodeName()=="kitty_dlstatus") { 
						feeds[id].items[itd].dlstatus=textChild.nodeValue();
						/*
							If was saved during downloading, these will be "partial"
						*/
						if (feeds[id].items[itd].dlstatus=="downloading") { feeds[id].items[itd].dlstatus="partial"; }
						/*
							Just started download are nothing.
						*/
						if (feeds[id].items[itd].dlstatus=="starting") { feeds[id].items[itd].dlstatus=""; }
					}
					if (level3.nodeName()=="link") { feeds[id].items[itd].link=textChild.nodeValue(); }
					if (level3.nodeName()=="description") { feeds[id].items[itd].description=textChild.nodeValue(); }
					if (level3.nodeName()=="author") { feeds[id].items[itd].author=textChild.nodeValue(); }
					if (level3.nodeName()=="enclosure") { 
						if (level3.hasAttributes()) {
							feeds[id].items[itd].file=level3.attributes().namedItem("url").nodeValue();
						}
					}
					if (level3.nodeName()=="media:thumbnail") { 
						if (level3.hasAttributes()) {
							feeds[id].items[itd].thumbnail=level3.attributes().namedItem("url").nodeValue();
						}
					}
				}
				level3 = level3.nextSibling();
			    }
			    if (feeds[id].items[feeds[id].items_count].key.isEmpty()) {
				// @todo old generator
				//feeds[id].items[feeds[id].items_count].key=generateUnique(feeds[id].items[feeds[id].items_count].title+feeds[id].items[feeds[id].items_count].description+feeds[id].items[feeds[id].items_count].file);
				feeds[id].items[feeds[id].items_count].key=generateUnique();
			    }
			    feeds[id].items_count++;
			}
		}
		level2 = level2.nextSibling();
	    }
	    break;
        }
        node = node.nextSibling();
    }
    if (feeds[id].key.isEmpty()) {
	// @todo old generator
	 //feeds[id].key=generateUnique(feeds[id].url+feeds[id].description+feeds[id].title+feeds[id].author);
	feeds[id].key=generateUnique();
    }
    saveConfig();
}

QString boolToString(bool value) {
	if (value) { return "TRUE"; } else { return "FALSE"; }
}

QString Kitty::htmlReplacer(QString from,int id,int i) {
	QString str;
	QDir *mydir=new QDir();
	from.replace("%ROOT%",skin_path);
	from.replace("%ARTICLES_COUNT%",str.sprintf("%d",feeds[id].items_count));
	from.replace("%ARTICLE_HAS_VIDEO%",boolToString(feedLogic(id,feeds[id], i, "has_video")));
	from.replace("%ARTICLE_IS_DOWNLOADED%",boolToString(feedLogic(id,feeds[id], i, "is_downloaded")));
	from.replace("%ARTICLE_IS_DOWNLOADABLE%",boolToString(feedLogic(id,feeds[id], i, "is_downloadable")));
	from.replace("%ARTICLE_IS_PURGEABLE%",boolToString(feedLogic(id,feeds[id], i, "is_purgeable")));
	from.replace("%ARTICLE_IS_REMOVABLE%",boolToString(feedLogic(id,feeds[id], i, "is_removable")));
	from.replace("%ARTICLE_IS_COLLECTABLE%",boolToString(feedLogic(id,feeds[id], i, "is_collectable")));
	from.replace("%ARTICLE_IS_EDITABLE%",boolToString(feedLogic(id,feeds[id], i, "is_editable")));
	from.replace("%FEED_IS_ADDABLE%",boolToString(feedLogic(id,feeds[id], i, "feed_is_addable")));
	from.replace("%FEED_IS_REMOVABLE%",boolToString(feedLogic(id,feeds[id], i, "feed_is_removable")));
	from.replace("%FEED_IS_EDITABLE%",boolToString(feedLogic(id,feeds[id], i, "feed_is_editable")));
	from.replace("%FEED_TITLE%",feeds[id].title);
	from.replace("%FEED_DESCRIPTION%",feeds[id].description);
	from.replace("%FEED_AUTHOR%",feeds[id].author);
	from.replace("%ARTICLE_LINK%",feeds[id].items[i].link);
	from.replace("%ARTICLE_AUTHOR%",feeds[id].items[i].author);
	from.replace("%ARTICLE_ROOT%",skin_path);
	from.replace("%ARTICLE_ID%",str.sprintf("%d",i));
	from.replace("%ARTICLE_TITLE%",feeds[id].items[i].title);
	from.replace("%ARTICLE_DESCRIPTION%",KCharsets::resolveEntities(feeds[id].items[i].description));
	QString thumb;
	QString imgfile=locateLocal("appdata", feeds[id].key+"-data/"+feeds[id].items[i].key+".png");
	if (mydir->exists(imgfile)) { 
		thumb=imgfile;
	} else {
		if (feeds[id].items[i].thumbnail.isEmpty()) {
			thumb=skin_path+"kitty-novideo.png";
		} else {
			thumb=feeds[id].items[i].thumbnail;
		}
	}
	from.replace("%ARTICLE_THUMBNAIL%",thumb);
	return from;
}

void Kitty::viewFeed(int id) {
	if (current_interface==1) {
		feed_detail->begin();
		feed_detail->write(htmlReplacer(skin_head,id,0));
		for (int i=0;i<feeds[id].items_count;i++) {
			feed_detail->write(htmlReplacer(skin_module,id,i));
		}
		feed_detail->write(htmlReplacer(skin_footer,id,0));
		feed_detail->write("<script>\n"+htmlReplacer(skin_js,id,0)+"\n</script>");
		feed_detail->end();
	} else {
		QString str;
		//QDir *mydir=new QDir();
		setEmptyPage();
		diz->setText("<b>"+feeds[id].title+"</b>");
		cururl->setText(feeds[id].url);
		for (int i=0;i<feeds[id].items_count;i++) {
			KListViewItem *itm=new KListViewItem( articles, "",feeds[id].items[i].title, feeds[id].title, "",str.sprintf("%d",i),"0");
			/* if there is his icon, loads that icon */
			/* @TODO seems slow... commented */
			/*
			QString imgfile=locateLocal("appdata", feeds[id].key+"-data/"+feeds[id].items[i].key+".png");
			if (!feeds[id].items[i].thumbnail.isEmpty() && mydir->exists(imgfile,true)) {
				itm->setPixmap(0,readScaledPixmap(imgfile));
				itm->setText(meta_column+1,"1");
			} else {
			*/
				QString icon="video";
				if (!feeds[id].items[i].title.isEmpty()) {
					QString extension=feeds[id].items[i].file.mid(feeds[id].items[i].file.findRev(".")+1).upper().left(4).stripWhiteSpace();
					if (!kitty_globals::settings.audioExtensions.grep(extension,false).isEmpty()) {
						icon="sound";
					}
					itm->setText(0,extension);
				}				
				if (feedLogic(id,feeds[id], i, "has_video") || feedLogic(id,feeds[id], i, "is_downloaded"))
					itm->setPixmap(0,DesktopIcon(icon));
				else itm->setPixmap(0,DesktopIcon("kitty"));

			/* } */
		}
		QString details="<font size=\"2\"><b>"+feeds[id].title+"</b><br><br>";
		details+=feeds[id].description+"<br><br>";
		if (!feeds[id].author.isEmpty()) { details+="<b>"+i18n("Author")+":</b> <A HREF=\"mailto:"+feeds[id].author+"\">"+feeds[id].author+"<br>"; }
		details+="</font>";
		feed_detail->begin();
		feed_detail->write(details);
		feed_detail->end();
	}
	/*
		Feed actions
	*/
	selected_feed=id;
	if (selected_feed==0) {
		stateChanged("my_feed");
	} else {
		stateChanged("subscribed_feed");
	}
	if (feedLogic(id,feeds[id],0,"feed_is_editable")) {
		stateChanged("feed_is_editable");
	} else {
		stateChanged("feed_is_not_editable");
	}
} 

void Kitty::clickArticle(QListViewItem* itm) {
	if (itm && (current_interface==0)) {
		disposeVideo();
		selected_article=itm->text(meta_column).toInt();
		QString details="<font size=2><b>"+feeds[selected_feed].items[selected_article].title+"</b><br>";
		details+="<i>"+feeds[selected_feed].title+"</i><br><br>";
		if (!feeds[selected_feed].items[selected_article].description.isEmpty()) {
			details+=KCharsets::resolveEntities(feeds[selected_feed].items[selected_article].description)+"<br><br>";
		}
		if (!feeds[selected_feed].items[selected_article].link.isEmpty()) {
			details+="<B>"+i18n("URL")+":</b> <A HREF=\""+feeds[selected_feed].items[selected_article].link+"\">"+feeds[selected_feed].items[selected_article].link+"</A><br>";
		}
		if (!feeds[selected_feed].items[selected_article].file.isEmpty()) {
			details+="<B>"+i18n("File")+":</b> <A HREF=\""+feeds[selected_feed].items[selected_article].file+"\">"+feeds[selected_feed].items[selected_article].file+"</A><br>";
		}
		if (!feeds[selected_feed].items[selected_article].author.isEmpty()) { details+="<b>"+i18n("Author")+":</b> <A HREF=\"mailto:"+feeds[selected_feed].items[selected_article].author+"\">"+feeds[selected_feed].items[selected_article].author+"<br>"; 
		}
 		details+="</font>";
		feed_detail->begin();
		feed_detail->write(details);
		feed_detail->end();
		tabs->setCurrentPage(0);
		/*
			Changes states of video player
		*/
		
		if (feedLogic(selected_feed,feeds[selected_feed],selected_article,"has_video")||feedLogic(selected_feed,feeds[selected_feed],selected_article, "is_downloaded")) {
			play->setEnabled(true);
			stateChanged("has_video");
		} else {
			play->setEnabled(false);
			stateChanged("not_has_video");
		}
		/*
			Not in collection, downloading/downloaded video or articles without video cannot be downloaded
		*/

		if (
			feedLogic(selected_feed,feeds[selected_feed],selected_article,"is_downloadable") &&
			!feedLogic(selected_feed,feeds[selected_feed],selected_article,"is_downloading") &&
			!feedLogic(selected_feed,feeds[selected_feed],selected_article,"is_downloaded") 
		   ) 
		{
			stateChanged("can_download");
		} else {
			stateChanged("cannot_download");
		}
		/*
			Not downloading articles and only collected can be removed
		*/
		if (
			feedLogic(selected_feed,feeds[selected_feed],selected_article,"is_removable")
		   )
		{
			stateChanged("can_remove_article");
		} else {
			stateChanged("cannot_remove_article");
		}
		/*
			Started downloads can be cancelled
		*/
		if (
			feedLogic(selected_feed,feeds[selected_feed],selected_article,"is_download_cancelable") 
		) {
			stateChanged("can_cancel_download");
		} else {
			stateChanged("cannot_cancel_download");
		}

	} else {
		/*
			Video player is disabled for no-item selected
		*/
		stateChanged("disable_all");
	}
}

void Kitty::pickVideo(int feed, int article,QString &url, QString &mime) {
	mime="";
	// prefer locally stored files
	if (feeds[feed].items[article].dlstatus=="downloaded") {
		url=locateLocal("appdata", feeds[feed].key+"-data/"+feeds[feed].items[article].key);
	} else {
		if (!feeds[feed].items[article].file.isEmpty()) {
			url=feeds[feed].items[article].file;
			mime="video/avi";
		}
	} 

}

void Kitty::openVideo() {
	raw_openVideo(selected_article);
}

void Kitty::playVideo() {
	raw_playVideo(selected_article);
	return;
}

bool Kitty::refreshFeed(int id) {
	/*
		Check if local feed exists
	*/
	if (id==0) {
		if (!QFile::exists(feeds[id].url)) {
			saveLocalFeed();
		}
	}
	feeds[id].title="Unknown title";
	feeds[id].description="";
	feeds[id].items_count=0;
	if( KIO::NetAccess::download( feeds[id].url, feeds[id].tmpfile, this ) )
	{
		updateFeed(id);
		upDateFeedList(id);
		KIO::NetAccess::removeTempFile( feeds[id].tmpfile );
		return true;
	} else {
		QString error=KIO::NetAccess::lastErrorString();
		if (error.isEmpty()) {
			KMessageBox::error(this, i18n("Feed update failed.") );
		} else  {
			KMessageBox::error(this, error );
		}
		return false;
	}
}

void Kitty::clickFeed(QListViewItem* itm) {

	if (itm) {
		int id=itm->text(1).toInt();
		/*
			Autorefresh empty feeds (kitty_globals::settings)
		*/
		if (kitty_globals::settings.set_open_on_click) {
			if (feeds[id].items_count==0) {
				refreshFeed(id);
			}
		}
		viewFeed(id);
		alltabs->setCurrentPage(videoPage);
	}
}

void Kitty::updateFeedlist() {
    QString str;
    feedbox->clear();
    feedbox->setRootIsDecorated(true);
    special=new KListViewItem( feedbox, i18n("Special feeds"));
    special->setOpen(true);
    special->setSelectable(false);
    KListViewItem *normal=new KListViewItem( feedbox, i18n("Subscribed feeds"));
    normal->setOpen(true);
    normal->setSelectable(false);
    for (int i=0;i<feeds_count;i++) {
	if (i==0) {
		KListViewItem *itm=new KListViewItem( special, feeds[i].title,str.sprintf("%d",i));
		itm->setPixmap(0,SmallIcon("bookmark"));
	} else {
		KListViewItem *itm=new KListViewItem( normal, feeds[i].title,str.sprintf("%d",i));
		itm->setPixmap(0,SmallIcon("folder"));
	}
    }
}

void Kitty::addurl(QString url) {
	if (feeds_count>=99) {
		KMessageBox::error(this,i18n("Your channel list is full. Please, remove some channels and retry."));
	} else {
		QString newUrl=KInputDialog::getText(i18n("Add feed"),i18n("New feed URL:"),url);
		if (!newUrl.isEmpty()) {
			bool found=false;
			for (int i=0;i<feeds_count;i++) {
				if (feeds[i].url==url) {
					found=true; break;
				}
			}
			if (found) {
				KMessageBox::information(this,i18n("This feed is already in your subscribed feeds list."));
			} else {
				feeds[feeds_count].url=newUrl;
				if (refreshFeed(feeds_count)) {
					if (kitty_globals::settings.autosubmit_feed) {
						doSuggest(feeds_count,feeds[feeds_count].url);
					}
				}
				KIO::mkdir(locateLocal("appdata", feeds[feeds_count].key+"-data"));
				feeds_count++;
				updateFeedlist();
				saveConfig();
			}
		}
	}
}

void Kitty::clickHome() {
	QStringList itms=QStringList::split("|",*kitty_globals::guides.at(kitty_globals::settings.selectedGuide));
	browseURL(*itms.at(1));
	alltabs->setCurrentPage(guidePage);
}


void Kitty::yahoo_loaded() {
	if (yahoo_done==0) {
		yahoo_done=1;
		QString src=yahoo_link->htmlDocument().body().innerHTML().string();
		src=src.mid(src.find("RSS:")+4).stripWhiteSpace().mid(9);
		src=src.left(src.find("\" "));
		subscriber_status="";
		addurl(src);
	}
}

void Kitty::page_loaded() {
	if (page_done==0) {
		page_done=1;
		/* @TODO: page handling, when I'll learn how to do. */
	}
}


void Kitty::openURLRequest(const KURL &url, const KParts::URLArgs & args) {
	if (url.queryItem(kitty_globals::settings.trap_var).left(kitty_globals::settings.trap.length())==kitty_globals::settings.trap) {
			// DTV Url grabber
			addurl(url.queryItem(kitty_globals::settings.url_var));
	} else if (url.queryItem("q")=="channel/subscribe/") {
			// Kitty guide (old dtv way)
			addurl(url.queryItem("suburl"));
	} else if ((url.host()=="podcasts.yahoo.com") && (url.queryItem("as")=="a")) {
		// Yahoo! grabber
		subscriber_status=i18n("Subscribing Yahoo! Podcast feed...");
		yahoo_done=0;
		QString newurl=url.url();
		newurl.remove("&as=a");
		yahoo_link=new KHTMLPart(this);
		yahoo_link->hide();
		connect(yahoo_link,SIGNAL(completed()),this,SLOT(yahoo_loaded()));
		yahoo_link->openURL(newurl);
	} else if (url.fileName().right(4).upper()==".XML") {
		// XML will be added
		addurl(url.url());
	} else {
		if (args.doPost()) {
			browser->browserExtension()->setURLArgs(args);
		}
		browseURL(url.url());
	}
} 

void Kitty::detailsOpenURLRequest(const KURL &url, const KParts::URLArgs & ) {
	if (current_interface==1) {
		if (url.protocol()=="play") raw_playVideo(url.host().toInt());
		
		else if (url.protocol()=="gotomycollection") clickFeed(special);
		else if (url.protocol()=="gotovideo") alltabs->setCurrentPage(moviePage);
		else if (url.protocol()=="addarticle") raw_addArticle(selected_feed);
		else if (url.protocol()=="feededit") raw_editFeed(selected_feed);
		else if (url.protocol()=="feeddelete") raw_deleteFeed(selected_feed);
		else if (url.protocol()=="cancel") raw_cancelDownload(url.host().toInt());
		else if (url.protocol()=="collect") raw_addToMyCollection(url.host().toInt());
		else if (url.protocol()=="open") raw_openVideo(url.host().toInt());
		else if (url.protocol()=="purge") raw_purgeArticle(url.host().toInt());
		else if (url.protocol()=="remove") raw_removeArticle(url.host().toInt());
		else if (url.protocol()=="download") startDownload(selected_feed,url.host().toInt());
		else if (url.protocol()=="edit") raw_editArticle(url.host().toInt());
		else if (url.protocol()=="stop") raw_stop();
		else new KRun(url.url());
	} else {
		new KRun(url.url());
	}
}

void Kitty::feedbox_contextMenuRequested(QListViewItem*tmo, const QPoint&pnt, int ) {
 clickFeed(tmo);
 QPopupMenu *pop = (QPopupMenu *)factory()->container("feedbox_popup", this); 
 pop->popup(pnt);
}

void Kitty::articles_contextMenuRequested(QListViewItem*tmo, const QPoint&pnt, int) {
 clickArticle(tmo);
 QPopupMenu *pop = (QPopupMenu *)factory()->container("articles_popup", this); 
 pop->popup(pnt);
}

void Kitty::saveLocalFeed() {
	QFile file( feeds[0].url );
	if ( file.open( IO_WriteOnly ) ) {
		QTextStream stream( &file );
		stream << "<rss>\n";
		stream << "<channel>\n";
		stream << "<title>"+htmlIze(feeds[0].title)+"</title>\n";
		stream << "<description>"+htmlIze(feeds[0].description)+"</description>\n";
		stream << "<kitty_key>"+htmlIze(feeds[0].key)+"</kitty_key>\n";
		stream << "<author>"+i18n("Me")+"</author>\n";
		for (int i=0;i<feeds[0].items_count;i++) {
			stream << "<item>\n";
			stream << "<media:thumbnail url=\""+htmlIze(feeds[0].items[i].thumbnail)+"\"/>\n";
			stream << "<title>"+htmlIze(feeds[0].items[i].title)+"</title>\n";
			stream << "<kitty_key>"+htmlIze(feeds[0].items[i].key)+"</kitty_key>\n";
			stream << "<kitty_dlstatus>"+htmlIze(feeds[0].items[i].dlstatus)+"</kitty_dlstatus>\n";
			stream << "<link>"+htmlIze(feeds[0].items[i].link)+"</link>\n";
			stream << "<description><![CDATA["+htmlIze(feeds[0].items[i].description)+"]]></description>\n";
			stream << "<author>"+htmlIze(feeds[0].items[i].author)+"</author>\n";
			stream << "<enclosure url=\""+htmlIze(feeds[0].items[i].file)+"\"/>\n";
			stream << "</item>\n";
		}
		stream << "</channel>\n";
		stream << "</rss>\n";
		file.close();
	}
}

void Kitty::firstReadOpt() {
	// these infos are needed before loading the gui
	KConfig *config=kapp->config();
	config->setGroup("Settings");
	kitty_globals::settings.skin=config->readEntry("skin",""); 
	kitty_globals::settings.interface=config->readNumEntry("interface",0); 
	// current interface is the first loaded. Changes will be applied on restart
	current_interface=kitty_globals::settings.interface;
}

void Kitty::readOpt() {
	QString str;
	QStringList voidlist;
	QStringList defaultAudioExtensions;
	defaultAudioExtensions.append("MP3");
	defaultAudioExtensions.append("WMA");
	defaultAudioExtensions.append("AAC");
	KConfig *config=kapp->config();
	config->setGroup("Layout");
	if (current_interface==1) {
	} else {
		horz->setSizes(config->readIntListEntry("horz"));
		split->setSizes(config->readIntListEntry("split"));
	}
	config->setGroup("Settings");

	kitty_globals::settings.publishenabled=config->readNumEntry("publishenabled",0); 
	kitty_globals::settings.username=config->readEntry("username",""); 
	kitty_globals::settings.password=config->readEntry("password",""); 
	kitty_globals::settings.hostname=config->readEntry("hostname",""); 
	kitty_globals::settings.pub_hostname=config->readEntry("pub_hostname",""); 

	kitty_globals::settings.publish_movies=config->readBoolEntry("publish_movies",false); 
	kitty_globals::settings.publish_thumbs=config->readBoolEntry("publish_thumbs",false); 
	kitty_globals::settings.publish_update_guide=config->readBoolEntry("publish_update_guide",true); 


	kitty_globals::settings.autosubmit_feed=config->readBoolEntry("autosubmit_feed",true); 
	kitty_globals::settings.first_start=config->readBoolEntry("first_start",true); 
	kitty_globals::settings.restart_partial=config->readBoolEntry("restart_partial",false); 
	kitty_globals::tastes=config->readListEntry("tastes",voidlist);
	kitty_globals::settings.audioExtensions=config->readListEntry("audioExtensions",defaultAudioExtensions);
	kitty_globals::settings.selectedGuide=config->readNumEntry("selected_guide",0); 
	kitty_globals::settings.start_minimized=config->readBoolEntry("start_minimized",false); 
	kitty_globals::settings.bittorrent_client=config->readEntry("bittorrent_client","bittorrent-console"); 
	kitty_globals::settings.set_open_on_click=config->readBoolEntry("set_open_on_click",false);
	kitty_globals::settings.set_download_on_collect=config->readBoolEntry("set_download_on_collect",false); 
	kitty_globals::settings.trap=config->readEntry("trap","channel/newsubscribe/"); 
	kitty_globals::settings.trap_var=config->readEntry("trap_var","q"); 
	kitty_globals::settings.url_var=config->readEntry("url_var","suburl"); 
	config->setGroup("Feeds");
	feeds_count=config->readUnsignedNumEntry("feedlist_count",1);
	for (int i=1;i<feeds_count;i++) {
		QString id=str.sprintf("%d",i);
		feeds[i].title=config->readEntry("title_"+id,"");
		feeds[i].url=config->readEntry("url_"+id,"");
		feeds[i].description=config->readEntry("description_"+id,"");
		feeds[i].items_count=0;
	}
	feeds[0].title=i18n("My media collection");
	feeds[0].url=locateLocal("appdata", "localfeed.xml");
	feeds[0].description=i18n("Locally stored movies.");
	feeds[0].items_count=0;
	feeds[0].key="my_media";
	KIO::mkdir(locateLocal("appdata", feeds[0].key+"-data"));
	KIO::mkdir(locateLocal("appdata", "skins"));
}

void Kitty::saveConfig() 
{
	QString str;
	KConfig *config=kapp->config();
	config->setGroup("Layout");
	if (current_interface==1) {
	} else {		
		config->writeEntry("horz",horz->sizes());
		config->writeEntry("split",split->sizes());
	}
	config->setGroup("Settings");
	config->writeEntry("publishenabled",kitty_globals::settings.publishenabled);
	config->writeEntry("username",kitty_globals::settings.username);
	config->writeEntry("password",kitty_globals::settings.password);
	config->writeEntry("hostname",kitty_globals::settings.hostname);
	config->writeEntry("publish_update_guide",kitty_globals::settings.publish_update_guide);
	config->writeEntry("pub_hostname",kitty_globals::settings.pub_hostname);
	config->writeEntry("publish_movies",kitty_globals::settings.publish_movies);
	config->writeEntry("publish_thumbs",kitty_globals::settings.publish_thumbs);

	config->writeEntry("skin",kitty_globals::settings.skin);
	config->writeEntry("interface",kitty_globals::settings.interface);
	config->writeEntry("autosubmit_feed",kitty_globals::settings.autosubmit_feed);
	config->writeEntry("first_start",kitty_globals::settings.first_start);
	config->writeEntry("restart_partial",kitty_globals::settings.restart_partial);
	config->writeEntry("tastes",kitty_globals::tastes);
	config->writeEntry("audioExtensions",kitty_globals::settings.audioExtensions);
	config->writeEntry("selected_guide",kitty_globals::settings.selectedGuide);
	config->writeEntry("start_minimized",kitty_globals::settings.start_minimized);
	config->writeEntry("bittorrent_client",kitty_globals::settings.bittorrent_client);
	config->writeEntry("set_open_on_click",kitty_globals::settings.set_open_on_click);
	config->writeEntry("set_download_on_collect",kitty_globals::settings.set_download_on_collect);
	config->writeEntry("trap",kitty_globals::settings.trap); 
	config->writeEntry("trap_var",kitty_globals::settings.trap_var); 
	config->writeEntry("url_var",kitty_globals::settings.url_var); 
	config->setGroup("Feeds");
	config->writeEntry("feedlist_count",feeds_count);	
	for (int i=1;i<feeds_count;i++) {
		QString id=str.sprintf("%d",i);
		config->writeEntry("title_"+id,feeds[i].title);
		config->writeEntry("url_"+id,feeds[i].url);
		config->writeEntry("description_"+id,feeds[i].description);
	}
	saveLocalFeed();
	config->sync();
}

bool Kitty::queryExit() {
	if (reallyClose) {
		saveConfig();
		return true;
	} else {
		trayIcon->setInactive();
		return false;
	}
}

void Kitty::startDownload(int feed,int article) {
	if (feedLogic(feed,feeds[feed],article,"is_downloadable")) {
		if (feedLogic(feed,feeds[feed],article,"is_downloading")) {
			KMessageBox::information(this,i18n("This file is still downloading."));
		} else {
			if (feedLogic(feed,feeds[feed],article,"has_video")) {
				feeds[feed].items[article].downloader=new Kitten(feeds[feed].items[article].file,locateLocal("appdata", feeds[feed].key+"-data/"+feeds[feed].items[article].key),(feeds[feed].items[article].dlstatus=="partial"));
			} else {
				KMessageBox::information(this,"There is no media to download.");
			}
		}
	} else {
		KMessageBox::information(this,"Add this article to your collection before start downloading.");
	}
}

void Kitty::downloadVideo() {
	startDownload(selected_feed,selected_article);
}

void Kitty::reallyCloseEvent() {
	reallyClose=true;
	close();
}

void Kitty::selectGuide(int i) {
	kitty_globals::settings.selectedGuide=i;
	clickHome();
}

void Kitty::submitInProgress(int per) {
	if (per==100 && submitter_is_busy) {
		submitter_is_busy=false;
	}
}

void Kitty::doSuggest(int feed,QString url) {
	KURL a;
	KURL test=url;
	if (!test.isValid()) {
		KMessageBox::information(this,i18n("Sorry but this URL seems to be malformed.\nCheck your URL and retry.")); 
	} else {
		if (submitter_is_busy) {
			KMessageBox::error(this,"Sorry but Kitty is still submitting a feed. Please retry later.");
		} else {
			a.addQueryItem("action","Add new");
			a.addQueryItem("extra","no_output");
			a.addQueryItem("add_title",feeds[feed].title);
			a.addQueryItem("add_url",url);
			a.addQueryItem("add_diz",feeds[feed].description);
		
			QCString qdata=QCString(a.query().mid(1));
	
			KParts::URLArgs args;	
			args.setDoPost(true);
			args.postData=qdata;
			args.setContentType("Content-Type: application/x-www-form-urlencoded");
		
			submitter->browserExtension()->setURLArgs(args);
			submitter->openURL(kitty_globals::kitty_url);
			submitter_is_busy=true;
		}
	}
}

void Kitty::suggestFeed() {
	doSuggest(selected_feed,feeds[selected_feed].url);
}

void Kitty::nekotongue() {
	kitty_nekotongue *a=new kitty_nekotongue(0,this,this);
	a->show();
}

void Kitty::browseURL(QString url) {
	if (!browser->url().url().isEmpty()) { 
		history.push( browser->url().url() );
		historybtn->setEnabled(true);
	}
	page_done=0;
	browser->openURL(url);
}

void Kitty::historyBack() {
	if (!history.isEmpty()) {
		browser->openURL(history.pop() );
		if (history.isEmpty()) { historybtn->setEnabled(false); }
		alltabs->setCurrentPage(guidePage);
	}
}


void Kitty::firstStart() {
	kitty_globals::settings.first_start=false;
	kitty_nekotongue *a=new kitty_nekotongue(1,this,this);
	a->show();
}

void Kitty::browserSetValue(int i) {
	if (i!=100) {
		progress->setValue(i);
		progress->setHidden(false);
	} else {
		progress->setHidden(true);
	}
}
Kitty::Kitty()
    : KMainWindow( 0, "Kitty" )
{
    QTime midnight( 0, 0, 0 );
    srand( midnight.secsTo(QTime::currentTime()) );
    meta_column=4;
    refresh_time=500;
    reallyClose=false;
    nullPixmap=QPixmap();
    firstReadOpt();
    page_done=1;
    playingfeed=-1;
    playingarticle=-1;

    //
    // Actions
    //

    KStdAction::preferences(this, SLOT(showPrefs()), actionCollection());
    KStdAction::quit(this,SLOT(reallyCloseEvent()),actionCollection());
    KStdAction::home(this,SLOT(clickHome()),actionCollection());
    KStdAction::back(this,SLOT(historyBack()),actionCollection());

    (void)new KAction(i18n("Add feed"),SmallIcon("bookmark_add"),0,this,SLOT(addFeed()),actionCollection(),"feed_add");
    (void)new KAction(i18n("Refresh current feed"),SmallIcon("reload"),0,this,SLOT(refreshCurrentFeed()),actionCollection(),"feed_refresh");
    (void)new KAction(i18n("Refresh all feeds"),SmallIcon("flag"),0,this,SLOT(refreshAllFeeds()),actionCollection(),"feed_refreshall");
    (void)new KAction(i18n("Remove current feed"),SmallIcon("cancel"),0,this,SLOT(removeFeed()),actionCollection(),"feed_delete");
    (void)new KAction(i18n("Play media"),SmallIcon("forward"),0,this,SLOT(playVideo()),actionCollection(),"play_video");
    (void)new KAction(i18n("Open media"),SmallIcon("fileopen"),0,this,SLOT(openVideo()),actionCollection(),"open_video");
    (void)new KAction(i18n("Add to my collection"),SmallIcon("bookmark"),0,this,SLOT(addToMyCollection()),actionCollection(),"add_collection");
    (void)new KAction(i18n("Remove article"),SmallIcon("cancel"),0,this,SLOT(removeArticle()),actionCollection(),"remove_article");
    (void)new KAction(i18n("Purge article"),SmallIcon("emptytrash"),0,this,SLOT(purgeArticle()),actionCollection(),"purge_article");
    (void)new KAction(i18n("Download media"),SmallIcon("bottom"),0,this,SLOT(downloadVideo()),actionCollection(),"download_video");
    (void)new KAction(i18n("Cancel download"),SmallIcon("cancel"),0,this,SLOT(cancelDownload()),actionCollection(),"cancel_dl");
    (void)new KAction(i18n("Add to Kitty's guide"),SmallIcon("bookmark"),0,this,SLOT(suggestFeed()),actionCollection(),"suggest_feed");
    (void)new KAction(i18n("NekoTongue"),SmallIcon("kitty"),0,this,SLOT(nekotongue()),actionCollection(),"nekotongue");
    (void)new KAction(i18n("First run wizard"),SmallIcon("wizard"),0,this,SLOT(firstStart()),actionCollection(),"first_run");
    (void)new KAction(i18n("Publish collection"),SmallIcon("make_kdevelop"),0,this,SLOT(publishFeed()),actionCollection(),"publish");
    (void)new KAction(i18n("Edit feed"),SmallIcon("edit"),0,this,SLOT(editFeed()),actionCollection(),"feed_edit");
    (void)new KAction(i18n("Edit article"),SmallIcon("edit"),0,this,SLOT(editArticle()),actionCollection(),"edit_article");
    (void)new KAction(i18n("Add article"),SmallIcon("filenew"),0,this,SLOT(addArticle()),actionCollection(),"add_article");
    (void)new KAction(i18n("Stop playback"),SmallIcon("player_stop"),0,this,SLOT(raw_stop()),actionCollection(),"stop_player");

    QString file = locateLocal( "appdata", "bookmarks.xml" );
    KBookmarkManager* manager=KBookmarkManager::managerForFile(file,false);
    manager->setUpdate(true);
    manager->setShowNSBookmarks(false);
    KBookmarkOwner* bookmarkOwner=new kitty_bookmark(this);
    KActionMenu* bookmark=new KActionMenu(i18n( "&Bookmarks" ), "bookmark", actionCollection(), "bookmarks" );
    

    new KBookmarkMenu(manager, bookmarkOwner, bookmark->popupMenu(), this->actionCollection(), true);
    //
    // The whole gui
    //

	trayIcon=new KSystemTray(this,"kitty_trayicon");
	trayIcon->setPixmap(BarIcon("kitty"));
	trayIcon->show();

    connect(trayIcon,SIGNAL(quitSelected()),this,SLOT(reallyCloseEvent()));

    horz=new QSplitter(this);    
    feedbox=new KListView(horz);
    feedbox->addColumn(i18n("Feed"));
    feedbox->setFullWidth(true);

    alltabs=new QTabWidget(horz);
    alltabs->setMargin(KDialog::marginHint());

    videoPage=0;
    moviePage=1;
    if (current_interface==1) {
	QVBox *vert=new QVBox(this);
	feed_detail=new KHTMLPart(vert);
	alltabs->addTab(vert,"View");
	videobox=new QVBox(alltabs);
	videodetails=new QLabel("",videobox);
	videodetails->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Maximum);
	alltabs->addTab(videobox,i18n("Media"));
	guidePage=2;
    } else {
	guidePage=1;
	QVBox *vert=new QVBox(this);
	vert->setSpacing(KDialog::spacingHint());
	diz=new QLabel("",vert);
	diz->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Maximum);
	cururl=new KURLLabel(vert);
	split=new QSplitter(QSplitter::Vertical,vert);
	
	articles=new KListView(split);
	articles->setRootIsDecorated(false);
	articles->setAllColumnsShowFocus(true);
	articles->addColumn( i18n("Thumbnail") );
	articles->setColumnAlignment(0,Qt::AlignHCenter);
	articles->addColumn( i18n("Title") );
	articles->addColumn( i18n("Feed") );
	articles->addColumn( i18n("State") );
	articles->setFullWidth(true);
	tabs=new QTabWidget(split);
	tabs->setMargin(KDialog::marginHint());
	tabs->setMinimumHeight(300);
	
	QVBox *detbox=new QVBox(this);
	detbox->setSpacing(KDialog::spacingHint());
	feed_detail=new KHTMLPart(detbox);
	play=new QPushButton(i18n("Play content"),detbox);
	play->setEnabled(false);
	tabs->addTab(detbox,i18n("Details"));
	
	
	videobox=new QVBox(alltabs);
	videodetails=new QLabel("",videobox);
	videodetails->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Maximum);
	
	// Generates the video component
	
	tabs->addTab(videobox,i18n("Media"));
	
	alltabs->addTab(vert,"View");

    connect(articles,SIGNAL(clicked(QListViewItem* )),this,SLOT(clickArticle(QListViewItem* )));
    connect(play,SIGNAL(clicked()),this,SLOT(playVideo()));
    connect(articles,SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int )),SLOT(articles_contextMenuRequested(QListViewItem*, const QPoint&, int )));
   }
    // Generates the guide component
    QVBox *guidebox=new QVBox(this);
    guidebox->setSpacing(KDialog::spacingHint());

    QHBox *tools=new QHBox(guidebox);
    tools->setSpacing(KDialog::spacingHint());
    tools->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Maximum);
    QPushButton *homebutton=new QPushButton("",tools);
    homebutton->setPixmap(SmallIcon("gohome"));
    homebutton->setMinimumWidth(30);
    homebutton->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Ignored);
    historybtn=new QPushButton("",tools);
    historybtn->setPixmap(SmallIcon("back"));
    historybtn->setMinimumWidth(30);
    historybtn->setEnabled(false);
    historybtn->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Ignored);
    QLabel *guidelbl=new QLabel(i18n("Main guide"),tools);
    guidelbl->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Ignored);
    QComboBox *guides=new QComboBox(tools);
    for (QStringList::Iterator it=kitty_globals::guides.begin();it!=kitty_globals::guides.end();++it) {
	QStringList itms=QStringList::split("|",*it);
	guides->insertItem(SmallIcon("contents"),*itms.at(0));
    }
    progress=new KProgress(tools);
    progress->setMinimumWidth(200);
    progress->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Expanding);


    browser=new KHTMLPart( guidebox );

    alltabs->addTab(guidebox,"Guide");

    connect(guides,SIGNAL(activated(int )),this,SLOT(selectGuide(int)));
    connect(browser,SIGNAL(completed()),this,SLOT(page_loaded()));
    connect( browser->browserExtension(),
        SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
        this, SLOT( openURLRequest(const KURL &, const KParts::URLArgs & ) ) );
    connect( feed_detail->browserExtension(),
        SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
        this, SLOT( detailsOpenURLRequest(const KURL &, const KParts::URLArgs & ) ) );
    connect(browser->browserExtension(),SIGNAL(loadingProgress(int)),this,SLOT(browserSetValue(int )));
    connect(homebutton,SIGNAL(clicked()),this,SLOT(clickHome()));
    connect(historybtn,SIGNAL(clicked()),this,SLOT(historyBack()));
    connect(feedbox,SIGNAL(clicked(QListViewItem* )),this,SLOT(clickFeed(QListViewItem* )));
    setCentralWidget(horz); 

    // popup menus
    connect(feedbox,SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int )),SLOT(feedbox_contextMenuRequested(QListViewItem*, const QPoint&, int )));

    setMinimumWidth(1000);
    setMinimumHeight(800);

     QString pth=QDir::currentDirPath();
    // @todo when redistributem rem this line and unrem the other one.
    //setupGUI(ToolBar|Keys|StatusBar|Save|Create,pth+"/../../src/kittyui.rc");
    setupGUI(ToolBar|Keys|StatusBar|Save|Create,"kittyui.rc");
    stateChanged("disable_all");
    
    downloading=new KProgress(statusBar());
    downloading->setMaximumWidth(200);
    downloading->setMaximumHeight(downloading->fontMetrics().height());
    downloading->setHidden(true);
    statusMessages=new QLabel(statusBar());
    statusBar()->addWidget(statusMessages,1);
    statusBar()->addWidget(downloading);

    //
    // Prepares the submitter
    //
    submitter=new KHTMLPart( this );
    submitter->hide();
    connect(submitter->browserExtension(),SIGNAL(loadingProgress(int)),this,SLOT(submitInProgress(int )));
    submitter_is_busy=false;

    //
    // GUI is ready
    //
    readOpt();
    applySkin();
    updateFeedlist();
    refreshFeed(0);
    clickFeed(special);
    clickHome();
    stateChanged("publisher",	kitty_globals::settings.publishenabled==1 ? StateNoReverse : StateReverse);

    guides->setCurrentItem(kitty_globals::settings.selectedGuide);

   //
   // restart partial downloads (if selected)
   //
   if (kitty_globals::settings.restart_partial) {
	for (int i=0;i<feeds[0].items_count;i++) {
		if (feeds[0].items[i].dlstatus=="partial") { startDownload(0,i); }
	}
   }

    //
    // Welcome tutorial.
    //
    if (kitty_globals::settings.first_start) {
	firstStart();
    }

    refresher=new QTimer(this);
    connect( refresher, SIGNAL(timeout()), this, SLOT(updateDownloadStatus()) );
    refresher->start( refresh_time, TRUE ); // 2 seconds single-shot timer


}



Kitty::~Kitty()
{
}

#include "kitty.moc"
