/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

#ifdef G_OS_UNIX
# define UNIX_OK TRUE
# define DIRSEP_S "/"
# define DIRSEP '/'
# define LESSON_FONT "Monospace 18"
# define NORMAL_FONT "Serif 14"
#endif

#ifdef G_OS_WIN32
# define UNIX_OK FALSE
# define DIRSEP_S "\\"
# define DIRSEP '\\'
# define LESSON_FONT "Courier Bold 14"
# define NORMAL_FONT "Comic Sans MS 12"
# undef PACKAGE_LOCALE_DIR
# define PACKAGE_LOCALE_DIR "..\\lib\\locale"
# undef PACKAGE_DATA_DIR
# define PACKAGE_DATA_DIR "..\\share"
#endif

#define LOCAL TRUE
#define GLOBAL FALSE

/*
 * Interface
 */
gchar *main_get_data_path (void);

void main_set_data_path (gchar * path);

gchar *main_get_user_dir (void);

gchar *main_get_score_path (void);

gboolean main_preferences_exist (gchar * group, gchar * key);

void main_preferences_remove (gchar * group, gchar * key);

gchar *main_preferences_get_string (gchar * group, gchar * key);

void main_preferences_set_string (gchar * group, gchar * key, gchar * value);

gint main_preferences_get_int (gchar * group, gchar * key);

void main_preferences_set_int (gchar * group, gchar * key, gint value);

gboolean main_preferences_get_boolean (gchar * group, gchar * key);

void main_preferences_set_boolean (gchar * group, gchar * key, gboolean value);

/*
 * Initialization
 */
void main_initialize_global_variables (void);

void main_set_auto_state (void);

void main_window_init (void);

void main_window_pass_away (void);

/**********************************************************************
 * Extra functions
 */
/*
* Search for the user directory and create it if not found
*/
void assert_user_dir (void);

/*
 * Compare two strings, so that it applies to other sorting functions.
 */
gint comp_str (gconstpointer a, gconstpointer b);
