/***************************************************************************
                          grouptree.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapp.h>
#include "grouptree.h"
#include <kmessagebox.h>
#include <klocale.h>
#include <kleandisk.h>
#include "groupviewwidget.h"

#include <iostream.h>

GroupTree::GroupTree(GroupViewWidget * gvw) {
	_groupViewWidget = gvw;	
	_listView = gvw -> ListView1;
	_topItem = new QListViewItem (listView());
	connect(listView(), SIGNAL(clicked(QListViewItem *, const QPoint &, int )),SLOT(slotItemClicked(QListViewItem *, const QPoint &, int)));
	connect(listView(),SIGNAL(rightButtonPressed(QListViewItem *, const QPoint &, int )),SLOT(slotPopup(QListViewItem *, const QPoint &, int)));
	connect(groupViewWidget(), SIGNAL(cleanup(FileGroupExt*)),SLOT(slotCleanup(FileGroupExt*)));
	connect(this, SIGNAL(setupFileList(FileGroupBase *)), groupViewWidget(), SLOT(slotSetupFileList(FileGroupBase *)));
	connect(this, SIGNAL(setProperties(FileGroupBase *)), groupViewWidget(), SLOT(slotSetProperties(FileGroupBase *)));
	_groupList = new QList<FileGroupBase>;
	_groupList -> setAutoDelete(true);
}

GroupTree::~GroupTree(){
	delete _topItem;
}

void GroupTree::addGroup(FileGroupBase * g){
	_groupList -> append(g);
	connect(g, SIGNAL(status(QString)), groupViewWidget(), SLOT(slotSetStatus(QString)));
	setupItem(g,new QListViewItem(topItem()));
}

void GroupTree::removeGroup(QString n){
	removeGroup(group(n));
};

void GroupTree::removeGroup(FileGroupBase * g){
	_groupList -> remove(g);
	delete item(topItem(),g -> name());
};

unsigned int GroupTree::numMarked(){
	unsigned int r = 0;
	for (unsigned int i = 0; i < groupCount(); i++)
		if (group(i) -> isMarked())
			r++;
	return r;
}

void GroupTree::deleteTree(){
	while(groupCount() != 0)
		removeGroup(group(0));
}

void GroupTree::setupItem(FileGroupBase * g, QListViewItem * i){
	QString s;
	i -> setText(10, g -> name());
	i -> setText(0, QString(" ") + g -> name());
	s.setNum(g -> numFiles());
	i -> setText(2, s);
	s.setNum(float(g -> sizeGreen())/(1024 * 1024),'f',1);
	s += " M";
	i -> setText(3, s);
	s.setNum(float(g -> totalSize())/(1024 * 1024),'f',1);
	s += " M";
	i -> setText(4, s);

	if ( g -> totalSize() != 0){
		float p = float(g -> sizeGreen())/ g -> totalSize() * 100;
		int p2 = int(p);
		s.setNum(p2);
	}
	else
		s = "0";
	s += " %";
	i -> setText(5, s);
	s.setNum(g -> safetyLevel());
	i -> setText(6, s);
	groupToItem(g,i);
}

QString GroupTree::name(QListViewItem * i){
	QString s;
	if (i!= 0)
		s = i -> text(10);
	else
		s = "";
	return s;
}

QListViewItem * GroupTree::item(QListViewItem * parent, QString s){
	QListViewItem * ret = 0;
	if (parent != 0){
		QListViewItem * next = parent -> firstChild();
		while (next != 0){
			item( next, s);
			if ( s == name(next))
				ret = next;
			next = next -> nextSibling();
		}
	}
	return ret;
}

void GroupTree::deleteItem(QString s){
	delete item(topItem(), s);
}

bool GroupTree::hasAncestor(QListViewItem * i, QListViewItem * a){
	bool  b = false;
	while (i != 0){
		if (i == a){
			b = true;
			break;
		}
		i = i -> parent();
	}
	return b;
}

QListViewItem * GroupTree::itemHasChild(QListViewItem * i, QString s){
	QListViewItem * item = i -> firstChild(), * retitem = 0;
	while (item != 0){
		if (item -> text(0) == s){
			retitem = item;
			break;
		}
		else
			item = item -> nextSibling();
	}
	return retitem;
}

void GroupTree::slotCleanup(FileGroupExt * g){
	if (!g)
		return;
	if (type() != g -> type())
		return;
	if ( g -> numMarked() == 0)
		KMessageBox::information(0,i18n("No files have been marked. Mark one or more files"));
	if ( g -> numMarked()){
		cleanupWizard = new CleanupWizard(g);
		connect(cleanupWizard, SIGNAL(ready()),SLOT(slotCleanupEnded()));
		connect(cleanupWizard, SIGNAL(cancel()),SLOT(slotCleanupCancelled()));
		cleanupWizard -> show();
	}
}

QListViewItem * GroupTree::topItem(QListViewItem * i){
	QListViewItem * item = i;
	while ( item -> parent() != 0){
		item = item -> parent();
	}
	return item;
}

void GroupTree::slotItemClicked(QListViewItem * i, const QPoint & p, int j){
	if (i == 0)
		return;
	if (topItem(i) != topItem())
		return;
	SETWAIT;
	if (type() == TYPE_DUP)
		groupViewWidget() -> fileListView() -> setColumnWidth(3,40);
	else
		groupViewWidget() -> fileListView() -> setColumnWidth(3,0);
	itemClicked(i,p,j);
}

void GroupTree::setupReady(){
	if (topItem(listView() -> selectedItem()) != topItem())
		return;
	SETARROW;
	if (topItem() -> childCount() == 0)
		KMessageBox::information(0,i18n("Item contains no entry"));
}

void GroupTree::slotUpdateReady(){
	if (topItem(listView() -> selectedItem()) != topItem())
		return;
	updateReady();	
}

FileGroupBase * GroupTree::group(QString s){
	FileGroupBase * g;
	for (unsigned int i = 0; i < groupCount(); i++){
		if (group(i) -> name() == s){
			g = group(i);
			break;
		}
	}
	return g;
}

void GroupTree::slotCleanupEnded(){
	FileGroupBase * g;
		g = group(name(selectedItem()));
	g -> sync();
	setupItem(g,selectedItem());
	groupViewWidget() -> FileListView1 -> setFileGroup(g);
}

void GroupTree::slotCleanupCancelled(){
	FileGroupBase * g;
		g = group(name(selectedItem()));
	setupItem(g,selectedItem());
	groupViewWidget() -> FileListView1 -> setFileGroup(g);
}

