/***************************************************************************
                          kleandisk.cpp  -  description
                             -------------------
    begin                : wo feb  7 09:47:42 CET 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "../config.h"

#include <kstdaction.h>
#include <klocale.h>
#include <kaction.h>
#include <kmessagebox.h>

#include "info.h"
#include "kleandisk.h"
#include "configuredialog.h"
#include "restorewizard.h"
#include "uninstalldialog.h"

Kleandisk::Kleandisk(){
	//check dirs
	system(QString("mkdir -p ") + udgDir());
	system(QString("mkdir -p ") + insDir());
	system(QString("mkdir -p ") + defaultArchiveDir());
	
	// init config
  KConfig * config = KGlobal::config();

  config -> setGroup("UDG");

	QStrList list;
	config -> readListEntry("Update Folders", list);
	if (list.count() == 0){
		list.append(getenv("HOME"));
		config -> writeEntry("Update Folders",list);
	}
  config -> setGroup("Archive");
	if (config -> readEntry("Folder").length() == 0)
		config -> writeEntry("Folder", defaultArchiveDir());

  config -> setGroup("DUP");
	if (config -> readEntry("Update Folder").length() == 0)
		config -> writeEntry("Update Folder", getenv("HOME"));

  config -> setGroup("INS");
	if (config -> readEntry("python Folder").length() == 0)
		config -> writeEntry("python Folder", "/usr/bin/install");

  groupViewWidget = new GroupViewWidget(this);
	this -> setMinimumSize(600,500);
	new KAction (i18n("New UDG"), 0, groupViewWidget -> udgTree, SLOT(slotNewUDG()), actionCollection(),"new udg");
	new KAction (i18n("Update UDG"), 0, groupViewWidget -> udgTree, SLOT(slotUpdateGroups	()), actionCollection(),"update udg");
	new KAction (i18n("Update Duplicate Files"), 0, groupViewWidget -> dupTree, SLOT(slotUpdate()), actionCollection(),"update dup");
	new KAction (i18n("Uninstall selected Installed Files"), 0, this, SLOT(slotUninstallINS()), actionCollection(),"uninstallINS");
	new KAction (i18n("Uninstall selected RPM's"), 0, this, SLOT(slotUninstallRPM()), actionCollection(),"uninstallRPM");
	new KAction (i18n("Configure Kleandisk"),0, this, SLOT(slotConfigure()), actionCollection(),"configure");
	new KAction (i18n("Restore..."),0, this, SLOT(slotRestore()), actionCollection(),"restore");
	KStdAction::close (this, SLOT(slotClose()), actionCollection());
  config -> setGroup("Geometry");
	this -> setGeometry(config -> readNumEntry("x"), config -> readNumEntry("y"), config -> readNumEntry("width"), config -> readNumEntry("height"));
	createGUI();
}

void Kleandisk::resizeEvent(QResizeEvent * e){
	int m = 20;
	int w = e -> size().width();
	int h = e -> size().height();
	groupViewWidget -> setGeometry(0,m,w,h-m);
}

Kleandisk::~Kleandisk(){
}

void Kleandisk::slotUninstallINS(){
	groupViewWidget -> FileListView1 -> init();
	if (groupViewWidget -> insTree -> numMarked() == 0){
		KMessageBox::information(0,i18n("No groups selected"));
		return;
	}
	UninstallDialog d(groupViewWidget -> insTree);
	int r = d.exec();
}

#ifdef HAVE_LIBRPM
void Kleandisk::slotUninstallRPM(){
	groupViewWidget -> FileListView1 -> init();
	if (groupViewWidget -> rpmTree -> numMarked() == 0){
		KMessageBox::information(0,i18n("No groups selected"));
		return;
	}
	UninstallDialog d(groupViewWidget -> rpmTree);
	int r = d.exec();
}
#else
void Kleandisk::slotUninstallRPM(){}
#endif


void Kleandisk::slotConfigure(){
	ConfigureDialog d;
	d.exec();
}

void Kleandisk::slotRestore(){
	RestoreWizard w;
	w.exec();
}

void Kleandisk::slotClose(){
	groupViewWidget -> udgTree -> saveGroups();
  KConfig * config = KGlobal::config();
  config -> setGroup("Geometry");
  config -> writeEntry("x", this -> x());
  config -> writeEntry("y",  this -> y());
  config -> writeEntry("width",  this -> size().width());
  config -> writeEntry("height", this -> size().height());
	delete this;
}
