/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "downloadselect.h"
#include <klineedit.h>
#include "globals.h"
#include <kiconloader.h>
#include <kpushbutton.h>
#include <qtoolbutton.h>
#include <kdirselectdialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qcheckbox.h>
#include <qdir.h>

DownloadSelect::DownloadSelect(QString dir, QWidget* parent, const char* name, bool modal, WFlags fl)
: DownloadSelectDlg(parent,name, modal,fl)
{
	dirEdit->setText(dir);
	buttonSelectDir->setIconSet(KGlobal::iconLoader()->loadIcon("fileopen", KIcon::Small, 0, false));
	buttonOk->setIconSet(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small, 0, false));
	buttonCancel->setIconSet(KGlobal::iconLoader()->loadIcon("button_cancel", KIcon::Small, 0, false));
	connect(buttonSelectDir, SIGNAL(clicked()), this, SLOT(selectDir()));
	
}

DownloadSelect::~DownloadSelect()
{
}

/*$SPECIALIZATION$*/
void DownloadSelect::reject()
{
  QDialog::reject();
}

void DownloadSelect::accept()
{
	if (!dirEdit->text().stripWhiteSpace().isEmpty()) {
		//Check & create the dir
		if (!checkAndCreateDir(dirEdit->text()))
			KMessageBox::error(this, i18n("Cannot create %1 or directory not writable").arg(dirEdit->text())  , i18n("Error"));
		else { 
			emit download(QDir::cleanDirPath(dirEdit->text()) + '/', downloadFirstCheck->isChecked());
			QDialog::accept();
		}
	} else KMessageBox::error(this, i18n("The directory name can not be empty"), i18n("Error"));
	
}

void DownloadSelect::selectDir( )
{
	KURL uri = KDirSelectDialog::selectDirectory(dirEdit->text()  , true, this, "Please select a directory");
	if (!uri.isEmpty())
		dirEdit->setText(uri.path());
	
}



#include "downloadselect.moc"

