/***************************************************************************
                          kdlgapp.cpp  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.20 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qlayout.h>
#include <klocale.h>
#include <qhbox.h>
#include "kmagodoc.h"
#include "kdlgapp.h"


KDlgApp::KDlgApp(KMagoDoc *doc, QWidget *parent, const char *name) :
   KTabCtl(parent, name), _doc(doc)
{
   initDialog();
   init();
}

KDlgApp::~KDlgApp()
{
}

KMagoDoc * KDlgApp::doc() const
{
   return _doc;
}

void KDlgApp::init()
{
   cbtAEFile->setChecked(doc()->getOpenFlags() & FLG_FILE_AUTO_ENCODE);
   cbtNoPrompt->setChecked(!(doc()->getOpenFlags() & FLG_PROMPT));
   cbtFEFile->setChecked(doc()->getOpenFlags() & FLG_FILE_FORCE_ENCODE);
   cbtLoadLast->setChecked(doc()->getLoadLastDoc());
   lneUpdateInt->setText(QString().setNum(doc()->getUpdateTime()));
   lneSaveInt->setText(QString().setNum(doc()->getSaveTime()));
   lneTStart->setText(QString::number(doc()->getTransferStartTime()));
   cbtListOnDrop->setChecked(doc()->getListOnDrop());
   cbtNotify->setChecked(doc()->getEnableNotify());
   cbtAutoProgress->setChecked(doc()->getAutoProgress());
   cbtTrayProgress->setChecked(doc()->getTrayProgress());
   lneCmdOnIdle->setText(doc()->getCommandOnIdle());
   if (doc()->getOpenFlags() & FLG_START_NOW)
      rbtStart0->setChecked(true);
   else if (doc()->getOpenFlags() & FLG_START_PROMPT)
      rbtStart1->setChecked(true);
   else
      rbtStart2->setChecked(true);
   cbtExpert->setChecked(doc()->getExpertMode());
}

void  KDlgApp::initDialog()
{
   //first page

   QWidget *page = new QWidget(this);
   addTab(page, i18n("General"));

   QBoxLayout * l = new QVBoxLayout(page, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, page, "GB1");
   gbox->setTitle(i18n("Timings"));
   l->addWidget(gbox);

   QHBox *box = new QHBox(gbox);
   QLabel *lbl = new QLabel(box, "LblSaveInt");
   lbl->setText(i18n("Automatic savings every (seconds)"));
   lneSaveInt = new QLineEdit(box, "LneSaveInt");
   lneSaveInt->setFixedWidth(lneSaveInt->fontMetrics().width("XXX"));
   QToolTip::add(lneSaveInt,i18n("Interval for automatic document savings"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneSaveInt, 0);

   box = new QHBox(gbox);
   lbl = new QLabel(box, "LblTStart");
   lbl->setText(i18n("Transfer starting span (ms)"));
   lneTStart = new QLineEdit(box, "LneTStart");
   lneTStart->setFixedWidth(lneTStart->fontMetrics().width("XXXXXXXX"));
   QToolTip::add(lneTStart,i18n("Interval between transfer's starts"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneTStart, 0);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Display update interval (ms)"), box, "LblUpdateInt");
   lneUpdateInt = new QLineEdit(box, "LneUpdateInt");
   lneUpdateInt->setFixedWidth(lneUpdateInt->fontMetrics().width("XXXXXXXX"));
   QToolTip::add(lneUpdateInt, i18n("Interval between display's updates"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneUpdateInt, 0);

   gbox = new QGroupBox(1, Horizontal, page, "GB2");
   gbox->setTitle(i18n("General"));
   l->addWidget(gbox);

   cbtExpert = new QCheckBox(gbox, "CbtExpert");
   QToolTip::add(cbtExpert,i18n("No confirmation for destructive actions"));
   cbtExpert->setText(i18n("Expert mode: no confirmation prompt"));

   cbtLoadLast = new QCheckBox(gbox,"CbtLoadLast");
   QToolTip::add(cbtLoadLast,i18n("Start up with last used document"));
   cbtLoadLast->setText(i18n("Start up with last used document"));

   cbtListOnDrop = new QCheckBox(gbox, "CbtListOnDrop");
   QToolTip::add(cbtListOnDrop, i18n("Popup managers list menu dropping on tray icon or drop target"));
   cbtListOnDrop->setText(i18n("Popup a list of managers on drop"));

   cbtNotify = new QCheckBox(gbox, "CbtNotify");
   QToolTip::add(cbtNotify, i18n("Enable event notification on transfer error, start, complete, ..."));
   cbtNotify->setText(i18n("Enable event notification"));

   cbtAutoProgress = new QCheckBox(gbox, "CbtAutoProgress");
   QToolTip::add(cbtAutoProgress, i18n("Automatic opening and closing of progress windows on transfer's start and complete"));
   cbtAutoProgress->setText(i18n("Automatic pop up of progress windows"));

   cbtTrayProgress = new QCheckBox(gbox, "CbtTrayProgress");
   QToolTip::add(cbtTrayProgress, i18n("Add a system tray icon to progress window"));
   cbtTrayProgress->setText(i18n("Add system tray icon to progress windows"));

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Idle Command"), box, "LblCmdOnIdle");
   lneCmdOnIdle = new QLineEdit(box, "LneCmdOnIdle");
   //lneCmdOnIdle->setFixedWidth(lneCmdOnIdle->fontMetrics().width("XXXXXXXX"));
   QToolTip::add(lneCmdOnIdle, i18n("Command to execute on first idle state"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneCmdOnIdle, 10);

   page->adjustSize();
   page->setMinimumSize(size());

   // second page

   page = new QWidget(this);
   addTab(page, i18n("Input Control"));

   l = new QVBoxLayout(page, 8);

   gbox = new QGroupBox(1, Horizontal, page, "GB3");
   gbox->setTitle(i18n("Input Validation"));
   l->addWidget(gbox);

   cbtNoPrompt= new QCheckBox(gbox, "CbtNoPrompt");
   QToolTip::add(cbtNoPrompt,
		 i18n("Don't prompt for changes in transfer insertion"));
   cbtNoPrompt->setText(i18n("Automatic transfer insertion"));

   cbtAEFile= new QCheckBox(gbox, "CbtAEFile");
   QToolTip::add(cbtAEFile,
		 i18n("Automatic encoding of filename when it contains spaces"));
   cbtAEFile->setText(i18n("Auto encode filename"));

   cbtFEFile= new QCheckBox(gbox,"CbtFEFile");
   QToolTip::add(cbtFEFile,
		 i18n("Force filename encoding when it contain spaces"));
   cbtFEFile->setText(i18n("Force filename encoding"));

   QButtonGroup * bg = new QButtonGroup(1, Horizontal, page, "BgrStart");
   bg->setTitle(i18n("Adding Transfer Mode"));
   l->addWidget(bg);

   rbtStart0 = new QRadioButton(bg,"RbtStart0");
   rbtStart0->setText(i18n("Start download immediately"));

   rbtStart1 = new QRadioButton(bg,"RbtStart1");
   rbtStart1->setText(i18n("Prompt to start or add to list"));

   rbtStart2 = new QRadioButton(bg,"RbtStart2");
   rbtStart2->setText(i18n("Add to list"));

   page->adjustSize();
   page->setMinimumSize(size());

   adjustSize();
   setMinimumSize(size());
}

bool KDlgApp::isAcceptable()
{
   bool check;
   QString(lneUpdateInt->text()).toInt(&check);
   if (!check)
      return false;
   QString(lneSaveInt->text()).toInt(&check);
   if (!check)
      return false;
   QString(lneTStart->text()).toInt(&check);
   if (!check) return false;
   return true;
}

void KDlgApp::accept()
{
   int f = ((cbtAEFile->isChecked() ? FLG_FILE_AUTO_ENCODE : 0)
	    + (cbtFEFile->isChecked() ? FLG_FILE_FORCE_ENCODE : 0)
	    + (cbtNoPrompt->isChecked() ? 0 : FLG_PROMPT)
	    + getStartMode());
   doc()->setOpenFlags(f);
   doc()->setUpdateTime(QString(lneUpdateInt->text()).toInt());
   doc()->setSaveTime(QString(lneSaveInt->text()).toInt());
   doc()->setTransferStartTime(QString(lneTStart->text()).toInt());
   doc()->setExpertMode(cbtExpert->isChecked());
   doc()->setLoadLastDoc(cbtLoadLast->isChecked());
   doc()->setListOnDrop(cbtListOnDrop->isChecked());
   doc()->setEnableNotify(cbtNotify->isChecked());
   doc()->setAutoProgress(cbtAutoProgress->isChecked());
   doc()->setTrayProgress(cbtTrayProgress->isChecked());
   doc()->setCommandOnIdle(lneCmdOnIdle->text());
   doc()->saveState();
   KMagoDoc::reloadState();
}

void KDlgApp::reject()
{
}

int KDlgApp::getStartMode()
{
   return ((rbtStart0->isChecked() ? FLG_START_NOW : 0)
	   + (rbtStart1->isChecked() ? FLG_START_PROMPT : 0));
	   //+ rbtStart2->isChecked() * 0);
}

#include "kdlgapp.moc"
