/***************************************************************************
                          klogviewer.h  -  description
                             -------------------
    begin                : Thu Aug 31 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLOGVIEWER_H
#define KLOGVIEWER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qmultilinedit.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

class KTransfer;

/**
 * @short Window to view the log generated from the downloading backend.
 *
 * @author Sergio Moretti
 *
 * @version $Id: klogviewer.h,v 1.9 2001/04/04 18:06:04 sergio Exp $
 */

class KLogViewer : public QWidget
{
   Q_OBJECT
public:
   KLogViewer(KTransfer t, QWidget *parent, const char *name=0);
   ~KLogViewer();

protected:
   void initDialog();

public slots: // Public slots
   /** read the process output */
   void slotRead(const QString &);

signals:
   void sigClose(int id);

protected:
   QMultiLineEdit *mleText;
   int _id;

private:
   /** output not processed */
   QCString _buffer;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
