/***************************************************************************
                          kmmanagericonview.cpp  -  description
                             -------------------
    begin                : Wed Dec 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.13 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qtextstream.h>
#include <klocale.h>
#include <kmainwindow.h>
#include "kmagodoc.h"
#include "kmagoview.h"
#include "kmmanager.h"
#include "kmmanagericonview.h"

KMManagerIconView::KMManagerIconView(KMManager m, KMagoDoc *doc, Callback cb, 
				     QWidget *parent, const char *name)
   : KIconView(parent, name), KContainerView(doc, cb, m) 
{
   //kdFatal(container().isNull(), D_VIE) << name << endl;
   //setMinimumSize(0,0);
   setAutoArrange(true);
   setResizeMode(Adjust);
   setSelectionMode(Single);
   setItemTextPos(Right);
   setAcceptDrops(true);
   //setItemsMovable(true);
   connect(this, SIGNAL(dropped(QDropEvent *, const QValueList<QIconDragItem>&)),
	   this, SLOT(slotDropped(QDropEvent *, 
				  const QValueList<QIconDragItem>&)));
   connect(this, SIGNAL(executed(QIconViewItem*)),
	   this, SLOT(slotExecuted(QIconViewItem*)));
   connect(this, SIGNAL(rightButtonClicked(QIconViewItem*, const QPoint&)),
	   this, SLOT(slotRightButtonPressed(QIconViewItem*, const QPoint&)));
   connect(this, SIGNAL(selectionChanged(QIconViewItem*)),
	   this, SLOT(slotSelectionChanged(QIconViewItem*)));
   connect(this, SIGNAL(itemRenamed(QIconViewItem*, const QString&)),
	   this, SLOT(slotItemRenamed(QIconViewItem*, const QString&)));
   initActions();
}

KMManagerIconView::~KMManagerIconView()
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
}

KMagoView * KMManagerIconView::view() const 
{ 
   return dynamic_cast<KMagoView*>(parentWidget()); 
}

void KMManagerIconView::initActions()
{
   _sortingMode = new KSelectAction(i18n("Sort Mode"),
				    0, this,
				    SLOT(slotSortingMode()),
				    doc()->mainWindow()->actionCollection(),
				    "miconview_sort");
   QStringList lst;
   lst << i18n("by Title") << i18n("by Priority");
   _sortIdx[0] = MDI_TMN_TITLE;
   _sortIdx[1] = MDI_PRIORITY;
   _sortingMode->setItems(lst);
   _sortingMode->setCurrentItem(0);

   _sortingDir = new KSelectAction(i18n("Sort Direction"),
				   0, this,
				   SLOT(slotSortingDir()),
				    doc()->mainWindow()->actionCollection(),
				   "miconview_sort_dir");
   lst.clear();
   lst << i18n("Ascending") << i18n("Descending");
   _sortingDir->setItems(lst);
   _sortingDir->setCurrentItem(0);
}

void KMManagerIconView::initView()
{
   setSorting(true, (_sortingDir->currentItem() == 0));
   reset();
}

void KMManagerIconView::setSortBy(ModIndex p, bool increasing)
{
   switch (p)
   {
   case MDI_TMN_TITLE:
      _sortingMode->setCurrentItem(0);
   case MDI_PRIORITY:
      _sortingMode->setCurrentItem(1);
   default:
      kdFatal(D_VIE) << name() << ": unknown sorting key " << p << endl;
   }
   _sortingDir->setCurrentItem(increasing ? 0 : 1);
}

QDragObject * KMManagerIconView::dragObject() 
{
   QPoint orig = viewportToContents(viewport()->mapFromGlobal(QCursor::pos()));
   KMManagerIconDrag *drag = 0;
   for (KMManagerIconItem *item = (KMManagerIconItem*)firstItem(); item;
	item = (KMManagerIconItem*)item->nextItem() ) 
   {
      if (item->isSelected() && item->dragEnabled()) 
      {
	 kdDebug(D_RUN) << name() << ": dragObject " << item->manager().name() << endl;
	 if (drag == 0) 
	 {
	    drag = new KMManagerIconDrag(this, QString("%1-drag").arg(name()));
	    drag->setPixmap(DesktopIcon("kmultiple"));
	 }
	 drag->append(item->manager(),
		      QRect(item->pixmapRect( FALSE ).x() - orig.x(),
			    item->pixmapRect( FALSE ).y() - orig.y(),
			    item->pixmapRect().width(), 
			    item->pixmapRect().height()),
		      QRect(item->textRect( FALSE ).x() - orig.x(),
			    item->textRect( FALSE ).y() - orig.y(),
			    item->textRect().width(), 
			    item->textRect().height()));
      }
   }
   return drag;
}

KMManagerIconItem * KMManagerIconView::itemFind(KObject item) const 
{
   kdFatal(item.isNull(), D_VIE) << name() << ": find null object" << endl;
   KMManagerIconItem *i;
   for (i = dynamic_cast<KMManagerIconItem*>(firstItem());
	i != 0 && i->manager() != item;
	i = dynamic_cast<KMManagerIconItem*>(i->nextItem()));
   kdError(i == 0, D_VIE) << name() << ": manager item not found" << endl;
   return i;
}

void KMManagerIconView::itemAdd(KObject item) 
{
   new KMManagerIconItem(this, item.toTManager());
}

void KMManagerIconView::itemRemove(KObject item) 
{
   kdFatal(item.isNull(), D_VIE) << name() << ": remove null object" << endl;
   delete itemFind(item);
}

void KMManagerIconView::itemSelect(KObject item) 
{
   if (!item.isNull()) 
   {
      setSelected(itemFind(item), true);
   } 
   else 
   {
      clearSelection();
   }
}

void KMManagerIconView::itemUpdate(KObject item) 
{
   if (item.isMod(sortBy()))
   {
      // changed sort key, view reset is needed
      reset();
   }
   else
   {
      KMManagerIconItem *i = itemFind(item);
      if (i != 0)
	 i->update();
   }
}

void KMManagerIconView::itemUpdateText(KObject item) 
{
   if (item.isMod(sortBy()))
   {
      // changed sort key, view reset is needed
      reset();
   }
   else
   {
      KMManagerIconItem *i = itemFind(item);
      if (i != 0)
	 i->update();
   }
}

KObject KMManagerIconView::itemFirst() const
{
   KMManagerIconItem *i = dynamic_cast<KMManagerIconItem*>(firstItem());
   if (i == 0)
      return KObject::null();
   return i->manager();
}

KObject KMManagerIconView::itemBelow(KObject item) const
{
   KMManagerIconItem *i = itemFind(item);
   KMManagerIconItem *b = dynamic_cast<KMManagerIconItem*>(i->nextItem());
   if (b == 0)
      return KObject::null();
   return b->manager();
}

KObject KMManagerIconView::itemAbove(KObject item) const
{
   KMManagerIconItem *i = itemFind(item);
   KMManagerIconItem *b = dynamic_cast<KMManagerIconItem*>(i->prevItem());
   if (b == 0)
      return KObject::null();
   return b->manager();
}

void KMManagerIconView::setOrientation(bool vert) 
{
   if (vert) 
   {
      setArrangement(LeftToRight);
   } 
   else 
   {
      setArrangement(TopToBottom);
   }
}

void KMManagerIconView::applySettings(KConfig *config) 
{
   _sortingMode->setCurrentItem(
      config->readNumEntry("MManagerIconView SortBy", 0));
   _sortingDir->setCurrentItem(
      config->readNumEntry("MManagerIconView SortDir", 0));
   //initView();
}   

void KMManagerIconView::saveSettings(KConfig *config)
{
   config->writeEntry("MManagerIconView SortBy", _sortingMode->currentItem());
   config->writeEntry("MManagerIconView SortDir", _sortingDir->currentItem());
}

// slots

void KMManagerIconView::slotDropped(QDropEvent * event,
				    const QValueList<QIconDragItem> &) 
{
   dropTManagerList(event, container());
}

void KMManagerIconView::slotExecuted(QIconViewItem *) 
{
}

void KMManagerIconView::slotRightButtonPressed(QIconViewItem *i, const QPoint &p)
{
   if (i == 0)
      return;
   kdFatal(dynamic_cast<KMManagerIconItem*>(i)->manager() != doc()->currentManager()) << name() << " context menu" << endl;
   view()->managerMenu()->popup(p);
}

void KMManagerIconView::slotSelectionChanged(QIconViewItem * item) 
{
   //emit sigSelectionChanged(dynamic_cast<KMManagerIconItem*>(item)->manager());
   itemSelectionChanged(dynamic_cast<KMManagerIconItem*>(item)->manager());
}

void KMManagerIconView::contentsDragMoveEvent(QDragMoveEvent *event) 
{
   KIconView::contentsDragMoveEvent(event);
   //FIXME!! hack to keep working the move action
   event->acceptAction(true);
   //kdDebug(D_VIE) << name() << ": drag action " << event->action() << endl;
}
/*
void KMManagerIconView::contentsDropEvent(QDropEvent *event) 
{
//event->setAction(QDropEvent::Move);
kdDebug(D_RUN) << name() << ": drop action " << event->action() << endl;
KIconView::contentsDropEvent(event);
}
*/

void KMManagerIconView::slotItemRenamed(QIconViewItem * item, 
					const QString &name) 
{
   dynamic_cast<KMManagerIconItem*>(item)->manager().setTitle(name);
   adjustItems();
}

void KMManagerIconView::slotSortingMode()
{
   reset();
}

void KMManagerIconView::slotSortingDir()
{
   initView();
}

//////////////////////////////////////////////////////////////////

KMManagerIconItem::KMManagerIconItem(KIconView *parent, KTManager mngr)
   : QIconViewItem(parent), m(mngr) 
{
   setDropEnabled(true);
   setRenameEnabled(true);
   KMManagerIconView * view = dynamic_cast<KMManagerIconView*>(iconView());
   _sortFunction = 
      (view->sortBy() == MDI_TMN_TITLE ? 
       &KMManagerIconItem::sortByTitle : &KMManagerIconItem::sortByPriority);
   update();
}

QString KMManagerIconItem::sortByTitle() const
{
   return m.title();
}

QString KMManagerIconItem::sortByPriority() const
{
   return QString("%1%2").arg(m.priority(),5).arg(m.title());
}

QString KMManagerIconItem::key() const
{
   return (this->*_sortFunction)();
}

void KMManagerIconItem::update() 
{
   if (m.isNull())
   {
      kdWarning(D_VIE) << ": KMManagerIconItem::update on null item" << endl;
      return;
   }
   setText(m.title());
   setDragEnabled(KContainerView::managerDragEnabled(m));
   if (m.itemActiveCount() > 0) 
   {
      if (m.getAutoDownload())
	 setPixmap(SmallIcon("folder_green_open"));
      else
	 setPixmap(SmallIcon("folder_blue_open"));
   } 
   else 
   {
      if (m.getAutoDownload())
	 setPixmap(SmallIcon("folder_green"));
      else
	 setPixmap(SmallIcon("folder_blue"));
   }
}

bool KMManagerIconItem::acceptDrop(const QMimeSource * mime) const 
{
   return KContainerView::transferCanDecode(mime);
}

void KMManagerIconItem::dropped (QDropEvent * event,
			         const QValueList<QIconDragItem> &lst) 
{
   // check to not drop on a dragged item
   if (event->source() != 0)
      for (QValueList<QIconDragItem>::ConstIterator i = lst.begin(); 
	   i != lst.end(); ++i) 
      {
	 QString id;
	 QTextIStream((*i).data()) >> id;
	 kdDebug(D_RUN) << "KMManagerIconItem : drop item " << id << endl;
	 if (id.toInt() == m.id()) 
	 {
	    kdWarning(D_RUN) << "KMManagerIconItem : drop on a dragged item " << m.name() << endl;
	    event->ignore();
	    return;
	 }
      }
   KContainerView::dropTransferList(
      event, 
      dynamic_cast<KMManagerIconView*>(iconView())->doc(), 
      manager());
}

/////////////////////////////////////////////////////////////////

KMManagerIconDrag::KMManagerIconDrag(QWidget *dragSource, const char *name)
   : QIconDrag(dragSource, name) 
{
   kdDebug(D_RUN) << "KMManagerIconDrag : source " << source() << endl;
}

const char* KMManagerIconDrag::format(int i) const 
{
   return KContainerView::managerFormat(i);
}

QByteArray KMManagerIconDrag::encodedData(const char* mimetype) const 
{
   return KContainerView::managerEncodedData(mngrs, mimetype);
}

bool KMManagerIconDrag::canDecode(const QMimeSource *e) 
{
   return KContainerView::managerCanDecode(e);
}

void KMManagerIconDrag::append(const KTManager item, const QRect &pr,
                               const QRect &tr) 
{
   mngrs << item;
   QIconDragItem id;
   QByteArray data;
   QTextOStream(data) << item.id() << endl;
   id.setData(data);
   //FIXME!! who does create the boxes ??
   QIconDrag::append( id, pr, tr );
}

#include "kmmanagericonview.moc"
