/***************************************************************************
                          ktmanager.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.8 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktmanagerimpl.h"
#include "ktransfer.h"
#include "ktmanager.h"


QString KTManager::title() const 
{
   return impl()->title();
}

void KTManager::setTitle(const QString &t) const
{
   impl()->setTitle(t);
}

int KTManager::bandwidth() const 
{
   return impl()->bandwidth();
}

int KTManager::mediumBandwidth() const 
{
   return impl()->mediumBandwidth();
}

KTransfer KTManager::itemNew(int type, const KURL &rmt, const KURL &lcl) const
{
   return KTransfer(impl()->itemNew(type, rmt, lcl));
}

// CONFIG

bool KTManager::getAutoDownload() const 
{
   return impl()->getAutoDownload();
}

void KTManager::setAutoDownload(bool m) const
{
   impl()->setAutoDownload(m);
}

bool KTManager::getAutoRemove() const 
{
   return impl()->getAutoRemove();
}

void KTManager::setAutoRemove(bool r) const 
{
   impl()->setAutoRemove(r);
}

int KTManager::getMaxConnection() const 
{
   return impl()->getMaxConnection();
}

void KTManager::setMaxConnection(int c) const
{
   impl()->setMaxConnection(c);
}

int KTManager::getMaxBandwidth() const 
{
   return impl()->getMaxBandwidth();
}

void KTManager::setMaxBandwidth(int b) const
{
   impl()->setMaxBandwidth(b);
}

int KTManager::getMinBandwidth() const 
{
   return impl()->getMinBandwidth();
}

void KTManager::setMinBandwidth(int b) const
{
   impl()->setMinBandwidth(b);
}

const QDir & KTManager::getDownloadDir() const 
{
   return impl()->getDownloadDir();
}

void KTManager::setDownloadDir(const QString &d) const
{
   impl()->setDownloadDir(d);
}

const QDir & KTManager::getWorkingDir() const 
{
   return impl()->getWorkingDir();
}

void KTManager::setWorkingDir(const QString &d) const
{
   impl()->setWorkingDir(d);
}

QString KTManager::getLogFile() const 
{
   return impl()->getLogFile();
}

void KTManager::setLogFile(const QString &d) const
{
   impl()->setLogFile(d);
}

int KTManager::getDefaultType() const 
{
   return impl()->getDefaultType();
}

void KTManager::setDefaultType(int t) const
{
   impl()->setDefaultType(t);
}

const char * KTManager::docId()
{
   return KTManagerImpl::DOCID; 
}

const char * KTManager::docType() 
{
   return KTManagerImpl::DOCTYPE;
}

KTManager::KTManager(KTManagerImpl *impl) : KContainer(impl) 
{
}

KTManagerImpl * KTManager::impl() const 
{
   return dynamic_cast<KTManagerImpl*>(KContainer::impl());
}
