/*		Name:		exp.c
		Version:	0.9.16
		Date:		28/11/2003
		Expressions 
*/

#include "exp.h"
#include "chump.h"
#include "lint.h"
#include <stdlib.h>
#include <ctype.h>

ExpSymbol exp_presidence[] ={
    {LINT_MUL, "*", 60},    {LINT_DIV, "/", 60},    {LINT_MOD, "%", 60},
    {LINT_ADD, "+", 50},    {LINT_SUB, "-", 50},
    {LINT_SL, "<<", 40},    {LINT_SR, ">>", 40},
    {LINT_XOR, "^", 30},
    {LINT_AND, "&", 20},    {LINT_AND, "&&",20},
    {LINT_OR, "|",  10},    {LINT_OR, "||", 10},
    {-1, NULL, 0}  };



// exp = val ( sym val )*
// val = number
//     = "(" exp ")"
// sym = [+-*/|&^...]
// num = 0x[hexnumber]
//     = 0[octnumber]
//     = [decnumber]



Lint exp_exp(char* ptr, char** endptr, int presedence, Lint(*get_symbol)(char*,char**,void*), void* data)
{
 char* i = ptr;
 char* prepeek;
 char* prepeek2;
 Lint ret;
 Lint second;
 ExpSymbol* current_sym;
 ExpSymbol* next_sym;
 ret = exp_val(i, &i, get_symbol, data);
 if (!i) {*endptr = NULL;return lint_new(0);}
 while (1){
    prepeek = i;
    current_sym = exp_find_symbol (i,&i);
    if (!(current_sym->string))               {*endptr = i;      return ret;}
    if (current_sym->presedence <= presedence) {*endptr = prepeek;return ret;}
    prepeek = i;
    second = exp_val(i, &i, get_symbol, data);
    if (!i) {*endptr = NULL;return lint_new(0);}
    prepeek2 = i;
    next_sym = exp_find_symbol (i, &i);
    if (next_sym->presedence > current_sym->presedence){
        i = prepeek;
        second = exp_exp(i, &i, current_sym->presedence, get_symbol, data);
        if (!i) {*endptr = NULL;return lint_new(0);}
        }
    else {
        i = prepeek2;
        }
    ret = lint_operate(ret, second, current_sym->type);
    }
}


Lint exp_val(char* ptr,char** endptr, Lint(*get_symbol)(char*,char**,void*), void* data)
{
 char* i;
 Lint ret;
 while (isblank(*ptr)) ptr++;
 i = ptr;
 switch (*i) {
    case '(':
        i++; 
        ret = exp_exp(i, &i, 0, get_symbol, data);
        if (!i) {*endptr = NULL;return lint_new(0);}
        while (isblank(*i)) i++;
        if (')' != *i) {
            *endptr = NULL;
            }
        else *endptr = i+1;
        break;
    case '\'':
    case '\"':
        {
        char startchar = *i;
        i++;
        if (!(*i) || '\n' == *i) {*endptr = NULL;return lint_new(0);}
        ret = lint_new(asm_getchar(i, &i));
        if (!i || !(*i) || '\n' == *i) {*endptr = NULL;return lint_new(0);}
        if (startchar != *i) *endptr = NULL;
        else                 *endptr = i+1;
        } 
        break;
    default:
        ret = lint_from_string(i, &i);
        if (i) *endptr = i;
        else  {
            ret = get_symbol(ptr, &i, data);
            if (!i) {*endptr = NULL;return lint_new(0);}
            *endptr = i;
            }
        break;
    }
 return ret;
}



ExpSymbol* exp_find_symbol (char* ptr, char** endptr)
{
 char* i = ptr;
 int index=0;
 int strindex;
 while (isblank(*i)) i++;

 while (exp_presidence[index].string){
    strindex=0;
    while (1){
        if (!exp_presidence[index].string[strindex]){
            *endptr = i+strindex;
            return &exp_presidence[index];
            }
        if (exp_presidence[index].string[strindex] != i[strindex]) break;
        strindex++;
        }
    index++;
    }
 return &exp_presidence[index];
}



