/***************************************************************************
                          msnobjecttransferp2p.h -  description
                             -------------------
    begin                : Fri Nov 26 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNOBJECTTRANSFERP2P_H
#define MSNOBJECTTRANSFERP2P_H

#include "../../contact/msnobject.h"
#include "p2papplication.h"


class MsnObject;
class MimeMessage;
class P2PMessage;

class QFile;



/**
 * An application class responsable for MSN Object transfers between clients.
 *
 * @author Diederik van der Boor
 * @ingroup Applications
 */
class MsnObjectTransferP2P : public P2PApplication
{
  Q_OBJECT

  public:
    // The constructor without msnobject (sufficient for incoming sessions)
                           MsnObjectTransferP2P(ApplicationList *applicationList);
    // The constructor with msnobject to start a session
                           MsnObjectTransferP2P(ApplicationList *applicationList, const MsnObject &msnObject);

    // The destructor
    virtual               ~MsnObjectTransferP2P();

    // Return the application's GUID
    static QString         getAppId();

    // Return the msn object of the picture we're transferring
    const MsnObject &      getMsnObject() const;

    // Indicates a private chat is not required, overwritten from the base class.
    bool                   isPrivateChatRequired() const;

    // Hide standard informative application message (e.g. user invited, cancelled)
    virtual void           showEventMessage( const QString &message, const ChatMessage::ContentsClass contents, bool isIncoming );
    // Show a message to notify about a system error.
    virtual void           showSystemMessage( const QString &message, const ChatMessage::ContentsClass contents, bool isIncoming );
    // Closes the file, verifies the MsnObject and updates possible listeners.
    virtual void           showTransferComplete();
    // Hide transfer messages, by overwriting the default method implementation.
    virtual void           showTransferMessage(const QString &message);

  private:

    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step one continued, the request is for the display picture
    void                   contactStarted1_gotDisplayPictureRequest();
    // Step one continued, the request is for an emoticon.
    void                   contactStarted1_gotEmoticonRequest();
    // Step one continued, the request is for an wink.
    void                   contactStarted1_gotWinkRequest();
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Step four of a contact-started chat: the contact confirms the data-preparation message.
    void                   contactStarted4_ContactConfirmsPreparation();
    // Called when data is received
    void                   gotData(const P2PMessage &message);

    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage &message);
    // Step three of a user-started chat: the user prepares for the session
    void                   userStarted3_UserPrepares();


  private:
    // Handle of the file.
    QFile                 *file_;
    // Name of the file where the data should be stored.
    QString                fileName_;
    // MSN Object identifying the object we need to request
    MsnObject              msnObject_;

  signals:
    void                   msnObjectReceived(const QString& contact, const MsnObject &msnObject);
};

#endif
