/* -*- c++ -*-
 *
 * kcmdonkey.cpp
 *
 * Copyright (C) 2002 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <qlayout.h>

#include <klocale.h>
#include <kaboutdata.h>

#include "version.h"
#include "kcmdonkey.h"
#include "kcmdonkey.moc"

extern "C"
{
    KCModule *create_kcmdonkey(QWidget* parent, const char*) {
        return new KCMDonkey(parent, "kmldonkey");
    }
}

KCMDonkey::KCMDonkey( QWidget *parent, const char *name )
        : KCModule( parent, name )
{
    QVBoxLayout* l = new QVBoxLayout(this);
    m_config = new DonkeyConfig(this, "DonkeyConfig");
    l->addWidget(m_config);
    resize(m_config->size().expandedTo(minimumSizeHint()));
    setCaption(i18n("MLDonkey Host Configuration"));
    connect(m_config, SIGNAL(changed(bool)), SIGNAL(changed(bool)));
    load();
}

KCMDonkey::~KCMDonkey()
{}

void KCMDonkey::load()
{
    m_config->load(false);
}

void KCMDonkey::defaults()
{
    m_config->load(true);
}

void KCMDonkey::save()
{
    m_config->save();
}

int KCMDonkey::buttons()
{
    return KCModule::Default | KCModule::Apply;
// | KCModule::Help;
}

QString KCMDonkey::quickHelp() const
{
    return i18n("This is where you configure the connectivity for the KMLDonkey suite - "
		"meaning the network location of your mldonkey core, and your username and password. "
		"If none of that makes any sense to you, the defaults are probably good.");
}

const KAboutData* KCMDonkey::aboutData() const
{
    KAboutData *about = new KAboutData("kcmdonkey", I18N_NOOP("KMLDonkey Configuration"), KMLDONKEY_VERSION,
				       I18N_NOOP("An MLDonkey frontend for the KDE desktop."),
				       KAboutData::License_GPL_V2, I18N_NOOP("Copyright (C) 2003, 2004 The KMLDonkey Authors"),
				       I18N_NOOP("Part of the KMLDonkey package."),
				       "http://www.kmldonkey.org");
    about->addAuthor("Petter E. Stokke", I18N_NOOP("Maintainer"), "gibreel@kmldonkey.org");
    about->addAuthor("Sebastian Sauer", I18N_NOOP("Developer"), "mail@dipe.org");
    about->setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

    return about;
}

