//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// License: GPL
//


#include "kmfdocumentinfo.h"

// QT includes
#include <qstring.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qpushbutton.h>


// KDE includes
#include <kapplication.h>
#include <kdebug.h>

// project includes
#include "../core/kmfdoc.h"

KMFDocumentInfo::KMFDocumentInfo(QWidget* parent, const char* name, bool modal, WFlags fl)
		: KMyFirewallDocumentInfo(parent,name, modal,fl) {
	connect( b_help, SIGNAL( clicked() ),
		this, SLOT( slotHelp() ) );
			connect( b_saveAsTemplate, SIGNAL( clicked() ), this, SLOT( slotSaveAsTemplate() ) );
	
}

KMFDocumentInfo::~KMFDocumentInfo() {}

void KMFDocumentInfo::slotSaveAsTemplate() {
	kdDebug() << "slotSaveAsTemplate()" << endl;
	emit sigSaveAsTemplate();
}

/*$SPECIALIZATION$*/
void KMFDocumentInfo::accept() {
	if ( ! txt_name->text().isNull() ) {
		m_doc->setName( txt_name->text() );
		m_doc->changed();
	}
	
	if ( ! txt_description->text().isNull() ) {
		m_doc->setDescription( txt_description->text() );
		m_doc->changed();
	}
	
	QDialog::accept();
}

void KMFDocumentInfo::loadDoc( KMFDoc* doc ) {
	m_doc = doc;
	txt_name->setText( doc->name() );
	txt_description->setText( doc->description() );
}

void KMFDocumentInfo::slotHelp() {
	kdDebug() << "void KMFDocumentInfo::slotHelp()" << endl;
	kapp->invokeHelp();
}

#include "kmfdocumentinfo.moc"

