/***************************************************************************
 begin                : Thu Sep 5 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFPROCOUT_H
#define KMFPROCOUT_H

// QT includes
#include <qwidget.h>
#include <qstring.h>
#include <qpixmap.h>

// KDE includes
#include <kprocess.h>

/**
  *@author Christian Hubinger
  */

class QLabel;
class QGridLayout;
class KPushButton;
class QTextBrowser;

class KDE_EXPORT KMFProcOut : public QWidget {
	Q_OBJECT
public:
	KMFProcOut( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFProcOut();
	public: KProcess* childproc;
	KProcess &operator<<( const QString& arg );

	bool isRunning();
	void runCmd( const QString&, const QString& );
	void setText( const QString& );

protected:
	// Component notifications:

	void startJob();
	void prepareJob( const QString &dir );
	void childFinished( bool normal, int status );
	void insertStderrLine( const QString &line );
	void insertStdoutLine( const QString &line );

protected:
	protected: QString* stderrbuf;
	protected: QString* stdoutbuf;

protected slots:
	void slotKillJob();
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
	void slotProcessExited( KProcess* );

private:
	void flushStdoutBuf();
	void flushStderrBuf();
	void slotSetButtons();
	void initGUI();

private:    // data
	private: QPixmap icon_stop, icon_close;
	private: QString m_job_name;
	private: QTextBrowser *m_lbview;
	private: QLabel *m_ljob_name;
	private: QGridLayout *m_layout;
	private: KPushButton *m_bkill;

signals:
	void processExited( KProcess * );
	void rowSelected( int row );
	void sigJobFinished( bool, const QString& );
};

#endif
