#include <klocale.h>
#include "knap_chanlist.h"

#include <qcheckbox.h>
#include <qframe.h>
#include <qheader.h>
#include <qlabel.h>
//#include <qlistview.h>
#include "knap_listview.h"

#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "support_funcs.h"

#include <iostream>
/* 
 *  Constructs a KNAP_Channellist which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KNAP_Channellist::KNAP_Channellist( QWidget* parent,  const char* name)
    : QDialog( parent, name, false )
{
    if ( !name )
	setName( "ChannelList" );
    resize( 395, 479 ); 
    setCaption( i18n( "Channels"  ) );
    setEnabled( TRUE );
    ChannelListLayout = new QGridLayout( this ); 
    ChannelListLayout->setSpacing( 6 );
    ChannelListLayout->setMargin( 11 );

    buttonlayout = new QHBoxLayout; 
    buttonlayout->setSpacing( 6 );
    buttonlayout->setMargin( 0 );

    joinbtn = new QPushButton( this, "joinbtn" );
    joinbtn->setText( i18n( "Join"  ) );
    buttonlayout->addWidget( joinbtn );

    // start disabled
    joinbtn->setEnabled(false);
    
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    buttonlayout->addItem( spacer );

    closebtn = new QPushButton( this, "closebtn" );
    closebtn->setText( i18n( "Close"  ) );
    closebtn->setDefault( TRUE );
    closebtn->setAutoDefault( FALSE );
    buttonlayout->addWidget( closebtn );

    ChannelListLayout->addMultiCellLayout( buttonlayout, 4, 4, 0, 1 );

    channellist = new KNAP_ListView( this, "channellist" );
    channellist->addColumn( i18n( "Name" ) );
    channellist->addColumn( i18n( "Users" ) );
    channellist->addColumn( i18n( "Subject" ) );

    ChannelListLayout->addMultiCellWidget( channellist, 1, 1, 0, 1 );

    status = new QLabel( this, "status" );
    status->setText( i18n( "Loading channel list..."  ) );
    status->setFrameShape( QLabel::Panel );
    status->setFrameShadow( QLabel::Sunken );

    ChannelListLayout->addMultiCellWidget( status, 0, 0, 0, 1 );

    refreshlistbtn = new QPushButton( this, "refreshlistbtn" );
    refreshlistbtn->setText( i18n( "Refresh List"  ) );

    ChannelListLayout->addWidget( refreshlistbtn, 2, 1 );

    showallcb = new QCheckBox( this, "showallcb" );
    showallcb->setText( i18n( "Show hidden channels"  ) );

    ChannelListLayout->addWidget( showallcb, 2, 0 );

    Line3 = new QFrame( this, "Line3" );
    Line3->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    ChannelListLayout->addMultiCellWidget( Line3, 3, 3, 0, 1 );

    // tab order
    setTabOrder( channellist, joinbtn );
    setTabOrder( joinbtn, closebtn );
    setTabOrder( closebtn, refreshlistbtn );
    setTabOrder( refreshlistbtn, showallcb );

    // slots
    connect(closebtn,SIGNAL( clicked() ), this, SLOT( reject() ));
    connect(joinbtn,SIGNAL( clicked() ), this, SLOT( joinPressed() ));
    connect(refreshlistbtn,SIGNAL( clicked() ), this, SLOT( updatePressed() ));

    connect(channellist,SIGNAL( selectionChanged() ), this, SLOT( channelSelected() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KNAP_Channellist::~KNAP_Channellist()
{
    // no need to delete child widgets, Qt does it all for us
}
void KNAP_Channellist::clear()
{
  channellist->clear();
  status->setText("");
  joinbtn->setEnabled(false);
}
bool KNAP_Channellist::showAll()
{
  return true; // return if selected
}
void KNAP_Channellist::joinPressed()
{
  // get current text
  QListViewItem *i = channellist->selectedItem();

  if(i && i->text(0)) 
  {
    cerr << "KNAP_Channellist::joinPressed(): " << i->text(0) << endl; 
    //emit join(i->text(0));
    emit sendcommand(QString("/join ") + i->text(0));
  }
}
void KNAP_Channellist::updatePressed()
{
  //emit get_list();
  emit sendcommand("/list");
}

void KNAP_Channellist::startChannellist()
{
  status->setText("Loading channel list...");
}

void KNAP_Channellist::endChannellist()
{
   QString t = QString(i18n("Done -")) + QString().setNum(channellist->childCount())
     + i18n(" Channels."); 
   status->setText(t);
}

void KNAP_Channellist::addChannel(const char *data)
{
  QString tmp = data;

  QString chan = extractString(tmp);
  QString users = extractString(tmp);

  if(channellist->find(chan)!=0) return; // already here
  
  QListViewItem *i = new QListViewItem(channellist,chan,users,tmp);


  QString t = QString(i18n("Loading channel list... -")) 
     + QString().setNum(channellist->childCount()) + i18n(" Channels."); 

   status->setText(t);


  return;
}
//void KNAP_Channellist::channelSelected(QListViewItem *item)
void KNAP_Channellist::channelSelected()
{
  joinbtn->setEnabled(true);
}
