// TODO

#include "knap_chanpanel.h"
#include "knap_listview.h"

#include "knap_preferences.h"

#include "support_funcs.h"

#include <qsplitter.h> 
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <ktextbrowser.h>
#include <klocale.h>
#include <qpopupmenu.h>

#include <qdatetime.h>
//#include "user.xpm"

#include <kfiledialog.h>
#include <qfile.h>
#include <qtextstream.h> 

#include "speedvgood.xpm"
#include "speedgood.xpm"
#include "speedaverage.xpm"
#include "speedbad.xpm" 

#include <iostream>

KNAP_ChanPanel::KNAP_ChanPanel(QWidget *parent,const char *name)
: QFrame(parent,name)
{
   firstline = true;
   echo = false;
   
//   setFrameStyle( QFrame::Panel | QFrame::Sunken );

   QGridLayout *grid=new QGridLayout(this,3,2,5,5);

   topic = new QLabel("",this,"topic");
   topic->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   grid->addMultiCellWidget(topic,0,0,0,1);

   QSplitter *main = new QSplitter(QSplitter::Horizontal,this);
   grid->addMultiCellWidget(main,1,1,0,1);   

   chantext = new KTextBrowser(main,"text");

   users = new KNAP_ListView(main,"users");
   users->addColumn(i18n("Nick"),100);
   users->setColumnWidthMode(0,QListView::Manual); 
   users->addColumn(i18n("Files"),50);
   users->setColumnWidthMode(1,QListView::Manual); 
   users->addColumn(i18n("Speed"),50);
   users->setColumnWidthMode(1,QListView::Manual); 
   users->loadWidths();

   main->setResizeMode(chantext,QSplitter::Stretch);
   main->setResizeMode(users,QSplitter::KeepSize);

   command = new QLineEdit(this,"command");
   grid->addWidget(command,2,0); 
   connect(command,SIGNAL( returnPressed() ),this,SLOT( calcCommand() ));

   QPushButton * closebtn = new QPushButton(i18n("Close"),this,"close");
   closebtn->setMaximumSize(closebtn->sizeHint());
   grid->addWidget(closebtn,2,1); 
   connect(closebtn,SIGNAL( clicked() ), this,SLOT( closePressed() ));


   popupmenu=new QPopupMenu();

   if(popupmenu)
   {
      popupmenu->insertItem(i18n("Add user to hotlist"),this,SLOT(popupAddHotlist()));
  	 popupmenu->insertSeparator();
      popupmenu->insertItem(i18n("Message user"),this,SLOT(popupMessage()));
      popupmenu->insertItem(i18n("Ping user"),this,SLOT(popupPing()));
      popupmenu->insertItem(i18n("Whois user"),this,SLOT(popupWhois()));
      popupmenu->insertSeparator();
      popupmenu->insertItem(i18n("Ignore user"),this,SLOT(popupIgnore()));
      popupmenu->insertItem(i18n("Unignore user"),this,SLOT(popupUnignore()));
      popupmenu->insertSeparator();

      // if show admin menus
      // was allowed
      popupmenu->insertItem(i18n("Kill user"),this,SLOT(popupKill()));
  	 popupmenu->insertSeparator();
      popupmenu->insertItem(i18n("Kick user"),this,SLOT(popupPing()));
	 popupmenu->insertSeparator();
      popupmenu->insertItem(i18n("Op user"),this,SLOT(popupPing()));
      popupmenu->insertItem(i18n("Deop user"),this,SLOT(popupPing()));
   	 // muzzel?
         // ban

      
      connect(users,
         SIGNAL(rightButtonPressed( QListViewItem *, const QPoint &, int )),
         this,SLOT(popupMenu( QListViewItem *, const QPoint &, int )));                    
   }


   setTopic(name); // set the name of the start topic text until 

//   // TODO remove this test

}
KNAP_ChanPanel::~KNAP_ChanPanel()
{

}
void KNAP_ChanPanel::addUser(QString userdata,bool notify)
{
   // print usernotification
   fixString(userdata);

   // add user

   QString user;
   QString files;
   QString speed;

   // extract the parts out
   user = extractString(userdata);
   files = extractString(userdata);
   speed = extractString(userdata);

   // convert speed to a text??
   int s = speed.toInt();
   speed = convertSpeed(s);


   if(notify)
   {
      QString temp = "*** " + QTime::currentTime().toString() + ": " 
	 + user + i18n(" has entered the channel");
      writeString(temp,MessageNotify);
   }

   QListViewItem *it = users->find(user);
   if(!it)
   {
      it = new QListViewItem(users, user,files,speed);
      if(it) 
      {
	 //	 it->setPixmap(0,QPixmap((const char **)user_xpm)); 
	 if(s<1) it->setPixmap(0,QPixmap((const char **)speedbad_xpm));
	 else if(s<5) it->setPixmap(0,QPixmap((const char **)speedaverage_xpm));
	 else if(s<8) it->setPixmap(0,QPixmap((const char **)speedgood_xpm));
	 else it->setPixmap(0,QPixmap((const char **)speedvgood_xpm));
      }
   }
   //users->insertItem()
}
void KNAP_ChanPanel::remUser(QString userdata) 
{
   // print usernotification
   fixString(userdata);

   // delete user
   QString user = extractString(userdata);


   unsigned int i;

   // find it
   QListViewItem *it = users->find(user);
   if(it)
   {
      delete it;

      QString temp = "*** " +  QTime::currentTime().toString() + ": " 
	 + user + i18n(" has left the channel");

      writeString(temp,MessageNotify);
   }
}
void KNAP_ChanPanel::setOffline()
{
   // clear the userlist
   users->clear();

   // turn off the command text and menus?
   QString msgstr = i18n("-------- Offline ---------");
   writeString(msgstr,MessageError); 

   return;
}
void KNAP_ChanPanel::addUserMessage(QString userdata)
{

   QString user = extractString(userdata);
   KNAP_Preferences p;
   userdata = fixString(userdata);
   if(p.languagefilter) userdata = filterLanguage(userdata);
   
   if(user.compare(whoami)!=0)
   {
      // add color stuff to it
      userdata = getFontString(MessageMessage) + userdata + "</font>";
   }
   else userdata = getFontString(MessageNormal) + userdata + "</font>";

   user = "<b>&lt;" + user + "&gt;</b> " + userdata; // + "<br>"; // + "\n";

   writeString(user);  
}
void KNAP_ChanPanel::addUserActionMessage(QString userdata)
{
   //userdata = fixString(userdata);
   KNAP_Preferences p;
   
   QString user = extractString(userdata);

   userdata = fixString(userdata);
   if(p.languagefilter) userdata = filterLanguage(userdata);
   
   if(user.compare(whoami)!=0)
   {
      // add color stuff to it
      //
      //uses extract string to kill leading space - and coz is enclosed in ""
      userdata = getFontString(MessageMessage) + "* " + user + " " 
	 + extractString(userdata) + "</font>";
	// + userdata + "</font>";
   }
   else userdata = getFontString(MessageNormal) + "* " + user + " "
      + extractString(userdata) + "</font>";
      //+ userdata + "</font>";

   //   user = "<b>&lt;" + user + "&gt;</b> " + userdata + "\n";

   writeString(userdata);  
}
void KNAP_ChanPanel::setTopic(const QString &t)
{
   topic->setText(t);
} 
void KNAP_ChanPanel::writeString(const char *str,MessageType m) 
{
  QString msgstr(str); 
  writeString(msgstr,m);
}
void KNAP_ChanPanel::writeString(QString &str,MessageType m) 
{
   // if we need color added now - do it
   if(m!=MessageNone) str = getFontString(m) + str + "</font>";

   if(firstline) chantext->setText(str);
   else chantext->append(str);
   firstline = false;

   chantext->ensureVisible(1,chantext->contentsHeight()-1);
   //   chantext->repaint(0,chantext->height()-50,
   //	 chantext->width(),50,true);
   //   chantext->setUpdatesEnabled( TRUE );
   // make sure it redraw properly - seems to be a bug in 
   // the browser at moment that doesnt like the browser being moved 
   // after text inserted but not redrawn - ie it never redraws.
   chantext->viewport()->update();
}
QString &KNAP_ChanPanel::fixString(QString &str)
{
   // what about the case of someone using a < or > or other special char
   // - fix it here
   // NOTE: order of some of these is important
   str.replace(QRegExp("&"),"&amp;");

   str.replace(QRegExp("<"),"&lt;");
   str.replace(QRegExp(">"),"&gt;");

   //str.replace(QRegExp("\t"),"&tab;");
   str.replace(QRegExp("\n"),"<br>");


   return str;
}
void KNAP_ChanPanel::clear()
{
   chantext->setText("");
   firstline = true; 
}
void KNAP_ChanPanel::showUserlist(bool yes)
{
   if(yes==false) users->hide();
   else  users->show();
}
QString KNAP_ChanPanel::getFontString(MessageType m)
{
   QString s = "<font>"; // blank one to handle MessageNone
   QColor c = Qt::black;
   switch(m)
   {
      case MessageMessage:
	 c = KNAP_Preferences().messagecolor;
	 break;
      case MessageNotify:
	 c = KNAP_Preferences().notifycolor;
	 break;
      case  MessageError:
	 c = KNAP_Preferences().errorcolor;
	 break;    
      case  MessageNormal:
	 c = KNAP_Preferences().normalcolor;
	 break;
      default:
	 break;
   }
   if(m!=MessageNone)
      s = QString("<font color=\"") + c.name() + "\">";
   
   return s;
} 
void KNAP_ChanPanel::closePressed()
{
   QString cmd = QString("/close ") + name();
   emit sendcommand(cmd);
}
void KNAP_ChanPanel::calcCommand()
{
   QString s = command->text();
   if(s && s.length()!=0)
   {
      if(s.at(0)!='/') // must be normal message
      {
	 if(strcmp("Console",name()) == 0)
	 {
	    // cant message the console
            QString msgstr = "** Unknown command";
	    writeString(msgstr,MessageError);
            return;
	 }
	 if(echo) 
	 {
	    QString tmp = s; // make a copy to write to screen
	    tmp = "<b>#&gt;</b> " + fixString(tmp);
            //tmp = fixString(tmp);
	    writeString(tmp);
         }
	 // TODO sometimes will be a action - is starts with '"'

	 if(isUserlistShown()) s = QString("/chan ") + name() + " " + s;
	 else  s = QString("/msg ") + name() + " " + s;
      }
      else // must be a command 
      { 
	 if(strncmp("/talk",s,5)==0) { }
	 else if(strncmp("/whois",s,6)==0) { }
	 else if(strncmp("/msg",s,4)==0) { } 
	 else if(strncmp("/ping",s,5)==0) { }
	 else if(strncmp("/version",s,8)==0) { }
	 else if(strncmp("/kill",s,5)==0) { }
	 else if(strncmp("/save",s,5)==0) // FIXME this dont work
	 {
	    QString filename = KFileDialog::getSaveFileName("::KNAP_ChatPanel", 
		  /*QString::null,*/
		  "*.html",this,i18n("Save Chat"));
	    if(filename.isNull()==false)
	    {
	       QFile f(filename);
	       if ( f.open(IO_WriteOnly) ) {    // file opened successfully
		  QTextStream t( &f );        // use a text stream
		  // write a bit of a header so we know what this was
		  t << "Output of channel <b>" << name() << "</b><br>" << endl
		     << "Saved: " << QDate::currentDate().toString()  
		     <<  " " << QTime::currentTime().toString() << "<br>" << endl
		     << "<hr><p>\n\n"; 


		  // now same the text
		  //chantext->selectAll();
		  //QString s = chantext->selectedText();
		  QString s = chantext->text();
		  const char *ptr = s;
		  cerr << s <<endl;
		  while(*ptr!='\0')
		  {
		     if(*ptr!='\n') t << *ptr;
		     else t << "<br>\n";

		     ptr++;
		  }
		  f.close();
	       }   
	    }
	 }
	 else if(strncmp("/help",s,5)==0) 
	 { 

	    writeString("<b><u>HELP: Known commands</u></b>");
	    writeString(" /help \t- display this help");
	    writeString(" /talk user - open up a talk window to user");
	    writeString(" /ping user - ping this user");
	    writeString(" /msg user message - send message to this user");
	    writeString(" /whois user - request whois info on this user");
	    writeString(" /close - close this window");

	    // admin ones
	    writeString(" /ignore user - ignore this user");
	    writeString(" /unignore user - unignore this user");
	    //writeString(" /whois user - request whois info on this user");

	    return;
	 }
	 else if(strncmp("/close",s,6)==0)
	 {
	    QString chan;
	    // get the channelname if one was provided
	    chan = extractString(s);
	    chan = extractString(s);
	    // none provided - use this channel
	    if(!chan) chan=name();

	    // rebuild the command
	    s = "/close " + chan;  
	 }
	 else if(strncmp("/clear",s,6)==0)
	 {
            clear();
	 }
	 else
	 {
	    writeString("** Unknown command",MessageError);
	    return; // unknown commane
	 }
      }
      command->setText("");
      emit sendcommand(s);
   }
}
bool KNAP_ChanPanel::isUserlistShown()
{
   return users->isVisible();
}

void KNAP_ChanPanel::popupMenu( QListViewItem *i, const QPoint &, int )
{
   if(i==0) return;

//   QListView *view = i->listView();
//   QListViewItem *selecteditem=view->currentItem();

   if(popupmenu)
   {  
      popupmenu->exec(QCursor::pos());
   }
}   
 

void KNAP_ChanPanel::runCommand(QListView *view,const QString &comm)
{
  QListViewItem *item=view->firstChild();

  while(item) 
  {
      if(item->isSelected()) 
      {
	 QString u = item->text(0);
	 
	 emit sendcommand(comm + " " + u);
      }
      item = item->nextSibling();
   }
}
void KNAP_ChanPanel::popupAddHotlist()
{
  runCommand(users,"/add");
}
void KNAP_ChanPanel::popupMessage()
{
  runCommand(users,"/talk");
}
void KNAP_ChanPanel::popupPing()
{
  runCommand(users,"/ping");
}
void KNAP_ChanPanel::popupKill()
{
  runCommand(users,"/kill");
}
void KNAP_ChanPanel::popupWhois()
{
  runCommand(users,"/whois");
}
void KNAP_ChanPanel::popupIgnore()
{
  runCommand(users,"/ignore");
}
void KNAP_ChanPanel::popupUnignore()
{
  runCommand(users,"/unignore");
}
QString &KNAP_ChanPanel::filterLanguage(QString &str)
{
  //TODO perhaps a more effective filter? :)
  str.replace(QRegExp("fuck",false),"firetruck");
  str.replace(QRegExp("cunt",false),"****");
  str.replace(QRegExp("cock",false),"****");
  str.replace(QRegExp("piss",false),"leak");
  str.replace(QRegExp("clit",false),"****");
  str.replace(QRegExp("bitch",false),"female dog");

  return str;
}
