/***************************************************************************
                          napsterupload.cpp  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napsterupload.h"

#include <ksock.h>

//#include <netinet/in.h>
//#include <netdb.h>
//#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
//#include <arpa/tftp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/un.h>

#include <signal.h>

#include <stdio.h>
#include <stdlib.h>


#include <qfile.h>

#include <iostream.h>

#include "support_funcs.h"


static void sigpipe_handler(int)
{
  cerr<<"upload sigpipe caught!!\n"<<flush;
  return;
}

NapsterUpload::NapsterUpload(unsigned long ip,int port,const char *filename,
      const char *user,
      int speed,const char *dest)
: NapsterTransfer(ip,port,filename,user,speed,dest,false)
{
   //   type2 = false;
   _sock = -1;
   sock = 0;

   QString s="";
   struct in_addr in;

   //  if(_napster)
   //     //  {
   in.s_addr = ip; //_napster->ipv4_addr();
   s=inet_ntoa(in);
   //  }
   cerr<<"NapsterUpload::NapsterUpload(): type 2 " << s << " : " <<port<<endl<<flush; 
}
NapsterUpload::NapsterUpload(KSocket *s,const char *filename,const char *user,
      long size,int speed,const char *dest)
: NapsterTransfer(0,0,filename,user,speed,dest,false)
{
   sock = s;
   _sock = s->socket();
   //   type2 = true;
   cerr << "NapsterUpload::NapsterUpload() type 1\n";
}
// 2nd type

NapsterUpload::~NapsterUpload()
{
   //if(_sock!=-1) close(_sock);
   if(sock) delete sock;
}

bool NapsterUpload::start(int _listen,long sz)
{
   // set that we are initialising
   _status=DL_INIT;

   // create the thread and start us up
   //_sock=_listen;

   // no lock needed yet - not threaded yet
   _readsize=sz;

   cerr << "NapsterUpload::start()\n";
   // create the upload thread
   run();

   return true;
}

// the actual workhorce - the thread func
void NapsterUpload::run_method()
{

   // catch sigpipe signals
   signal(SIGPIPE,sigpipe_handler);


   cerr<<" NapsterUpload::run_method(): starting upload thread\n"<<flush;

   // set that we are initialising
   down();
   _status=DL_INIT;
   up();

   if(_sock!=-1) upload();
   else upload_new();

   //TODO close sock  class ??
   if(_sock!=-1) close(_sock);

   _sock=-1;

   // finsihed - determine reason
   down();
   if(_terminate) _status=DL_KILLED;
   else if(_status==DL_NOLOCALFILE
	 || _status==DL_NOCONNECT) { } // error has been set already
   else if (_readsize>=_totalsize) _status=DL_FINISHED;
   else  _status=DL_ERROR;    // only partial upload????
   up();

#ifdef DEBUG_1
   cerr<<" NapsterUpload::run_method(): finished upload thread\n"<<flush;
#endif

   return;
}

bool NapsterUpload::upload()
{
   QFile file;
   QString tmp;
   int sz,len;

   cerr<<" NapsterUpload::upload(): in upload process (normal)\n"<<flush;


   // open the file
   file.setName(_filename);
   file.open(IO_ReadOnly);

   if(!file.isOpen())
   {
#ifdef DEBUG_1
      cerr<<" NapsterUpload::upload(): no file found of name: "<<_filename<<"\n"<<flush;
#endif

      len = send(_sock,"FILE NOT FOUND",15,0);

      down();
      _status=DL_NOLOCALFILE;
      up();

      return false;
   }
   // go to asked place
   file.at(_readsize);

   down();
   _totalsize=file.size();
   up();

#ifdef DEBUG_1
   cerr<<" NapsterUpload::upload(): sending file size "<<_totalsize<<endl<<flush;
#endif

   tmp = QString().setNum(_totalsize);

   len = send(_sock,tmp,tmp.length(),0);
   if(len<=0)
   {
      down();
      _status=DL_ERROR;
      up();
      return false;
   }

   // start the actual dload
   down();
   _status=DL_DOWNLOADING;
   time(&_starttime); // set the start time
   up();

   while(!_terminate && !file.atEnd())
   {
      // read file and send data         if() return false;

      sz = file.readBlock(_buffer,1024);
      if(sz>0) 
      {
	 down();
	 _readsize+=sz;
	 up();
	 len = send(_sock,_buffer,sz,0);
	 if(len<=0)
	 {
	    down();
	    _status=DL_ERROR;
	    up();
	    return false;
	 }
      }
   }

   // set finished
   down();
   _status = DL_FINISHED;
   up();

   return true;
}

bool NapsterUpload::upload_new()
{
   fd_set fdsr,fdse;
   struct timeval tm;
   int timeout = 0;

   QFile file;
   QString tmp;
   int sz,len;


   if(_terminate) return true;


   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): in upload process (new)\n"<<flush;
   //#endif


   // open the file
   file.setName(_filename);
   file.open(IO_ReadOnly);

   if(!file.isOpen())
   {
      //#ifdef DEBUG_1
      cerr<<"NapsterUpload::upload_new(): no file found of name: "<<_filename<<"\n"<<flush;
      //#endif

      // what now !!
      down();
      _status=DL_NOLOCALFILE;
      up();

      return false;
   }

   down();
   _totalsize=file.size();
   up();


   // have to connect now
   _sock=socket(AF_INET,SOCK_STREAM,0);
   if(_sock==-1) 
   {
      //#ifdef DEBUG_1
      cerr<<"NapsterUpload::upload_new(): no socket!!\n"<<flush;
      //#endif
      down();
      _status=DL_NOCONNECT;
      up();

      return false;
   }

   if(connect(_sock,(sockaddr *)&_sockaddr,sizeof(struct sockaddr /*_sockaddr*/))<0) 
   {
      //#ifdef DEBUG_1
      cerr<<"NapsterUpload::upload_new(): Can't connect to upload addr\n"<<flush;
      //#endif
      down();
      _status=DL_NOCONNECT;
      up();

      return false;
   }

   FD_ZERO(&fdse);

   do {
      if(_terminate) return false; // got a terminate

      FD_ZERO(&fdsr);
      FD_SET(_sock,&fdsr);
      FD_ZERO(&fdse);
      FD_SET(_sock,&fdse);

      tm.tv_sec=1;
      tm.tv_usec=0;

      timeout++;
      /*
	 if(_timeoutval>0 && timeout>=60*_timeoutval)
	 {
      // no data has been read for _timeoutval mins for the header
#ifdef DEBUG_1
cerr<<"ul2: init timeout occured "<<endl<<flush;
#endif
down();
_status=DL_TIMEOUT;
up();

return false;
}
       */
      }
while(select(_sock+1,&fdsr,NULL,&fdse,&tm)<=0);

// TO DO ----------- error is here !!!!!!!!!! ?
if(FD_ISSET(_sock,&fdse))
{
   down();
   _status=DL_NOCONNECT;
   up();

   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): error doing send 'read' " << endl<<flush;
   //#endif

   return false;
}

   char c;
if(recv(_sock,&c,1,0)<=0)
{
   // recieve error -> should have been some data
   down();
   _status=DL_NOCONNECT;
   up();
   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): error doing send 'recv' " << endl<<flush;
   //#endif

   return false;
}

// now tell em what we're sending
if(send(_sock,"SEND",4,0)<0)
{
   // should really be some type of write error
   down();
   _status=DL_NOCONNECT;
   up();
   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): error doing write of SEND " << endl<<flush;
   //#endif

   return false;
}
if(_terminate) return true;

QString what = QString(_user) + " \"" + toDosName(_filename) +"\" "
+ QString().setNum(file.size());
   cerr << "NapsterUpload::upload_new(): sending: " << what << endl;
if(send(_sock,what,what.length(),0)<0)
{
   down();
   _readsize = -1;
   up();
   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): error doing write of SEND of " << what << endl<<flush;
   //#endif

   return false;
}
//#ifdef DEBUG_1
cerr<<"NapsterUpload::upload_new(): filesize was: "<< file.size() <<endl<<flush;
//#endif

// now we should get where to start from -> or a message
do 
{
   if(_terminate) return false; // got a terminate

   FD_ZERO(&fdsr);
   FD_SET(_sock,&fdsr);
   FD_SET(_sock,&fdse);

   tm.tv_sec=1;
   tm.tv_usec=0;

   timeout++;
   /*
      if(_timeoutval>0 && timeout>=60*_timeoutval)
      {
   // no data has been read for _timeoutval mins for the header
#ifdef DEBUG_1
cerr<<"ul2: init timeout occured "<<endl<<flush;
#endif
down();
_status=DL_TIMEOUT;
up();

return false;
}
    */
   }
while(select(_sock+1,&fdsr,NULL,&fdse,&tm)<=0);

if(FD_ISSET(_sock,&fdse))
{
   down();
   _status=DL_REMOTEERROR;
   up();

   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): error doing initial read " << endl<<flush;
   //#endif

   return false;
}



sz=recv(_sock,_buffer,1024,0);
if(sz>=0) _buffer[sz]='\0';
else {
   down();
   _readsize = -1;
   up();
   return false;
}
// start where we were requested to start
//#ifdef DEBUG_1
cerr<<"NapsterUpload::upload_new(): recieved size of " << _buffer << endl<<flush;
//#endif
if(strstr(_buffer,"NOT") || strstr(_buffer,"INVALID"))
{
   //#ifdef DEBUG_1
   cerr<<"NapsterUpload::upload_new(): upload wasn't wanted: " << _buffer << endl<<flush;
   //#endif
   down();
   _status = DL_REMOTEERROR;
   up();

   return false;
}

down();
_readsize=atoi(_buffer);;
file.at(_readsize);
up();

// start the actual dload
down();
_status=DL_DOWNLOADING;
time(&_starttime); // set the start time
up();

while(!_terminate && !file.atEnd())
{
   // read file and send data         if() return false;

   sz = file.readBlock(_buffer,1024);
   if(sz>0) {
      down();
      _readsize+=sz;
      up();
      len = send(_sock,_buffer,sz,0);
      if(len<=0)
      {
	 cerr << "NapsterUpload::upload_new(): read error in upload loop\n";
	 down();
	 _status=DL_ERROR;
	 up();
	 return false;
      }
   }
}
// set finished
down();
_status = DL_FINISHED;
up();
cerr << "NapsterUpload::upload_new(): upload finished\n";

return true;
}

