#include "knap_buttontabbar.h"
#include <qwidgetstack.h>
#include <qlayout.h>  
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qframe.h>
#include <qpushbutton.h>
//#include <qtoolbutton.h>
#include <kapp.h>
//#include <qpainter.h>

//#include "knap_buttontabbarlayout.h"

KNAP_ButtonTabbar::KNAP_ButtonTabbar(QWidget *parent,const char *name)
: QFrame(parent,name)
{
//   setBackgroundColor(kapp->backgroundColor);

//   QVBoxLayout * mainlayout = new QVBoxLayout( this );
//   mainlayout->setSpacing( 6 );
//   mainlayout->setMargin( 11 );    
   QGridLayout *mainlayout=new QGridLayout(this,2,1,6,11); 
   
   buttonheader = new QButtonGroup( this, "buttonheader" );
   buttonheader->setTitle( "" /*i18n( ""  )*/ );
   buttonheader->setFrameShape( QButtonGroup::NoFrame );
   buttonheader->setExclusive( TRUE );
   buttonheader->setColumnLayout(0, Qt::Vertical );
   buttonheader->layout()->setSpacing( 0 );
   buttonheader->layout()->setMargin( 0 );

   buttonheaderLayout = // new KNAP_ButtonTabbarLayout(buttonheader->layout());
      new QHBoxLayout( buttonheader->layout() );
   buttonheaderLayout->setAlignment( Qt::AlignTop );
   buttonheaderLayout->setSpacing( 6 );
   buttonheaderLayout->setMargin( 0 );

   QSpacerItem *spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
   buttonheaderLayout->addItem( spacer );

   mainlayout->addWidget( buttonheader ,0,0 );
   buttonheader->setMaximumHeight(buttonheader->sizeHint().height()+6); 
   
   widstack = new QWidgetStack( this, "knap_widstack" );  

   mainlayout->addWidget( widstack ,1,0); 

   tabcnt = 0;

//   buttonheaderLayout->insertStretch(-1,100);
   connect(buttonheader,SIGNAL( clicked( int ) ),
	 this,SLOT( setCurrentTab( int ) ));
}

KNAP_ButtonTabbar::~KNAP_ButtonTabbar()
{

}

int KNAP_ButtonTabbar::getCurrentTab()
{
   QButton *b = buttonheader->selected();
   if(b) return buttonheader->id(b);
   return 0;
}
bool KNAP_ButtonTabbar::addTab(QWidget *widget,const char *title)
{
 QPixmap blankpm; 
 return addTab(widget,title,blankpm);
}
bool KNAP_ButtonTabbar::addTab(QWidget *widget,const char *title,QPixmap &pm)
{
   // add the button for here
    QPushButton * btn = new QPushButton( buttonheader, title );
//    QToolButton * btn = new QToolButton( buttonheader, title );
//    btn->setUsesTextLabel(true);

    btn->setText( title );
    if(pm.isNull()!=true) btn->setIconSet(QIconSet(pm));
       //btn->setPixmap(pm);
    btn->setToggleButton( TRUE );
    buttonheader->insert( btn, tabcnt );
    if(tabcnt==0) 
    {
       btn->setOn( TRUE );
    }
    buttonheaderLayout->addWidget( btn );

    // now add the widget
   widstack->addWidget(widget,tabcnt); 

       setCurrentTab(getCurrentTab());
   //delete spacer;
//   buttonheaderLayout->removeAllItems();

//   spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
//   buttonheaderLayout->addItem( spacer );

    tabcnt++;
   return true;
}

void KNAP_ButtonTabbar::remTab(QWidget *wid)
{
   return;
}

void KNAP_ButtonTabbar::setCurrentTab(int t)
{
  widstack->raiseWidget(t);
  buttonheader->setButton(t);
//    tabbar->setCurrentTab(t);

      return;
}
