/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NETSETTINGSDIALOG_H
#define NETSETTINGSDIALOG_H


#include <qevent.h>

#include "global.h"



#include "netsettings.h"
#include "chartframe.h"
#include <qevent.h>

class NetSettingsDialog: public NetSettings {
Q_OBJECT
public:
    NetSettingsDialog(QWidget *parent = 0, const char *name = 0);
	~NetSettingsDialog();
	double getScaleString(const unsigned long long int value,QString *);
	
	

protected:
    bool eventFilter(QObject *,QEvent *);
	virtual void resizeEvent(QResizeEvent *);

private:
	void init();
	ChartFrame *cframe;
	
	
public slots:
	void updateStats(const net_device_stats *stats, const IfStat *total);
	void updateInfo(const AddrStat *astat);
	void updateWiFi(const WiFiStat *wstat);
	void clearWiFi();
	void clearStats();
	void clearInfo();
	

	void ifaceChange();
};

#endif
