/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kpassdlg.h>
#include <kdesu/client.h>
#include <kstandarddirs.h>
#include <kprocio.h>
#include <qdir.h>
#include <qfile.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kimageeffect.h>
#include <kiconloader.h>
#include <qlayout.h>
#include <qstringlist.h>
#include <kapplication.h>
#include <qdict.h>
#include <kwallet.h>

#include "querydev.h"
#include "devicestatdialog.h"
#include "networkdevicesdialog.h"
#include <qprocess.h>

#include <math.h>
QString abv[] = {"Kilo","Mega","Giga","Tera","Peta","Exa","Zetta","Yotta"};
QString sz_abv = "KMGTPEZY";

double getScaleTens(const Q_ULLONG value, QString& c)
{
	double ret = 0;
	int i=3;

	while (i<27) {
		double cs = pow(10,i);
		double cr = value / cs;
		if (cr > pow(10,i)) {
			i+=3;
		}
		else {
			ret=cr;
			break;
		}
	}
	if (ret == 0) {
		c=" ";
	}
	else {
		c=" "+abv[(i/3)-1].mid(0,1);
	}
	return ret;
}

double getScaleString(const Q_ULLONG value, QString& c)
{
	double ret = 0;
	int i=10;

	while (i<90) {
		double cs = pow(2,i);
		double cr = value / cs;
		if (cr > pow(2,10)) {
			i+=10;
		}
		else {
			ret=cr;
			break;
		}
	}
	if (ret == 0) {
		c=" ";
	}
	else {
		c=" "+abv[(i/10)-1].mid(0,1);
	}
	return ret;
}

QueryDev *dev;




NetworkDevicesDialog::NetworkDevicesDialog(QWidget* parent, const char* name, WFlags fl)
: QWidget(parent,name,fl)
{

	
	wifi_scan = new WifiScanDialog(0);
	
	QGridLayout *layout = new QGridLayout( this, 1, 1, 11, 6); 

    QLabel *lbl = new QLabel("Available devices: ", this );

    layout->addWidget( lbl, 0, 0 );

	
    dev_icons = new QIconView( this, "dev_icons" );
    dev_icons->setFrameShape( QIconView::Panel );
    dev_icons->setSpacing( 20 );
    dev_icons->setResizeMode( QIconView::Adjust );
    dev_icons->setMaxItemWidth( 200 );
	layout->addWidget( dev_icons, 1,0);
    
	dev = new QueryDev(this);
	connect(dev, SIGNAL(devAdded(const QString&)), this, SLOT(devAdded(const QString&)));
	connect(dev, SIGNAL(devRemoved(const QString&)), this, SLOT(devRemoved(const QString&)));
	connect(dev, SIGNAL(devUpdated(const QString&)), this, SLOT(devUpdated(const QString&)));

	//dev->queryDevices();


	connect(dev_icons, SIGNAL(rightButtonClicked(QIconViewItem *, const QPoint &)), this, SLOT(showDeviceMenu(QIconViewItem *, const QPoint &)));

	connect(dev_icons, SIGNAL(doubleClicked(QIconViewItem *)), this, SLOT(showDetails()));

	devmenu = new QPopupMenu(this);
	devmenu->setCheckable(true);
	int id = devmenu->insertItem("Bring up", this, SLOT(bringUp()));
	//devmenu->setItemEnabled(id,false);
	
	id = devmenu->insertItem("Bring down", this, SLOT(bringDown()));
	//devmenu->setItemEnabled(id,false);
	
	devmenu->insertSeparator();
	id=devmenu->insertItem(QIconSet(SmallIcon("configure")),"Assign address", this, SLOT(doConfig()));
	devmenu->setItemEnabled(id,false);
	devmenu->insertItem("Run DHCP client", this, SLOT(runDHCPClient()));	

	devmenu->insertSeparator();
	scanMenuID = devmenu->insertItem("Scan for networks",this, SLOT(wifiScan()));

	devmenu->insertSeparator();
	bitsMenuID = devmenu->insertItem("Bits per second scale", this, SLOT(toggleBPS()));
	
	
	devmenu->insertSeparator();
	//devmenu->insertItem("Scan for networks", this, SLOT(networkScan()));
	//devmenu->insertSeparator();
	devmenu->insertItem(QIconSet(SmallIcon("find")),"&Details", this, SLOT(showDetails()),  CTRL+Key_D);

	setCaption("KNetDockApp");
	

	timer = new QTimer(this);
	connect(timer,SIGNAL(timeout()),dev,SLOT(queryDevices()));
	timer->start(2000);
	
	
	stat_list.setAutoDelete(true);

	resize(400,200);

	connect (dev, SIGNAL(firstRunCompleted()), this, SLOT(firstQueryCompleted()));

	setShown(false);
// 	main->setWindowState(main->windowState() & ~WindowMinimized | WindowActive);
}

NetworkDevicesDialog::~NetworkDevicesDialog()
{
	stat_list.clear();
	if (wifi_scan)delete wifi_scan;
}

//called from DeviceStatDialog when details dialog is hidden and dock is not shown for device
void NetworkDevicesDialog::removeDetails(const QString& dev_name)
{
	stat_list.remove(dev_name);
	if (stat_list.isEmpty())
	{
		//KMessageBox::information(this,"StatList empty");
		 //close(true);
		setShown(true);
		setWindowState(windowState() & ~WindowMinimized | WindowActive);
	}
	
}

//called from menu to show details dialog of the selected iconview item
void NetworkDevicesDialog::showDetails()
{
	QIconViewItem *curr =  dev_icons->currentItem ();
	if (!curr) return;

	QString dev_name = curr->text();

	
	showDetails(dev_name,false);
}

bool NetworkDevicesDialog::close(bool mode)
{
	if (!stat_list.isEmpty()){
		
		QWidget::hide();
		//??
		return true;
	}
	else {
		return QWidget::close(mode);
	}
}


void NetworkDevicesDialog::devUpdated(const QString& dev_name)
{
	QIconViewItem *i = dev_icons->findItem( dev_name );
	if (!i) return;

	KNetDockIf *nif = dev->getDeviceList()[dev_name];

	updateIconView(nif,i);

	
}
void NetworkDevicesDialog::updateIconView(const KNetDockIf* nif, QIconViewItem *i)
{
	if (!nif) return;
	if (!i) return;
	QPixmap curr;

	if (nif->devtype == ETHER)
		curr = UserIcon("if_ether");
	else if (nif->devtype==WIFI)
		curr = UserIcon("if_wifi");
	else if (nif->devtype==LOOP)
		curr = UserIcon("if_loop");
	else if (nif->devtype==PPP)
		curr = UserIcon("if_ppp");

	if (nif->devstate == UP){
		i->setPixmap(curr);
	}
	else if (nif->devstate == DOWN){
		QImage img = curr.convertToImage();
		curr.convertFromImage( KImageEffect::toGray(img) );
		i->setPixmap(curr);		
	}
	else if (nif->devstate == NOLINK) {
		QPainter p(&curr);
		p.drawPixmap(28,18,UserIcon("link_off"));
		i->setPixmap(curr);
	}
	if (nif->devtype==WIFI)
	{
		if (nif->wstat.txpow==-1){
		QPainter p(&curr);
		p.drawPixmap(28,18,UserIcon("link_off"));
		i->setPixmap(curr);	
		}
	}
	
}
void NetworkDevicesDialog::devRemoved(const QString& dev_name)
{
	QMutexLocker lock(&mutex);

	QIconViewItem *i = dev_icons->findItem( dev_name );
	if (!i) return;
	
	dev_icons->takeItem(i);
	DeviceStatDialog *d = stat_list[dev_name];

	if (!d) return;

	d->showdock(false);
	//
	//hide will call back here removeDetails if dock is not shown for dev_name
	d->hide();
	
}
void NetworkDevicesDialog::devAdded(const QString& dev_name)
{
 	QMutexLocker lock(&mutex);

	QIconViewItem *i = new QIconViewItem( dev_icons, dev_name );
	KNetDockIf *nif = dev->update(dev_name);
	if (!nif)return;
	
	updateIconView(nif,i);

	if (readState(dev_name))
		showDetails(dev_name,true);
	
}


void NetworkDevicesDialog::showDeviceMenu(QIconViewItem *item, const QPoint& pos)
{
	if (!item)return;
	
	QString dev_name = item->text();
	
	KNetDockIf* device = dev->device(dev_name);
	if (device)
	{
		devmenu->setItemChecked(bitsMenuID, device->useBPS);
	}
	if (device->devtype==WIFI)devmenu->setItemEnabled(scanMenuID, true);
	else devmenu->setItemEnabled(scanMenuID, false);
	devmenu->popup(pos);	
}

void NetworkDevicesDialog::showDetails(const QString & dev_name, bool show_dock)
{
	QIconViewItem *curr = dev_icons->findItem(dev_name);
	if (!curr)return;

	DeviceStatDialog *d;
	if (stat_list[dev_name]) {
		d = stat_list[dev_name];
	}
	else {
		d = new DeviceStatDialog(0, dev_name);
		stat_list.insert(dev_name,d);
		connect(d,SIGNAL(removeDetails(const QString&)),this,SLOT(removeDetails(const QString&)));
		
		connect(d,SIGNAL(dockVisible(const QString&, bool)), this, SLOT(saveDockState(const QString&, bool)));
		connect(d,SIGNAL(showAllDevices()), this, SLOT(show()));
		connect(d,SIGNAL(quitAllDevices()), this, SLOT(quitAll()));
	
		d->setIcon(*curr->pixmap());
		
	}
	if (show_dock) d->toggleCheckbox(true);
	else d->show();
}

void NetworkDevicesDialog::saveDockState(const QString& dev_name, bool mode)
{

	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	cfg->writeEntry("docked",mode);
	cfg->sync();

}

bool NetworkDevicesDialog::readState(const QString& dev_name)
{
	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	bool docked =  cfg->readBoolEntry("docked",false);

	KNetDockIf *device = dev->device(dev_name);
	bool useBPS = cfg->readBoolEntry("useScaleBits",false);
	device->useBPS = useBPS;

	return docked;
}

void NetworkDevicesDialog::quitAll()
{
	timer->stop();
	
	QDictIterator<DeviceStatDialog> it(stat_list);
	for( ; it.current(); ++it ){
		devRemoved(it.currentKey());
	}
	KApplication *app = KApplication::kApplication();
	app->quit();
// 	exit(0);
}



void NetworkDevicesDialog::doConfig()
{

}

void NetworkDevicesDialog::walletClosed()
{
// 	delete m_wallet;
// 	m_wallet=0;
}

void NetworkDevicesDialog::toggleBPS()
{
	QIconViewItem *curr =  dev_icons->currentItem ();
	if (!curr) return;

	QString dev_name = curr->text();
	KNetDockIf *device = dev->device(dev_name);
	if (!device)return;

	bool useBPS = device->useBPS;
	device->useBPS=!useBPS;


	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	cfg->writeEntry("useScaleBits",device->useBPS);
	cfg->sync();


}

void NetworkDevicesDialog::wifiScan()
{
	QIconViewItem *curr =  dev_icons->currentItem ();
	if (!curr) return;

	QString dev_name = curr->text();
	wifi_scan->setDeviceName(dev_name);
	wifi_scan->rescan();
	wifi_scan->show();	
}

void NetworkDevicesDialog::runDHCPClient()
{
	QIconViewItem *curr =  dev_icons->currentItem ();
	if (!curr) return;

	QString dev_name = curr->text();

	QString cmd = "dhcpcd";
	QString cmd_params = " -n -d " + dev_name;
	QString ret = runSUCmd(cmd,cmd_params);

	

}

const QString  NetworkDevicesDialog::runSUCmd(const QString & cmd, const QString & cmd_params)
{
	QString kdesu_bin = KStandardDirs::findExe("kdesu");
// 	qWarning(kdesu_bin);

    QString cmd_bin = KStandardDirs::findExe(cmd);
// 	qWarning(cmd_bin);

    if(cmd_bin.isEmpty())
      cmd_bin = KStandardDirs::findExe(cmd, "/usr/local/sbin:/usr/sbin:/sbin");
    if(cmd_bin.isEmpty())
      cmd_bin = cmd; // try our best ;/

	QProcess proc;

	proc.addArgument( kdesu_bin );
	proc.addArgument( "-t" );
	proc.addArgument( "--noignorebutton" );
	proc.addArgument( "-c " + cmd_bin + "  " + cmd_params);
	
        
        if ( !proc.start() ) {
            // error handling
			KMessageBox::sorry ( 0,  "Unable to perform the command. Please make sure the executable "+cmd+" is in your $PATH." , "Error"  );
        }

	
	
	QString alldata="";
	

	return alldata;
// 	KDEsuClient client;
//     if (client.ping() == -1) {
//         if (client.startServer() == -1) {
//          	KMessageBox::error(0,"Can not start kdesuclient","KDESu");
//             return;
//         }
//         
//     }
	

   
    
// 	QCString cmd = "knetdockhelper -dev"; //("ifconfig eth0 192.168.3.3");
// 	cmd+=dev_name;
// 	cmd+=" -cmd ";
// 	cmd+="down";
// 	QCString pass;
// 	KPasswordDialog::getPassword(pass,"Enter root password:");
// 	client.setPass(pass,10);
// 	int ret = client.exec(cmd,"root");
// 	//KMessageBox::error(this,QString("Ret:%1").arg(ret));
}

void NetworkDevicesDialog::bringUp()
{
	QIconViewItem *curr =  dev_icons->currentItem ();
	if (!curr) return;

	QString dev_name = curr->text();
	QString cmd = "ifconfig";
	QString cmd_params = dev_name + " up";	
	QString ret = runSUCmd(cmd,cmd_params);



}

void NetworkDevicesDialog::bringDown()
{

	QIconViewItem *curr =  dev_icons->currentItem ();
	if (!curr) return;

	QString dev_name = curr->text();
	QString cmd = "ifconfig";
	QString cmd_params = dev_name + " down";
	QString ret = runSUCmd(cmd,cmd_params);
}

void NetworkDevicesDialog::firstQueryCompleted()
{
	bool found_dock=false;
	DeviceList dev_list = dev->getDeviceList();
	QDictIterator<KNetDockIf> it( dev_list );
    for( ; it.current(); ++it )
	{
		KNetDockIf *curr = it.current();
		QString dev_name = it.currentKey();

		if (readState(dev_name)){
			found_dock=true;
			break;
		}
	}
	if (!found_dock){
			setShown(true);
			setWindowState(windowState() & ~WindowMinimized | WindowActive);
	}

}
