/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ttip.h"
#include <qpainter.h>
#include <qbitmap.h>
#include <qlayout.h>
#include <qframe.h>
#include "dockif.h"

extern double getScaleString(const unsigned long long int value, QString& c);

TTip::TTip(DockIf *parent, const char *name, WFlags f)
 : QWidget(0, name,f), m_dock(parent)
{
//	QVBoxLayout *vert = new QVBoxLayout(this,2);
//	QHBoxLayout *topLayout = new QHBoxLayout( vert, 2 );
	QGridLayout *layout = new QGridLayout(this, 2,2);

	s = new SpeedFrame(this);
	s->setFrameShape(QFrame::StyledPanel);
	s->setFrameShadow(QFrame::Raised);
	

	l = new QLabel(this);
	l->setText("This is a text");
	layout->addWidget(l,0,0);
	layout->addWidget(s,0,1);
	layout->setMargin(15);
	layout->setSpacing(15);

	wifi_label = new QLabel(this);
	wifi_label->setText("");
	layout->addMultiCellWidget(wifi_label,1,1,0,1);

	adjustSize();
}


TTip::~TTip()
{
	
}
void TTip::resizeEvent(QResizeEvent *e)
{

	QBitmap m_mask(e->size().width(),e->size().height());

	QPainter maskPainter(&m_mask);

    m_mask.fill(Qt::black);

    maskPainter.setBrush(Qt::white);
    maskPainter.setPen(Qt::white);
    maskPainter.drawRoundRect(m_mask.rect(), 1600 / m_mask.rect().width(),
                              1600 / m_mask.rect().height());
    setMask(m_mask);

}
void TTip::paintEvent(QPaintEvent *e)
{
	QWidget::paintEvent(e);
	QPainter p(this);
	//p.fillRect(0,0,width(),height(), Qt::gray);
    //p.setBrush( backgroundBrush () );
	p.setPen(Qt::black);
    p.drawRoundRect( 0, 0, width(), height(), 1600/width(), 1600/height() );
}

void TTip::update(const KNetDockIf * nif)
{

	if (nif->useBPS)
		s->update(nif->total.speed*8,true);
	else
		s->update(nif->total.speed);

	
	QString tipText = QString("Monitoring: %1\n").arg(nif->if_name);
	QString val="";
	tipText += QString("Input:  %1 %2B\n").arg(getScaleString(nif->total.bytes_in,val),0,'f',2).arg(val);

	val="";
	tipText += QString("Output: %1 %2B\n").arg(getScaleString(nif->total.bytes_out,val),0,'f',2).arg(val);
	
	if (nif->devtype==WIFI)
	{
		
		QString wifiText=QString("ESSID: %1 - AP: %2").arg(nif->wstat.essid).arg(nif->wstat.ap);
		wifi_label->setText(wifiText);
		wifi_label->show();
	}
	else
	{
		wifi_label->hide();
	}
	l->setText(tipText);
	adjustSize();
}



#include "ttip.moc"
