/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kpassdlg.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>
#include <kprocio.h>
#include <qdir.h>
#include <qfile.h>

#include "wifiscandialog.h"
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <kiconloader.h>
#include "knetdockif.h"
#include <qdict.h>
#include <kmessagebox.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <querydev.h>
#include <qprocess.h>

extern QueryDev *dev;

NetListViewItem::NetListViewItem(QListView *parent) : QListViewItem(parent),index_pos(0)
{

}
int NetListViewItem::getIndex() const
{
	return index_pos;
}
void NetListViewItem::setIndex(int index)
{
	index_pos=index;
}

WifiScanDialog::WifiScanDialog(QWidget* parent, const char* name, WFlags fl)
: WifiScan(parent,name,fl)
{
	lstNetworks->setHScrollBarMode( QListView::AlwaysOff );
    lstNetworks->setVScrollBarMode( QListView::Auto );
	lstNetworks->setColumnWidthMode(0,QListView::Maximum);
	lstNetworks->setResizeMode(QListView::LastColumn);
	connect(lstNetworks, SIGNAL(currentChanged( QListViewItem * )), this, SLOT(changeSelection(QListViewItem*)));
	connect(lstNetworks, SIGNAL(doubleClicked(QListViewItem *, const QPoint&, int)), this, SLOT(details()));
	connect(lstNetworks, SIGNAL(clicked ( QListViewItem * )), this,SLOT(changeSelection(QListViewItem*)));

	connect(btnConnect, SIGNAL(clicked()), this, SLOT(wifiConnect()));
	connect(btnClose,SIGNAL(clicked()),this,SLOT(hide()));
	connect(btnRescan,SIGNAL(clicked()), this, SLOT(rescan()));
	connect(btnDetails,SIGNAL(clicked()), this,SLOT(details()));
	

	btnConnect->setEnabled(false);
	btnDetails->setEnabled(false);

	setIcon(SmallIcon("find"));
	setCaption("Scan results");
	wdetails = new WifiNetDetailsDialog(this,"details",true);

}

WifiScanDialog::~WifiScanDialog()
{
	
}


void WifiScanDialog::renderData(const WifiNetworkList & list)
{
	lstNetworks->clear();
	QDictIterator<WifiNetwork> it (list);
	int pos = 0;
	for( ; it.current(); ++it ){
		NetListViewItem *item = new NetListViewItem(lstNetworks);
		
		
		WifiNetwork *curr = it.current();
		item->setIndex(curr->index_pos);
		QString txt = "";
		txt+="ESSID: " + curr->essid + " " + curr->protocol + " Ch: " + QString::number(curr->channel) + "\n";
		//txt+="Rate: "+curr->bitrates + "\n";
		txt+="AP: "+curr->ap_mac;
		item->setText(0,txt);
		QPixmap cpix; 
		if (QString::compare(curr->mode,"Managed")==0)
			cpix = UserIcon("wifi_ap");
		else
			cpix = UserIcon("wifi_adhoc");

		if (curr->encryption==true)
		{
			QPainter p(&cpix);
			p.drawPixmap(35,20,UserIcon("locker"));
		}
		item->setPixmap(0,cpix);
		item->invalidateHeight () ;
		
		lstNetworks->insertItem(item);
		pos++;
	}
	
	
}

void WifiScanDialog::clearData()
{
	lstNetworks->clear();
	list.clear();
}

void WifiScanDialog::rescan()
{
	if(!dev_name)return;
	btnRescan->setEnabled(false);
	dev->wifiScan(dev_name, list);
	renderData(list);
	btnRescan->setEnabled(true);
	
	lstNetworks->triggerUpdate();
}

void WifiScanDialog::setDeviceName(const QString & dname)
{
	dev_name=dname;
}

void WifiScanDialog::details()
{
	NetListViewItem *curr = (NetListViewItem*)lstNetworks->currentItem();
	if (!curr)return;
	QString index_pos = QString::number(curr->getIndex());
	WifiNetwork *c_net = list[index_pos];
	if (!c_net)return;
	
	wdetails->setText(c_net->full);
	wdetails->show();
	
}

void WifiScanDialog::changeSelection(QListViewItem *curr_sel)
{
	if (!curr_sel){
		btnDetails->setEnabled(false);
		btnConnect->setEnabled(false);
		
	}
	else{
		btnDetails->setEnabled(true);
		btnConnect->setEnabled(true);
	}
}

void WifiScanDialog::wifiConnect()
{

	NetListViewItem *curr = (NetListViewItem*)lstNetworks->currentItem();
	if (!curr)return;
	QString index_pos = QString::number(curr->getIndex());
	WifiNetwork *c_net = list[index_pos];
	if (!c_net)return;
	

	QString pass="";

	QString cmd_params = dev_name + " ap "+c_net->ap_mac;

	if (c_net->encryption==true) {
		QCString passwd;
		int result = KPasswordDialog::getNewPassword (passwd, "Encryption key");
		if (result == KPasswordDialog::Accepted) {
			pass = QString(passwd);
			cmd_params+=" key " + pass;

		}
		else{
			KMessageBox::information(this,"You have to enter key to connect to encrypted network");
			return;

		}
	
	}


	QString kdesu_bin = KStandardDirs::findExe("kdesu");
//	qWarning(kdesu_bin);

	QString cmd="iwconfig";

    QString cmd_bin = KStandardDirs::findExe(cmd);
//	qWarning(cmd_bin);

    if(cmd_bin.isEmpty())
      cmd_bin = KStandardDirs::findExe(cmd, "/usr/local/sbin:/usr/sbin:/sbin");
    if(cmd_bin.isEmpty())
      cmd_bin = cmd; // try our best ;/

	QProcess proc;

	proc.addArgument( kdesu_bin );
	proc.addArgument( "-t" );
	proc.addArgument( "--noignorebutton" );
	proc.addArgument( "-c " + cmd_bin + "  " + cmd_params);
	
        
        if ( !proc.start() ) {
            // error handling
			KMessageBox::sorry ( 0,  "Unable to perform the command. Please make sure the executable "+cmd+" is in your $PATH." , "Error"  );
        }

}





