/***************************************************************************
 *
 * knetworkmanager-network.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Valentine Sinitsyn <e_val@inbox.ru> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_NETWORK_H
#define KNETWORKMANAGER_NETWORK_H

#include <qdatetime.h>

#include "knetworkmanager.h"
#define NET_STORAGE_SEPARATOR QChar(0xE000)

class KConfigBase;
class KConfigGroup;
class Encryption;

class Network
{
	public:
	  Network (const QString&);
	  Network ();
	  ~Network ();

	  bool operator == (Network);

	  void        setObjectPath         (const QString&);
	  QString     getObjectPath         (void) const;
	  void        setEssid              (const QString&);
	  QString     getEssid              (void) const;
	  void        insertHardwareAddress (const QString&);
	  void        removeHardwareAddress (const QString&);
	  QStringList getHardwareAddresses  (void) const;
	  void        setHardwareAddresses  (const QStringList&);
	  void        setStrength           (int);
	  int         getStrength           (void) const;
	  void        setFrequency          (double);
	  double      getFrequency          (void) const;
	  void        setRate               (int);
	  int         getRate               (void) const;
	  void        setMode               (int);
	  int         getMode               (void) const;
	  void        setCapabilities       (int);
	  int         getCapabilities       (void) const;
	  void        setActive             (bool);
	  bool        isActive              (void) const;
	  QStringList getEncryptionProtocol (void) const;
	  bool        isEncrypted           (void) const;
	  QDateTime   getTimestamp          (void) const;
	  void        setTimestamp          (const QDateTime &);
	  bool        isTrusted             (void) const;
	  void        setTrusted            (bool);
	  bool        isHidden              (void) const;
	  void        setHidden             (bool);
	  bool        isModified            (void) const;
	  
	  Encryption* getEncryption (void) const;
	  void        setEncryption (Encryption*);

	  /**
	   * restores the network's contents from the supplied KConfig or KConfigGroup
	   */
	  void restore( KConfigBase*, double, bool withKey = false);
	  /**
	   * write the network's properties to the supplied KConfig or KConfigGroup 
	   */
	  void persist( KConfigBase *, bool updateTimestamp = false, bool withKey = true ) const;
	  /**
	   * update timestamp only, do not touch network properties
	   */
	  void persistTimestamp( KConfigBase * ) const; 

	private:
	  Encryption*  _encryption;
	  QString      _obj_path;
	  QString      _essid;
	  QStringList  _hw_addresses;
	  int          _strength;
	  double       _frequency;
	  int          _rate;
	  QString      _passphrase;
	  bool         _active;
	  int          _mode;
	  int          _capabilities;
	  QDateTime    _timeStamp;
	  bool         _trusted;
	  bool         _hidden;
	  mutable bool _dirty;
};

#endif /* KNETWORKMANAGER_NETWORK_H */
