/***************************************************************************
 *
 * knetworkmanager-nminfo.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_NMINFO_H
#define KNETWORKMANAGER_NMINFO_H

#include "knetworkmanager.h"
#include "knetworkmanager-network.h"
#include "knetworkmanager-vpn.h"

#include <NetworkManager/NetworkManager.h>

class KNetworkManager;
class Network;
class VPNConnection;

class NetworkManagerInfo : public QObject
{
	Q_OBJECT

	public:
	  NetworkManagerInfo  ();
	  ~NetworkManagerInfo ();

	  void acquirePassphrase (QString, QString, QString, bool);
	  void push              (KNetworkManager*);

	  QStringList getNetworks ();
	  Network*    getNetworkProperties (const QString &);
	  void        emitNetworkUpdated (Network*, bool);

	  VPNConnection* getVPNConnection      (const QString &);
	  QStringList    getVPNConnectionNames (void);

	signals:
	  void networkUpdated (Network*, bool);

	public slots:
	  void userInteraction     (void);
	  void sendPassphrase      (Network*);
	  void sendPassphraseError (void);

	private:
	  KNetworkManager* _ctx;
};

#endif /* KNETWORKMANAGER_NMINFO_H */
