/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_H
#define KNETWORKMANAGER_H

#include "config.h"

#include <qmap.h>

#include <NetworkManager/NetworkManager.h>

#include "knetworkmanager-dbus.h"
#include "knetworkmanager-nminfo.h"
#include "knetworkmanager-devicestore.h"
#include "knetworkmanager-vpn.h"
#include "knetworkmanager-tray.h"
#include "knetworkmanager-state.h"

class State;
class Tray;
class DeviceStore;
class VPN;
class NetworkManagerInfo;


class KNetworkManager : public KUniqueApplication
{
	Q_OBJECT

	public:
	  KNetworkManager ();
	  ~KNetworkManager ();

	  DeviceStore*        getDeviceStore        (void);
	  VPN*                getVPN                (void);
	  NetworkManagerInfo* getNetworkManagerInfo (void);
	  DBusConnection*     getDBus               (void);
	  Tray*               getTray               (void);
	  State*              getState              (void);
	  void                notify                (void);
	  void                tag                   (void);

	private:
	  DBusConnection*     _dbus;
	  NetworkManagerInfo* _nmi;
	  DeviceStore*        _store;
	  VPN*                _vpn;
	  Tray*               _tray;
	  State*              _state;
};

#endif /* KNETWORKMANAGER_H */
