/***************************************************************************
                          dlg_challenge.cpp  -  description
                             -------------------
    begin                : Sun Jan 20 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qregexp.h>
#include "dlg_challenge.moc"

dlg_challenge::dlg_challenge(QWidget *parent, const char *name, resource *Rsrc ) :
	KDialogBase(	parent,
								name,
								FALSE,
								i18n("You've Been Challenged:"),
								User1|User2,
								Ok,
								TRUE,
								i18n("Accept"),
								i18n("Decline") )
{
	Resource = Rsrc;

	BOX_Parent = makeVBoxMainWidget();

	LABEL_Headline = new QLabel( BOX_Parent );
	COMBO_Rated = new KComboBox( BOX_Parent );
	BOX_Time = new QHBox( BOX_Parent );
		BOX_White = new QGroupBox( 2, Qt::Horizontal, "-", BOX_Time );
			BOX_WhiteBase = new QSpinBox( BOX_White );
			LABEL_WhiteBase = new QLabel( BOX_White );
			BOX_WhiteInc = new QSpinBox( BOX_White );
			LABEL_WhiteInc = new QLabel( BOX_White );
		BOX_Black = new QGroupBox( 2, Qt::Horizontal, "-", BOX_Time );
			BOX_BlackBase = new QSpinBox( BOX_Black );
			LABEL_BlackBase = new QLabel( BOX_Black );
			BOX_BlackInc = new QSpinBox( BOX_Black );
			LABEL_BlackInc = new QLabel( BOX_Black );
	BUTTON_TimeOdds = new QCheckBox( i18n("Time Odds Match"),BOX_Parent );

	LABEL_Headline->setAlignment( Qt::AlignCenter );
	COMBO_Rated->setEditable( FALSE );
	COMBO_Rated->insertItem( i18n("Unrated"), 0 );
	COMBO_Rated->insertItem( i18n("Rated"), 1 );

	BOX_WhiteBase->setMinValue( 0 );
	BOX_WhiteInc->setMinValue( 0 );
	BOX_WhiteBase->setMaxValue( 300 );
	BOX_WhiteInc->setMaxValue( 300 );
	BOX_WhiteBase->setSuffix( i18n(" min.") );
	BOX_WhiteInc->setSuffix( i18n(" sec.") );
	LABEL_WhiteBase->setText( i18n( "Base Time" ) );
	LABEL_WhiteInc->setText( i18n( "Increment" ) );

	BOX_BlackBase->setMinValue( 0 );
	BOX_BlackInc->setMinValue( 0 );
	BOX_BlackBase->setMaxValue( 300 );
	BOX_BlackInc->setMaxValue( 300 );
	BOX_BlackBase->setSuffix( i18n(" min.") );
	BOX_BlackInc->setSuffix( i18n(" sec.") );
	LABEL_BlackBase->setText( i18n( "Base Time" ) );
	LABEL_BlackInc->setText( i18n( "Increment" ) );

	showButton( User1, TRUE );
	showButton( User2, TRUE );
	enableButton( User1, TRUE );
	enableButton( User2, TRUE );
	show();
}

dlg_challenge::~dlg_challenge()
{
}

void dlg_challenge::setValues( const QString &string, const QString &local )
{
	/* we only need the first line, strip the rest */
	QString myString( string.section('\n', 0, 0) );
	QStringList list;

	/*remove all the white space between the rating brackets*/
	myString.replace( QRegExp("\\(\\s"), "(" );
	myString.replace( QRegExp("\\s\\)"), ")" );
	
	list = QStringList::split( QChar(' '), myString, FALSE );
	list[7].replace(QRegExp("\\."), "");
	if( list[0] == local )
	{
		localRating = list[1];
		otherPlayer = list[2];
		otherRating = list[3];
	}
	else
	{
		otherPlayer = list[0];
		otherRating = list[1];
		localRating = list[3];
	}
	LABEL_Headline->setText( i18n("%1 %2 vs. %3 %4\nin a %5 match.")
		.arg(local).arg(localRating).arg(otherPlayer).arg(otherRating).arg(list[5]) );
	if( list[4].lower() == "rated" )
	{	
		COMBO_Rated->setCurrentItem(1);
	}
	else
	{
		COMBO_Rated->setCurrentItem(0);
	}
	BOX_WhiteBase->setValue( list[6].toInt() );
	BOX_WhiteInc->setValue( list[7].toInt() );
	BOX_BlackBase->setValue( list[6].toInt() );
	BOX_BlackInc->setValue( list[7].toInt() );
	BOX_White->setTitle( i18n("Time Controls") );
	BOX_Black->setTitle( i18n("Time Controls") );
//	BOX_Black->setEnabled( FALSE );
//	BUTTON_TimeOdds->setChecked( FALSE );

	connect( COMBO_Rated, SIGNAL( activated(int) ), this, SLOT( slot_changed(int) ) );
	connect( BOX_WhiteBase, SIGNAL( valueChanged(int) ), this, SLOT( slot_changed(int) ) );
	connect( BOX_WhiteInc, SIGNAL( valueChanged(int) ), this, SLOT( slot_changed(int) ) );
	connect( BOX_BlackBase, SIGNAL( valueChanged(int) ), this, SLOT( slot_changed(int) ) );
	connect( BOX_BlackInc, SIGNAL( valueChanged(int) ), this, SLOT( slot_changed(int) ) );
	connect( BUTTON_TimeOdds, SIGNAL( stateChanged(int) ), this, SLOT( slot_changed(int) ) );
	connect( BUTTON_TimeOdds, SIGNAL( toggled(bool) ), this, SLOT( slot_timeOdds(bool) ) );
}

QString dlg_challenge::values( void )
{
	QString match;
	match = QString("match %1").arg(otherPlayer);
	if( COMBO_Rated->currentItem() == 0 )
		match += " unrated";
	else
		match += " rated";
	match += QString(" %1 %1").arg(BOX_WhiteBase->value()).arg(BOX_WhiteInc->value());
	if( BUTTON_TimeOdds->isChecked() )
		match += QString(" %1 %1").arg(BOX_BlackBase->value()).arg(BOX_BlackInc->value());
	return match;
}

void dlg_challenge::slot_changed( int )
{
	setButtonText( User1, i18n("Counter Offer") );
}

void dlg_challenge::slot_timeOdds( bool state )
{
	BOX_Black->setEnabled( state );
}
