/***************************************************************************
                          dlg_selectengine.cpp  -  description
                             -------------------
    begin                : Wed Aug 28 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlg_selectengine.moc"
#include <qvbox.h>
#include <qgroupbox.h>
#include <qslider.h>
#include <qlabel.h>
#include <kcombobox.h>
#include "resource.h"

dlg_selectengine::dlg_selectengine(QWidget *parent, resource *Rsrc, bool army ) :
	KDialogBase(	parent,
								0,
								TRUE,
								i18n("Select Computer Player"),
								Help|Ok,
								Ok,
								TRUE )
{
	Resource = Rsrc;
	Army = army;
	BOX_Parent = makeVBoxMainWidget();

	BOX_Engine = new QGroupBox( 1,
															Qt::Horizontal,
															i18n( "Computer Players" ),
															BOX_Parent );
	COMBO_Engine = new KComboBox( BOX_Engine );
	COMBO_Engine->setEditable( FALSE );

//	BOX_EngineHelper = new QGroupBox( 1,
//															Qt::Horizontal,
//															i18n( "Computer Players' Helper" ),
//															BOX_Parent );
//	COMBO_EngineHelper = new KComboBox( BOX_Engine );
//	COMBO_EngineHelper->setEditable( FALSE );

	buildEngineData();

	connect( COMBO_Engine, SIGNAL( activated(int) ), this, SLOT( slotCurrent(int) ) );
//	connect( COMBO_EngineHelper, SIGNAL( activated(int) ), this, SLOT( slotCurrentHelper(int) ) );


	GROUP_Strength = new QGroupBox( 3,
																	Qt::Horizontal,
																	i18n( "Player Strength" ),
																	BOX_Parent );
	LABEL_Str_Min = new QLabel( i18n( "Weak" ), GROUP_Strength );
	SLIDER_Strength = new QSlider ( 1,
																	7,
																	1,
																	Resource->Strength[ 1 * ( Army == BLACK ) ],
																	QSlider::Horizontal,
																	GROUP_Strength );
	LABEL_Str_Max = new QLabel( i18n( "Strong" ), GROUP_Strength );
	SLIDER_Strength->setTickmarks( QSlider::Below );
	connect( SLIDER_Strength, SIGNAL( valueChanged(int) ), this, SLOT( slotStrength(int) ) );
}
dlg_selectengine::~dlg_selectengine()
{
}
///////////////////////////////////////
//
//	dlg_selectengine::buildEngineData
//
///////////////////////////////////////
void dlg_selectengine::buildEngineData( void )
{
	bool FLAG1(FALSE);
//	bool FLAG2(FALSE);
	int Index(0);
	QStringList EngineList;
	engineList::Iterator enginesIT;

	/* Clear Comboboxes */
	COMBO_Engine->clear();
//	COMBO_EngineHelper->clear();

	/* Handle status of Book-engine boxes */
//	White_Use_Book->setChecked( Resource->OPTION_Book_White );
//	Engines_White_Book->setEnabled( Resource->OPTION_Book_White );

	if( Army == WHITE )
	{
		Engine1F = ENGINE_WHITE;
		Engine2F = ENGINE_WHITE_BK;
	}
	else
	{
		Engine1F = ENGINE_BLACK;
		Engine2F = ENGINE_BLACK_BK;
	}

	/* Read the engine list */
	if( Resource->engines.isEmpty() ) return;
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		EngineList.append( (*enginesIT).Name );
	}

	/* Insert engines into comboboxes */
	EngineList.sort();
	COMBO_Engine->insertStringList( EngineList );
//	COMBO_EngineHelper->insertStringList( EngineList );

	/* Now run the list again, setting the current engine for each combobox */
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & Engine1F )
			for( Index = 0; Index < COMBO_Engine->count(); Index++ )
				if( COMBO_Engine->text(Index) == (*enginesIT).Name )
				{
					COMBO_Engine->setCurrentItem(Index);
					FLAG1 = TRUE;
				}
//		if( (*enginesIT).CurrentRef & Engine2F )
//			for( Index = 0; Index < COMBO_Engine->count(); Index++ )
//				if( COMBO_EngineHelper->text(Index) == (*enginesIT).Name )
//				{
//					COMBO_EngineHelper->setCurrentItem(Index);
//					FLAG2 = TRUE;
//				}
	}

	/*
			This prevents a bug where you had to modify the
			current_engine_comboboxes before you could get any engines to run.
	*/
	if( ( !FLAG1 ) && ( COMBO_Engine->count() ) ) slotCurrent( COMBO_Engine->currentItem() );
//	if( ( !FLAG2 ) && ( COMBO_EngineHelper->count() ) ) slotCurrentHelper( COMBO_EngineHelper->currentItem() );
}
///////////////////////////////////////
//
//	dlg_selectengine::slotCurrent
//
///////////////////////////////////////
void dlg_selectengine::slotCurrent( int Index )
{
	QString Name;
	engineList::Iterator enginesIT;
	
	Name = COMBO_Engine->text(Index);
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & Engine1F ) (*enginesIT).CurrentRef -= Engine1F;
		if( (*enginesIT).Name == Name ) (*enginesIT).CurrentRef |= Engine1F;
	}
	emit valuesChanged();
}
///////////////////////////////////////
//
//	dlg_selectengine::slotCurrentHelper
//
///////////////////////////////////////
void dlg_selectengine::slotCurrentHelper( int Index )
{
	QString Name;
	engineList::Iterator enginesIT;
	
	Name = COMBO_EngineHelper->text(Index);
	for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
	{
		if( (*enginesIT).CurrentRef & Engine2F ) (*enginesIT).CurrentRef -= Engine2F;
		if( (*enginesIT).Name == Name ) (*enginesIT).CurrentRef |= Engine2F;
	}
	emit valuesChanged();
}
///////////////////////////////////////
//
//	dlg_selectengine::strength
//
///////////////////////////////////////
int dlg_selectengine::strength( void )
{
	return SLIDER_Strength->value();
}
///////////////////////////////////////
//
//	dlg_selectengine::slotStrength
//
///////////////////////////////////////
void dlg_selectengine::slotStrength( int value )
{
	Resource->Strength[Army] = value;
	emit valuesChanged();
}
