// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.11 $

//***********************************************
//***  hk_kdereport PART definition             ***
//***********************************************
#include "hk_kdereportpart.h"
#include "hk_kdereportpartfactory.h"
#include "hk_kdesimplereport.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <kparts/partmanager.h>
#include <kactionclasses.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qcombobox.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
class hk_kdereportpartprivate
{
  public:
  hk_kdereportpartprivate()
  	{
		p_report=NULL;
		activate=false;
	}
   hk_kdereportpartwidget* p_report;
   bool activate;
};

hk_kdereportpart::hk_kdereportpart(QWidget* pWidget, const char* /*widgetname*/,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    p_private=new hk_kdereportpartprivate;
    setInstance(hk_kdereportpartfactory::instance());
    p_private->p_report = new hk_kdereportpartwidget(this,pWidget,0,WDestructiveClose);
    setWidget(p_private->p_report);
    setXMLFile(locate("data","hk_kdeclasses/hk_kdereportpartdesign.rc"));

}

hk_kdereportpart::~hk_kdereportpart()
{
cerr<<"~hk_kdereportpart()"<<endl;
  if (widget())
  {
    if (p_private->p_report->simplereport()->has_changed())
      p_private->p_report->simplereport()->save_report();
  }
  delete p_private;
}



/*void hk_kdereportpart::show_dbdesignercolumndialog(void)
{
    p_private->p_table->simpledbdesigner()->show_dbdesignercolumndialog();
}*/


void hk_kdereportpart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdereportpart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries


    return true;
}


bool hk_kdereportpart::saveFile()
{
    return true;
}

void hk_kdereportpart::setXMLFile(const QString& file,bool merge,bool setxmldoc)
{
KParts::ReadWritePart::setXMLFile(file,merge,setxmldoc);
if (manager()&&manager()->activePart()==this &&! p_private->activate)
{
  p_private->activate=true;
  manager()->blockSignals(true);
  manager()->setActivePart(NULL);
  manager()->blockSignals(false);
  manager()->setActivePart(this);

  p_private->activate=false;
} 
}






KAboutData* hk_kdereportpart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdereportpart", I18N_NOOP("hk_kdereportpart"),
        "0.1", I18N_NOOP("database report editor"),
        KAboutData::License_GPL,"(c) 2002-2004, Horst Knorr <hk_classes@knoda.org>");

    return a;

}






