// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include "knodaprogram.h"
#include <hk_classes.h>
#include "hk_kdepreferencesdialog.h"
#include <kaboutapplication.h>
#include <qlineedit.h>
#include <kpushbutton.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qfont.h>
#include "knodawin.h"
#include "knodaprogrambase.h"
#include "knodamaindockwindowbase.h"
#include <klocale.h>
#include "knodaprogram.moc"
#if HAVE_CONFIG_H
#include <config.h>
#endif
/*
 *  Constructs a knodaprogram which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
knodaprogram::knodaprogram( QWidget* parent,  const char* cname, WFlags fl,struct_commandlinefields* p )
: KMainWindow( parent, cname, fl )
{

    p_mainwidget =new knodaprogrambase(this,cname,fl,p);
    setCentralWidget(p_mainwidget);
    QString logoname="Knoda V ";
    logoname+=VERSION;
    QPixmap logo =KGlobal::iconLoader()->loadIcon("knodalogo",KIcon::User);

    QPainter painter(&logo);
    painter.setFont(QFont("Helvetica",24));
//    painter.drawText(19,147,"knoda");
    painter.setPen(QPen(white));
    painter.drawText(19,187,VERSION);
//  The following text should be deactivated due to a bug in XServer of Suse 9.0
    painter.setPen(QPen(white));
    /*QString copyright=" 2002 - 2004 Horst Knorr";
    painter.rotate(90.0);
    painter.setFont(QFont("Helvetica",10));
    painter.drawText(16,-190,copyright);*/
// end SUSE 9.0 Bug
    p_mainwidget->logolabel->setPixmap(logo);

    i18n( "Adm&inistration" );

    setCaption( logoname );
    p_mainwidget->connectbutton->setText( i18n( "&Connect" ) );
    p_mainwidget->quitbutton->setText( i18n( "&Quit" ) );
    p_mainwidget->optionbutton->setText( i18n( "&Options" ) );
    p_mainwidget->aboutbutton->setText( i18n( "&About" ) );

}


/*
 *  Destroys the object and frees any allocated resources
 */
knodaprogram::~knodaprogram()
{
}

void knodaprogram::closeEvent(QCloseEvent* e)
{
KMainWindow::closeEvent(e);
qApp->quit();

}

/*
 * public slot
 */
void knodaprogram::connect_clicked(void)
{
    p_mainwidget->connect_clicked();
}
