<?php
/**
 * This Class inherits from the PHPMailer class
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-email-notification.php 230 2006-11-19 12:52:59Z lordlamer $
 */
class knowledgeroot_notification extends PHPMailer {
	var $CLASS = array();
	var $priority = 3;
	var $to_name;
	var $to_email;
	var $From = null;
	var $FromName = null;
	var $Sender = null;
	var $html = false;
	var $html_mail_header = "";

	/**
	 * add content to htmlheader for the noftificationmail
	 */
	function addMailHtmlHeader($content) {
		$this->html_mail_header .= $content;
	}
	
	/**
	 * start mailnotification
	 */
	function knowledgeroot_notification(&$CLASS) {
		$this->CLASS =& $CLASS;

		$config = $this->CLASS['vars'];

		if($config['email']['smtp_mode'] == 1) {
			$this->Host = $config['email']['smtp_host'];
			$this->Port = $config['email']['smtp_port'];
			if($config['email']['smtp_username'] != '') {
				$this->SMTPAuth  = true;
				$this->Username  = $config['email']['smtp_username'];
				$this->Password  =  $config['email']['smtp_password'];
			}
			$this->Mailer = "smtp";
		}

		if(!$this->From) {
			$this->From = $config['email']['from_email'];
		}

		if(!$this->FromName) {
			$this-> FromName = $config['email']['from_name'];
		}

		if(!$this->Sender) {
			$this->Sender = $config['email']['from_email'];
		}

		$parts = explode( ",", $config['email']['recipients']);

		foreach ( $parts as $part ) {
			$this->AddAddress($part, null);
		}

		// uncomment this for verbose SMTP debugging
		// $this->SMTPDebug = true;
		$this->SetLanguage($config['knowledgeroot']['language'], "system/phpmailer/language/");
		$this->Priority = $this->priority;

		if($config['email']['type'] == "html") {
			$this->isHTML(true);
			$this->html = true;
		}
	}

	/**
	 * send email notification
	 * id show the id of the modified element
	 */
	function send_email_notification($pageid, $elementType, $action, $name = "", $id = "", $extratext = "") {
		if($this->CLASS['vars']['email']['notification'] == 1) {
			// get pagetitle
			$pageTitle = $this->CLASS['path']->getTreePageTitle($pageid);

			// set emailsubject
			$this->Subject = $this->CLASS['language']->sys['email']['notification'] . ' (' . $this->CLASS['language']->sys['email'][$elementType] . ' "' . $name . '" ' . $this->CLASS['language']->sys['email'][$action] . ')';

			// make html mail or not
			if($this->html == true) {
				// get path
				$path = $this->CLASS['path']->getPath($pageid, $this->CLASS['kr_header']->get_base_url());

				$mailBody = '
<html>
	<head><meta http-equiv="content-type" content="text/html; " /><style type="text/css"><!--
#msg dl { border: 1px #006 solid; background: #577; padding: 6px; color: #fff; }
#msg dt { float: left; width: 6em; font-weight: bold; }
#msg dt:after { content:\':\';}
#msg dl, #msg dt, #msg ul, #msg li, #header, #footer { font-family: verdana,arial,helvetica,sans-serif; font-size: 10pt;  }
#msg dl a { font-weight: bold ; color:#fc3;}
#msg dl a:hover  { color:#ff0; }
		--></style>
		'. $this->html_mail_header .'
		<title>' . $this->CLASS['language']->sys['email']['notification'] . '</title>
	</head>
	<body>
		<div id="msg">
		<dl>
		<dt>' . $this->CLASS['language']->sys['path'] . '</dt> <dd>' . $path . '</dd>
		<dt>' . $this->CLASS['language']->sys['email']['action'] . '</dt> <dd> ' . $this->CLASS['language']->sys['email'][$elementType] . ' "' . $name . '" ' . $this->CLASS['language']->sys['email']['was'] . ' <strong>' . $this->CLASS['language']->sys['email'][$action] . '</strong>' . ($id != "" ? " (ID: " . $id . ")<br />\n" : "") . '</dd>
		<dt>' . $this->CLASS['language']->sys['email']['author'] . '</dt> <dd>' . $_SESSION['user'] . '</dd>
		<dt>' . $this->CLASS['language']->sys['email']['date'] . '</dt> <dd>' . date("D, j M Y H:i:s") . '</dd>
		</dl>
		</div>';

				if ($extratext != "") {
					$mailBody .= $extratext;
				}

				$mailBody .= '</div>
	</body>
</html>';

			} else {
				// get path
				$path = $this->CLASS['path']->getTextPath($pageid, $this->CLASS['kr_header']->get_base_url());

				$mailBody = $this->CLASS['language']->sys['path'] . ': ' . $path."\n";
				$mailBody .= 'Action: ' . $this->CLASS['language']->sys['email'][$elementType] . ' ' .$this->CLASS['language']->sys['email'][$action] . ($id != "" ? " (ID: " . $id . ")\n" : "\n");
				$mailBody .= 'Author: ' . $_SESSION['user']."\n";
				$mailBody .= 'Date: ' . date("D, j M Y H:i:s")."\n";

				if ($extratext != "") {
					$mailBody .= "\nDetail of Changes: \n\n" . $extratext . "\n";
				}
			}

			// set emailbody
			$this->Body = $mailBody;

			// send email
			if (!$this->Send()) {
				$this->CLASS['kr_header']->addwarning($this->CLASS['language']->sys['email']['errormessage'] . ': ' . $this->ErrorInfo);
			}

			// do some cleanup
			$this->ClearAddresses();
			$this->ClearAttachments();
		}
	}
}
?>