h22909
s 00000/00000/00046
d D 1.13 00/03/07 11:48:02 nitehawk 14 13
c Turn on SCCS flag
cC
cK33571
cX0xa1
e
s 00000/00000/00046
d D 1.12 00/02/10 09:22:05 nitehawk 13 12
c Delete: src/daemon.c
cC
cK57338
cPBitKeeper/deleted/.del-daemon.c
e
s 00002/00002/00044
d D 1.11 00/01/11 12:27:31 nitehawk 12 11
c Converted RCS tags to SCCS tags
cC
cK05126
cZ-08:00
e
s 00007/00000/00039
d D 1.10 99/12/21 00:03:24 nitehawk 11 10
c Moved netstartup call back into rundaemon
cC
cK11273
e
s 00014/00082/00025
d D 1.9 99/12/20 23:25:08 nitehawk 10 9
c Setup to call out to type specific daemon type handlers
cK65377
e
s 00008/00010/00099
d D 1.8 99/12/19 17:52:40 nitehawk 9 8
c Converted to global options structure
cC
cK25579
e
s 00032/00004/00077
d D 1.7 99/12/15 01:44:19 nitehawk 8 7
c Converted to use new network startup layout
cC
cK41116
e
s 00035/00010/00046
d D 1.6 99/12/15 00:07:37 nitehawk 7 6
c Partial completion of daemon code to selectively open
c listen sockets.
cC
cK32290
e
s 00024/00019/00032
d D 1.5 99/12/14 05:33:27 nitehawk 6 5
c Moved connection accepting into the network code
cC
cK44940
e
s 00023/00003/00028
d D 1.4 99/12/14 05:32:20 nitehawk 5 4
c first network connection calls
cK25559
e
s 00010/00008/00021
d D 1.3 99/12/14 05:31:16 nitehawk 4 3
c Added first calls network linkages
cK52639
e
s 00011/00004/00018
d D 1.2 99/12/14 05:30:35 nitehawk 3 2
c Expanded daemon function
cK43573
e
s 00022/00000/00000
d D 1.1 99/12/14 05:30:10 nitehawk 2 1
cF1
cK40011
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 99/12/14 05:30:10 nitehawk 1 0
c BitKeeper file /home/nitehawk/src/koalamud/src/daemon.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK09288
cPsrc/daemon.c
cR99c9621520a470d0
cV2
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 3
/* $Id: daemon.c,v 1.1 1999/11/20 02:53:04 nitehawk Exp $ */
E 3
I 3
D 4
/* $Id: daemon.c,v 1.2 1999/11/21 07:28:34 nitehawk Exp $ */
E 4
I 4
D 5
/* $Id: daemon.c,v 1.3 1999/11/23 06:07:40 nitehawk Exp $ */
E 5
I 5
D 6
/* $Id: daemon.c,v 1.4 1999/11/25 06:20:13 nitehawk Exp $ */
E 6
I 6
D 7
/* $Id: daemon.c,v 1.7 1999/12/04 04:25:09 nitehawk Exp $ */
E 7
I 7
D 12
/* $Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $ */
E 12
I 12
/* %Z% %M% %I% %Z% */
E 12
E 7
E 6
E 5
E 4
E 3
/***************************************************************\
D 7
*	Copyright (c) 1999 First Step Internet Services, Inc.	*
*		All Rights Reserved				*
*	Distributed under the BSD Licenese			*
*								*
*	Module: CORE						*
E 7
I 7
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
E 7
\***************************************************************/

D 3
#define _KOALAMUD_DAEMON_C "$Id: daemon.c,v 1.1 1999/11/20 02:53:04 nitehawk Exp $"
E 3
I 3
D 4
#define _KOALAMUD_DAEMON_C "$Id: daemon.c,v 1.2 1999/11/21 07:28:34 nitehawk Exp $"
E 4
I 4
D 5
#define _KOALAMUD_DAEMON_C "$Id: daemon.c,v 1.3 1999/11/23 06:07:40 nitehawk Exp $"
E 5
I 5
D 6
#define _KOALAMUD_DAEMON_C "$Id: daemon.c,v 1.4 1999/11/25 06:20:13 nitehawk Exp $"
E 6
I 6
D 7
#define _KOALAMUD_DAEMON_C "$Id: daemon.c,v 1.7 1999/12/04 04:25:09 nitehawk Exp $"
E 7
I 7
D 12
#define _KOALAMUD_DAEMON_C "$Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $"
E 12
I 12
#define _KOALAMUD_DAEMON_C "%Z% %K% %Z%"
E 12
E 7
E 6
E 5
E 4
E 3

D 3
#include <stdio.h>
E 3
I 3
#include "autoconf.h"
E 3

#include "version.h"
#include "koalatypes.h"
#include "daemon.h"
I 4
#include "network.h"
I 6
#include "log.h"
E 6
E 4

I 10
#include "zone.h"
#include "hub.h"
#include "client.h"

E 10
D 4
int rundaemon(int port)
E 4
I 4
D 6
int rundaemon(koalaoptions *koptions)
E 6
I 6
D 9
koalaerror rundaemon(koalaoptions *koptions)
E 9
I 9
koalaerror rundaemon(void)
E 9
E 6
E 4
{
I 11
	/* Initialize network code */
	if (netstartup() != KESUCCESS)
	{
		logerr("Error starting network, shutting down");
		return KENONETWORK;
	}

E 11
D 3
	bool shuttingdown = FALSE;
E 3
I 3
D 10
	bool running = TRUE;
D 4
	
	while(running)
E 4
I 4
D 6
	descriptor masterlisten = {0,0};
I 5
	struct sockaddr_in6 addr;
	int sock;
	socklen_t addrlen;
	fd_set acceptset;
E 6
I 6
D 8
	descriptor masterlisten = {&masterlisten, &masterlisten, 0, 0, {NULL}};
E 8
I 8
	descriptor masterlisten = {NULL, NULL, 0, 0, {NULL}};
	descriptor uplinkconnection = {NULL, NULL, 0, 0, {NULL}};
E 8
	pdescriptor client = NULL;
E 6
	char welcome[] = "Welcome to KoalaMud.  This is early development"
D 6
		" code.  Please check back later\n\r";
E 6
I 6
		" code.  Please check back later.\n\r";
	koalaerror acceptreturn;
E 6
E 5

I 8
	if (netstartup() != KESUCCESS)
	{
		logerr("Error starting network, shutting down");
		return KENONETWORK;
	}

	masterlisten.next = masterlisten.prev = &masterlisten;
	uplinkconnection.next = uplinkconnection.prev = &uplinkconnection;

E 8
D 6
	if (! netstartup(&masterlisten, koptions->port))
E 6
I 6
D 7
	if (netstartup(&masterlisten, koptions->port) < 0)
E 7
I 7
	/* Create uplink connection if server type is client */
D 9
	if (koptions->daemontype == DAEMON_CLIENT)
E 9
I 9
	if (koptions.daemontype == DAEMON_CLIENT)
E 9
E 7
E 6
E 4
	{
I 8
D 9
		if (netuplink(&uplinkconnection, koptions->uplinkopts.uplinkhost,
						koptions->uplinkopts.uplinkport) < 0)
E 9
I 9
		if (netuplink(&uplinkconnection) < 0)
E 9
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
		masterlisten.next = masterlisten.prev = &masterlisten;
		uplinkconnection.next = uplinkconnection.prev = &masterlisten;
E 8
I 6
D 7
		logerr("Error starting network interface, shutting down");
E 6
D 4
		sleep(10);
		running = FALSE;
E 4
I 4
		return KENONETWORK;
E 7
I 7
	}

	/* If we are setting up a zone server, we should connect to a hub
	 * server if the uplink is defined, otherwise, start listening on the
	 * uplink port */
D 9
	if (koptions->daemontype == DAEMON_ZONE)
E 9
I 9
	if (koptions.daemontype == DAEMON_ZONE)
E 9
	{
D 8
		if (FALSE)
E 8
I 8
D 9
		if (koptions->uplinkopts.uplinkopt)
E 9
I 9
		if (koptions.uplinkopts.uplinkopt)
E 9
		{
D 9
			if (netuplink(&uplinkconnection, koptions->uplinkopts.uplinkhost,
					koptions->uplinkopts.uplinkport) < 0)
E 9
I 9
			if (netuplink(&uplinkconnection) < 0)
E 9
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
		else
E 8
		{
D 8
			if (netstartup(&masterlisten, koptions->port) < 0)
E 8
I 8
D 9
			if (netlisten(&masterlisten, koptions->port) < 0)
E 9
I 9
			if (netlisten(&masterlisten, koptions.port) < 0)
E 9
E 8
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
	}
	else
	{
		/* we are starting either a hub server or a client server,
		 * either way, we need a listen socket */
D 8
		if (netstartup(&masterlisten, koptions->port) < 0)
E 8
I 8
D 9
		if (netlisten(&masterlisten, koptions->port) < 0)
E 9
I 9
		if (netlisten(&masterlisten, koptions.port) < 0)
E 9
E 8
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
E 7
E 4
	}
D 5
	
E 5
I 5

	while (running)
E 10
I 10
	switch(koptions.daemontype)
E 10
	{
D 6
		FD_ZERO(&acceptset);
		FD_SET(masterlisten.socket, &acceptset);
E 6
I 6
D 10
		acceptreturn = netaccept(&masterlisten, &client);
		if (acceptreturn == KENOMEM)
		{
			close(masterlisten.socket);
			return KENOMEM;
		}
		if (acceptreturn == KENOACCEPT)
		{
			/* Probaly just no connections waiting
			 * 	shouldn't get this in normal operations */
			logdbg("No connections waiting");
I 8
			continue;
E 8
		}
E 6

I 7
		netwrite(client, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
E 7
D 6
		select(masterlisten.socket +1, &acceptset, NULL,
				&acceptset, NULL);
E 6
I 6
		netwrite(client, welcome, strlen(welcome));
E 6

D 6
		sock = accept(masterlisten.socket, &addr, &addrlen);

		write(sock, welcome, strlen(welcome));

		close(sock);
E 6
I 6
		netclose(client);
E 10
I 10
	case DAEMON_CLIENT:
		return clientdaemon();
	case DAEMON_ZONE:
		return zonedaemon();
	case DAEMON_HUB:
		return hubdaemon();
	case DAEMON_UNKNOWN:
		logerr("Daemon type unspecified");
		return KEMISSINGARG;
E 10
E 6
	}
E 5
E 3
D 4
	return port;
E 4
I 4
D 10
	
E 10
	return KESUCCESS;
E 4
}
E 2
I 1
E 1
