/* @(#) log.c 1.19 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_LOG_C "@(#) nitehawk@localhost.1ststep.net|lib/koala/log.c|20000823030025|12682 @(#)"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

/* globals */
logging_status loggingstatus =  {
	FALSE,  // Uninitialized
	NULL,   /* Rest is filehandles */
	NULL,
	NULL,
};

char *pritags[] =
{
	"%LOGMSG-EMERGENCY%",
	"%LOGMSG-ALERT%",
	"%LOGMSG-CRITICAL%",
	"%LOGMSG-ERROR%",
	"%LOGMSG-WARNING%",
	"%LOGMSG-NOTICE%",
	"%LOGMSG-INFO%",
	"%LOGMSG-DEBUG%",
};

/* Log messages - Eventually convert into syslog wrapper */
void logmsg(logmsgpri priority, char *format, ...)
{
	time_t curtime;
	struct tm *loctime;
	char buf[MAXLOGLINELEN+5];
	va_list ap;

	/* Error check */
	if (priority < LOGEMERG || priority > LOGDEBUG || format == NULL)
	{
		return;
	}

	/* Build and write the timestamp */
	curtime = time(NULL);
	loctime = localtime(&curtime);
	snprintf(buf, sizeof(buf), "[%04d/%02d/%02d %02d:%02d:%02d] %s ",
			1900+loctime->tm_year, loctime->tm_mon, loctime->tm_mday,
			loctime->tm_hour, loctime->tm_min, loctime->tm_sec,
			pritags[priority]);
	fprintf(loggingstatus.handle, "%s", buf);

	/* Build a string to output */
	va_start(ap, format);
	(void) vsnprintf(buf, sizeof(buf), format, ap);
	va_end(ap);

	fprintf(loggingstatus.handle, "%s\r\n", buf);
	fflush(loggingstatus.handle);

}

/* log a standard message */
/*
void logmsg(char *msg)
{
	char timestamp[] = "[00:00:00] \0";
	time_t curtime;
	struct tm *loctime;

	curtime = time(NULL);
	loctime = localtime(&curtime);
	sprintf(timestamp, "[%02d:%02d:%02d]", loctime->tm_hour,
			loctime->tm_min, loctime->tm_sec);

	fprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
	fflush(loggingstatus.msghandle);
}
*/

/* Log an error message */
void logerr(char *msg)
{
	char timestamp[] = "[00:00:00] ERROR: \0";
	time_t curtime;
	struct tm *loctime;

	curtime = time(NULL);
	loctime = localtime(&curtime);
	sprintf(timestamp, "[%02d:%02d:%02d] ERROR: ", loctime->tm_hour,
			loctime->tm_min, loctime->tm_sec);

	fprintf(loggingstatus.errhandle, "%s %s\r\n", timestamp, msg);
	fflush(loggingstatus.errhandle);
}

/* Log a debug message if compiled with --enable-debug */
void logdbg(char *msg)
{
#if DEBUG
	char timestamp[] = "[00:00:00] DEBUG: \0";
	time_t curtime;
	struct tm *loctime;

	curtime = time(NULL);
	loctime = localtime(&curtime);
	sprintf(timestamp, "[%02d:%02d:%02d] DEBUG: ", loctime->tm_hour,
			loctime->tm_min, loctime->tm_sec);

	fprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
	fflush(loggingstatus.msghandle);
#endif
}

/* Log a standard message if the verbosity level is above the specified level */
void logverbose(char *msg, int level)
{
	char timestamp[] = "[00:00:00] \0";
	time_t curtime;
	struct tm *loctime;

	if (level >= koptions.verbosity)
	{
		curtime = time(NULL);
		loctime = localtime(&curtime);
		sprintf(timestamp, "[%02d:%02d:%02d] ", loctime->tm_hour,
				loctime->tm_min, loctime->tm_sec);

		fprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
		fflush(loggingstatus.msghandle);
	}
}

/* loginit - Initialize logging - Open disk logging files */
koalaerror loginit(char *outfname, char *errfname)
{
	/* Don't reopen things if we are not spawning to background
	 * or we already opened the logs */
	if ((((koptions.spawnbackground == 1) && confquerybackground()) ||
			((koptions.spawnbackground != 1) && koptions.spawnbackground))
			&& !loggingstatus.initialized)
	{
		loggingstatus.handle = fopen(outfname, "a+");
		loggingstatus.msghandle = loggingstatus.handle;
		loggingstatus.errhandle = loggingstatus.handle;
		loggingstatus.initialized = TRUE;
	}
	return KESUCCESS;
}

/* logpreinit - This should be the first function called.
 * 	Initialized logging handles to point to stdout and stderr */
koalaerror logpreinit(void)
{
	loggingstatus.handle = stdout;
	loggingstatus.msghandle = stdout;
	loggingstatus.errhandle = stderr;
	return KESUCCESS;
}
