h65266
s 00000/00001/00208
d D 1.11 00/09/10 19:32:14 nitehawk 12 11
c Remove extra variables
cC
cK18831
e
s 00012/00015/00197
d D 1.10 00/08/26 19:52:49 nitehawk 11 10
c convert all logging calls into logmsg
cC
cK20013
e
s 00003/00006/00209
d D 1.9 00/08/22 20:17:48 nitehawk 10 9
c Converting to new logmsg
cC
cK12996
e
s 00001/00001/00214
d D 1.8 00/08/20 21:46:46 nitehawk 9 8
c Update startup function call to pass module info
cC
cK17154
e
s 00001/00001/00214
d D 1.7 00/08/12 20:22:57 nitehawk 8 7
c Fix bug in unloader
cC
cK17686
e
s 00020/00000/00195
d D 1.6 00/08/10 09:21:33 nitehawk 7 6
c Prevent loading a module multiple times
cC
cK17175
e
s 00006/00000/00189
d D 1.5 00/08/08 22:03:52 nitehawk 6 5
c Add getmodlisthead function
cC
cK49683
e
s 00007/00001/00182
d D 1.4 00/08/07 20:27:36 nitehawk 5 4
c Add initgeneric funtion
c Pass pointer to initgeneric to module startup
cC
cK40009
e
s 00101/00005/00082
d D 1.3 00/08/01 20:26:50 nitehawk 4 3
c Start building list of loaded modules
c unloadmodule function
c finish up loadmodule
cC
cK28208
e
s 00070/00000/00017
d D 1.2 00/07/29 23:22:29 nitehawk 3 2
c loadmodule function started
cC
cK38125
e
s 00017/00000/00000
d D 1.1 00/07/29 17:51:20 nitehawk 2 1
cF1
cK32310
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 00/07/29 17:51:20 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/src/koalamud/lib/koalamod/loader.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHlocalhost.1ststep.net
cK13211
cPlib/koalamod/loader.c
cRe23ff8d247693025
cV3
cX0xa1
cZ-07:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: KoalaMod
\***************************************************************/

#define _KOALAMUD_LOADER_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>
I 3
#include <dlfcn.h>
E 3

#include "version.h"
I 3
#include "module.h"
I 4
#include "llist.h"
#include "log.h"
E 4
E 3

/* This file contains the code that loads individual modules.  */
I 3

I 4
listnodeptr dynmodlist = NULL;

E 4
/* Load a dynamic module for koala. */
D 4
loadererr_t loadmodule(char *modname, char *path, modtype_t modtype)
E 4
I 4
loadererr_t loadmodule(char *modname, char *path, modtype_t modtype,
		pdescriptor desc)
E 4
{
	dynmod_t *newmod = NULL;
I 7
	dynmod_t *pmod = NULL;
	listnodeptr curmod = dynmodlist;
E 7
I 4
D 11
	char buf[256];
E 11
E 4

	/* Error check */
	if (modtype == MODTYPE_NULL || modname == NULL || path == NULL)
	{
		return LOADERERR_BADARGS;
	}
I 7

	/* Verify that the module is not already loaded */
	while (curmod)
	{
		pmod = (dynmod_t *)curmod->data.generic;
		if (pmod == NULL)
			break;

		if (strcasecmp(pmod->modname, modname) == 0)
		{
D 10
			snprintf(buf, 256, "loadmodule: Module '%s' already loaded!",
E 10
I 10
			logmsg(LOGWARN, "loadmodule: Module '%s' already loaded!",
E 10
					modname);
D 10
			logmsg(buf);
E 10
			return LOADERERR_LOADFAIL;
		}
		curmod = listnextnode(curmod);
	}

E 7

I 4
D 10
	snprintf(buf, 256, "loadmodule: Loading module '%s'", modname);
	logmsg(buf);
E 10
I 10
	logmsg(LOGINFO, "loadmodule: Loading module '%s'", modname);
E 10

E 4
	/* Attempt to allocate new dynamic module */
	if ((newmod = malloc(sizeof(dynmod_t))) == NULL)
	{
I 4
D 11
		logerr("loadmodule: Unable to allocate memory");
E 11
I 11
		logmsg(LOGCRIT, "loadmodule: Unable to allocate memory");
E 11
E 4
		return LOADERERR_NOMEM;
	}

	/* Copy module information to dynamic module tracker */
	if ((newmod->path = malloc(strlen(path))) == NULL)
	{
I 4
D 11
		logerr("loadmodule: Unable to allocate memory");
E 11
I 11
		logmsg(LOGCRIT, "loadmodule: Unable to allocate memory");
E 11
E 4
		free(newmod);
	}
	if ((newmod->modname = malloc(strlen(modname))) == NULL)
	{
I 4
D 11
		logerr("loadmodule: Unable to allocate memory");
E 11
I 11
		logmsg(LOGCRIT, "loadmodule: Unable to allocate memory");
E 11
E 4
		free(newmod->path);
		free(newmod);
	}
	strcpy(newmod->path, path);
	strcpy(newmod->modname, modname);
	newmod->type = modtype;
D 4
	
E 4
I 4

	/* Create a linked list if it doesen't already exist */
	if (dynmodlist == NULL)
	{
		if ((dynmodlist = listcreate(newmod)) == NULL)
		{
D 11
			logerr("loadmodule: Unable to allocate memory");
E 11
I 11
			logmsg(LOGCRIT, "loadmodule: Unable to allocate memory");
E 11
			free(newmod->path);
			free(newmod->modname);
			free(newmod);
			return LOADERERR_NOMEM;
		}
	}
	else
	{
		listaddnode(dynmodlist, newmod);
	}

E 4
	/* First we need to verify that we have access to the module */
		/* If access does not return 0, then we don't have the right access */
	if (access(newmod->path, R_OK))
	{
I 4
D 11
		snprintf(buf, 256, "loadmodule: Access denied: %s", newmod->path);
		logerr(buf);
E 11
I 11
		logmsg(LOGERR, "loadmodule: Access denied: %s", newmod->path);
E 11
		listremovenode(dynmodlist, newmod);
E 4
		free(newmod->modname);
		free(newmod->path);
		free(newmod);
		return LOADERERR_NOACCESS;
	}

I 4
	memset((void*)&(newmod->module), 0, sizeof(module_t));

E 4
	/* We know we can access the file, now lets try loading it up */
	if ((newmod->modhandle = dlopen(newmod->path, RTLD_LAZY)) == NULL)
	{
I 4
D 11
		snprintf(buf, 256, "loadmodule: dlopen error: %s", dlerror());
		logerr(buf);
E 11
I 11
		logmsg(LOGERR, "loadmodule: dlopen error: %s", dlerror());
E 11
		listremovenode(dynmodlist, newmod);
E 4
		free(newmod->modname);
		free(newmod->path);
		free(newmod);
		return LOADERERR_LOADFAIL;
	}

	/* Find a symbol matching the module name */
	if ((newmod->startupfunc = dlsym(newmod->modhandle, newmod->modname)) == NULL)
	{
I 4
D 11
		snprintf(buf, 256, "loadmodule: Error starting module");
		logerr(buf);
E 11
I 11
		logmsg(LOGERR, "loadmodule: Error starting module");
E 11
E 4
		dlclose(newmod->modhandle);
I 4
		listremovenode(dynmodlist, newmod);
E 4
		free(newmod->modname);
		free(newmod->path);
		free(newmod);
		return LOADERERR_BADMOD;
	}

D 4
	/* Now that we have the module loaded, we need to add it to the list */
E 4
I 4
	/* Now that we have the startup function, we need to call it to
	 *    initialize everything - 0 == success */
D 5
	if ((*newmod->startupfunc)())
E 5
I 5
D 9
	if ((*newmod->startupfunc)(&initgeneric))
E 9
I 9
	if ((*newmod->startupfunc)(&modinf))
E 9
E 5
	{
		/* Startup failed - bail on the load */
D 11
		logerr("loadmodule: Unable to startup module");
E 11
I 11
		logmsg(LOGERR, "loadmodule: Unable to startup module");
E 11
		dlclose(newmod->modhandle);
		listremovenode(dynmodlist, newmod);
		free(newmod->modname);
		free(newmod->path);
		free(newmod);
		return LOADERERR_STARTUPFAIL;
	}

	return LOADERERR_SUCCESS;
}

loadererr_t unloadmodule(char *modname, pdescriptor desc)
{
	listnodeptr cur = dynmodlist;
	dynmod_t *mod;
D 12
	char buf[256];
E 12

	/* Error check parameters */
D 11
	if (modname == NULL)
E 11
I 11
	if (modname == NULL || cur == NULL)
E 11
	{
I 11
		logmsg(LOGWARN, "Attempting to unload module with no modules loaded");
E 11
		return LOADERERR_BADARGS;
	}

D 10
	snprintf(buf, 256, "Unloading module: %s", modname);
	logmsg(buf);
E 10
I 10
	logmsg(LOGINFO, "Unloading module: %s", modname);
E 10

	/* Find the module in the list */
	for (;cur; cur = listnextnode(cur))
	{
		mod = (dynmod_t *)(cur->data.generic);
		if (mod == NULL || strcasecmp(mod->modname, modname) == 0)
			break;
	}
	if (mod == NULL)
	{
D 11
		logerr("unloadmodule: Module not loaded");
E 11
I 11
		logmsg(LOGERR, "unloadmodule: Module not loaded");
E 11
		return LOADERERR_UNKNOWNMOD;
	}

	/* Shutdown module */
	if (mod->module.shutdownfn)
	{
		(mod->module.shutdownfn)();
	}

	/* At this point, the module is no longer linked together */
D 8
	dlclose(mod->path);
E 8
I 8
	dlclose(mod->modhandle);
E 8

D 11
	logdbg("DEBUG: module unloaded - Freeing memory");
E 11
I 11
	logmsg(LOGDEBUG, "unloadmodule: module unloaded - Freeing memory");
E 11
E 4

D 4
	/* For the moment, we don't keep the module open */
	dlclose(newmod->modhandle);
E 4
I 4
	/* Release tracking data */
	listremovenode(dynmodlist, mod);
	free(mod);
E 4
	
I 4
	/* Module has been successfully unloaded */
E 4
	return LOADERERR_SUCCESS;
I 5
}

/* Generic init function - use this as an example for other loader functions
 */
void initgeneric(modtype_t type)
{
E 5
}
I 6

/* Get a pointer to the head of the module list */
listnodeptr getmodlisthead(void)
{
	return dynmodlist;
}
E 6
E 3
E 2
I 1
E 1
