h08783
s 00060/00027/00128
d D 1.7 00/03/12 22:11:13 nitehawk 8 7
c Convert support module state changes to use moduleops.c functions
cC
cK12880
e
s 00002/00002/00153
d D 1.6 00/03/12 09:32:14 nitehawk 7 6
c Fix startup state check
cC
cK40633
e
s 00009/00000/00146
d D 1.5 00/03/08 16:07:15 nitehawk 6 5
c Add calls to startup db module
cK40463
e
s 00079/00018/00067
d D 1.4 00/03/07 23:02:48 nitehawk 5 4
c Added vmstrerr
c All state change functions now return an error value
c modstate is now a simple enum
c coinitialize bigbuf whenever main vm module changes state
cC
cK23768
e
s 00040/00000/00045
d D 1.3 00/03/07 13:04:04 nitehawk 4 3
c Added state control to ensure that state change functions do
c not get called at the wrong times.
cC
cK08361
e
s 00001/00001/00044
d D 1.2 00/03/07 11:53:51 nitehawk 3 2
c Setup basic outline for vm driver state change functions
cC
cK33392
e
s 00045/00000/00000
d D 1.1 00/03/07 11:33:29 nitehawk 2 1
cF1
cK33153
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/07 11:33:29 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/vm/vm.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK64844
cPlib/vm/vm.c
cR659c2b5a7720e377
cV2
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
D 3
*	Copyright (c) 1999 First Step Internet Services, Inc.
E 3
I 3
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
E 3
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_VM_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

I 4
#include "module.h"
#include "vm.h"
I 5
#include "vminternal.h"
E 5

E 4
/* This file contains the API interface to the koala vm driver */

I 4
/* Global variables */
D 5
modstate_t vmmodstate = {MODSTATE_UNDEFINED};
E 5
I 5

D 8
/* Module state */
modstate_t vmmodstate = MODSTATE_UNDEFINED;
E 8
I 8
/* Module data */
module_t	vmmodule =
{
	"VM Driver",
	"%Z% %M% %I% %Z%",
	MODSTATE_UNDEFINED,
	vmstartup,
	vmlinkup,
	vmshutdown
};

/* We define a setinel module definition here for usage in the vm driver */
module_t vmnullmodule =
{
	NULL,
	NULL,
	MODSTATE_UNDEFINED,
	NULL,
	NULL,
	NULL
};

/* List of VM Driver support modules */
pmodule vmsupport[] =
{
	&bigbufmodule,
	&dbmodule,
	&vmnullmodule,
};
E 8

/* We only initialize these to defaults of they are null in linkup */
vmconfig_t vmconfig =
{
	NULL,	/* Base DB Path */
	NULL,	/* Base root DB name */
	NULL,	/* Extension */
};
E 5

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
E 4
/* vmstartup - preform vm startup tasks -  Only initialize the memory state
 * variables.  Database and full vm driver will be brought online just before
 * starting the daemon loop
 */
D 5
void vmstartup(void)
E 5
I 5
D 8
vmerr_t vmstartup(void)
E 8
I 8
int vmstartup(void)
E 8
E 5
{
I 4
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
D 5
	if (vmmodstate.status != MODSTATE_UNDEFINED ||
			vmmodstate.status != MODSTATE_STOPPED)
		return;
E 5
I 5
D 7
	if (vmmodstate != MODSTATE_UNDEFINED ||
			vmmodstate != MODSTATE_STOPPED)
E 7
I 7
D 8
	if (!(vmmodstate == MODSTATE_UNDEFINED ||
			vmmodstate == MODSTATE_STOPPED))
E 8
I 8
	if (!(vmmodule.state == MODSTATE_UNDEFINED ||
			vmmodule.state == MODSTATE_STOPPED))
E 8
E 7
		return VMBADSTATE;
E 5
	/* Reflect that we are starting up */
D 5
	vmmodstate.status = MODSTATE_STARTUPINPROGRESS;
E 5
I 5
D 8
	vmmodstate = MODSTATE_STARTUPINPROGRESS;
E 8
I 8
	vmmodule.state = MODSTATE_STARTUPINPROGRESS;
E 8
E 5

D 5
	/* Startup code goes here */
E 5
I 5
D 8
	/* Startup memory arena */
	bigbufstartup();
E 8
I 8
	/* Startup vm support modules */
	{
		int numattempted = 0;
		int errors = 0;
E 8
E 5

I 6
D 8
	/* Since the big buffers are now up, startup database module */
	dbstartup();
E 8
I 8
		modstartup(vmsupport, &vmnullmodule, &numattempted, &errors);
	}
E 8

E 6
	/* All done with startup */
D 5
	vmmodstate.status = MODSTATE_STARTED;
E 5
I 5
D 8
	vmmodstate = MODSTATE_STARTED;
E 8
I 8
	vmmodule.state = MODSTATE_STARTED;
E 8

	/* Everything Happy :) */
	return VMSUCCESS;
E 5
E 4
}

/* vmlinkup - This brings the vm driver fully online.  We expect the
 * 'vmconfig' variable to be a vmconfig_t struct with the database path and
 * database base name filled in.  The other fields can be filled in as well
 * to control certain pieces of the vm driver.  See the type definition in
 * include/vm.h for more information.
 */
D 5
void vmlinkup(void)
E 5
I 5
D 8
vmerr_t vmlinkup(void)
E 8
I 8
int vmlinkup(void)
E 8
E 5
{
I 4
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
D 5
	if (vmmodstate.status != MODSTATE_STARTED)
		return;
E 5
I 5
D 8
	if (vmmodstate != MODSTATE_STARTED)
E 8
I 8
	if (vmmodule.state != MODSTATE_STARTED)
E 8
		return VMBADSTATE;
E 5
	/* show that we are doing linkup */
D 5
	vmmodstate.status = MODSTATE_LINKUPINPROGRESS;
E 5
I 5
D 8
	vmmodstate = MODSTATE_LINKUPINPROGRESS;
E 8
I 8
	vmmodule.state = MODSTATE_LINKUPINPROGRESS;
E 8

D 8
	/* linkup memory arena */
	bigbuflinkup();
E 8
I 8
	/* Link vm support modules */
	{
		int numattempted = 0;
		int errors = 0;
E 8
E 5

I 6
D 8
	/* bigbuf linked, linup database */
	dblinkup();
E 8
I 8
		modlinkup(vmsupport, &vmnullmodule, &numattempted, &errors);
	}
E 8

E 6
	/* Linkup complete */
D 5
	vmmodstate.status = MODSTATE_LINKED;
E 5
I 5
D 8
	vmmodstate = MODSTATE_LINKED;
E 8
I 8
	vmmodule.state = MODSTATE_LINKED;
E 8

	/* Everything Happy :) */
	return VMSUCCESS;
E 5
E 4
}

/* vmshutdown - This function preforms a full backup of the database and
 * cleans up all in memory data.
 */
D 5
void vmshutdown(void)
E 5
I 5
D 8
vmerr_t vmshutdown(void)
E 8
I 8
int vmshutdown(void)
E 8
E 5
{
I 4
	/* Can't shutdown unless we are currently 'linked' */
D 5
	if (vmmodstate.status != MODSTATE_LINKED)
		return;
E 5
I 5
D 8
	if (vmmodstate != MODSTATE_LINKED)
E 8
I 8
	if (vmmodule.state != MODSTATE_LINKED)
E 8
		return VMBADSTATE;
E 5
	/* show that we are doing shutdown */
D 5
	vmmodstate.status = MODSTATE_SHUTDOWNINPROGRESS;
E 5
I 5
D 8
	vmmodstate = MODSTATE_SHUTDOWNINPROGRESS;
E 8
I 8
	vmmodule.state = MODSTATE_SHUTDOWNINPROGRESS;
E 8

D 8
	/* shutdown memory arena */
	bigbufshutdown();
E 8
I 8
	/* Shutdown vm support modules */
	{
		int numattempted = 0;
		int errors = 0;
E 8
I 6

D 8
	/* Big Buffers are now shutdown, db can go down now */
	dbshutdown();
E 8
I 8
		modshutdown(vmsupport, &vmnullmodule, &numattempted, &errors);
	}
E 8
E 6
E 5

	/* shutdown complete */
D 5
	vmmodstate.status = MODSTATE_STOPPED;
E 5
I 5
D 8
	vmmodstate = MODSTATE_STOPPED;
E 8
I 8
	vmmodule.state = MODSTATE_STOPPED;
E 8

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* Error printing functions and support */
char *vmerrtbl[] =
{
	"No Error",
	"Out of memory",
	"Bad state change attempt",
};

char *vmstrerr(vmerr_t err)
{
	char *buf = NULL;
	int tblpos = err > 0 ? 0 : err - VMEOFFSET;

	/* Make sure we aren't going to try reading past the end of the error
	 * table
	 */
	if (tblpos >= VMELAST - VMEOFFSET)
	{
		return NULL;
	}

	/* Allocate buf, we expect the caller to clean this up */
	if ((buf = malloc(strlen(vmerrtbl[tblpos]))) == NULL)
	{
		return NULL;
	}

	/* Copy the string into the buffer */
	strcpy(buf, vmerrtbl[tblpos]);

	/* All done */
	return buf;
E 5
E 4
}
E 2
I 1
E 1
