/***************************************************************************
                          scan.h  -  description
                             -------------------
    begin                : Mon Jan 8 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCAN_H
#define SCAN_H

#include <qwidget.h>
#include <qobject.h>
#include <qstack.h>
#include "smbclient.h"
#include "password.h"

/**
  *@author Frank Schwanz
  */
#define MAX_SMBCLIENTS 10
class MyHostItem;

class scan:public QObject
{
Q_OBJECT public:
  scan (QObject * parent = 0, const char *name = 0);
   ~scan ();
  void scanHost (MyHostItem * host);
  bool isWorking ()
  {
    return (smbclworkingcount > 0);
  };
private:
  int smbclworkingcount;
  QStack < MyHostItem > *smbcltodolist;
  public slots:
	/***************************************************************************
	 * slot for errorhandling when smbclient exit												       *
	 ***************************************************************************/
  void smbclientIsExited (smbclient * smbcl, const QString & err,
			  MyHostItem * hostitem);

signals:
  void allSmbClientExited ();
};

#endif
