/***************************************************************************
 *   Copyright (C) 2005-2006 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


/* This file uses main parts of "fdupes.c" from fdupes-1.40.
	Copyright: */

/* FDUPES Copyright (c) 1999 Adrian Lopez

	Permission is hereby granted, free of charge, to any person
	obtaining a copy of this software and associated documentation files
	(the "Software"), to deal in the Software without restriction,
	including without limitation the rights to use, copy, modify, merge,
	publish, distribute, sublicense, and/or sell copies of the Software,
	and to permit persons to whom the Software is furnished to do so,
	subject to the following conditions:

	The above copyright notice and this permission notice shall be
	included in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
	CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
	TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

#ifndef _KOMPAREJOB_H_
#define _KOMPAREJOB_H_

#include <qthread.h>

#include <kapplication.h>

class KFileItemExt;
class KURL;
class KProcess;

typedef struct _FileTree
{
	KFileItemExt *file;
	struct _FileTree *left;
	struct _FileTree *right;
} FileTree;

class KompareJob : public QThread
{
	public:
		KompareJob( QWidget *_parent );
		~KompareJob();
		void initialize( KFileItemExt *_files, bool _ignore_empty, bool _size, bool _calculate_checksum,
										bool _binary_comparison, uint _binary_comparision_threshold, uint _number_of_files, const KURL &_url1, const KURL &_url2,
										bool _enable_duplicates_search, bool _enable_missing_search, bool _enable_newer_search, bool _case_sensitive );
		void start();
		void stop();
		void run();

		bool cancel();

	private:
		KFileItemExt *m_files;
		KURL *m_url1, *m_url2;
		bool m_initialized, m_canceled;
		bool m_ignore_empty, m_size, m_calculate_checksum, m_binary_comparison;
		bool m_enable_duplicates_search, m_enable_missing_search, m_enable_newer_search;
		bool m_case_sensitive;
		uint m_binary_comparision_threshold; // only check files smaller than *** MB.
		uint m_number_of_files;
		QWidget *m_parent;
		QMutex m_mutex;

		void emitProgress( QString str, int percent );
		void emitMessage( const QString &message, const QString &title );

		int registerFile( FileTree **branch, KFileItemExt *file );
		KFileItemExt *checkMatchDupes( FileTree **root, FileTree *checktree, KFileItemExt *file );
		KFileItemExt *checkMatchComp( FileTree **root, FileTree *checktree, KFileItemExt *file );
		bool confirmMatchDupes( KFileItemExt *item1, KFileItemExt *item2 );
		int comparePath( KFileItemExt *item1, KFileItemExt *item2 );
		KFileItemExt *newerItem( KFileItemExt *item1, KFileItemExt *item2 ); // returns the newer item of the two, or NULL if both have the same age.
		void purgeTree( FileTree *tree );
};

#endif
