/***************************************************************************
 *   Copyright (C) 2005-2006 by Georg Hennig                               *
 *   Email: Georg Hennig                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "komparator.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

static const char description[] =
		I18N_NOOP( "A KDE Duplicate Files Find\nAnd Folder Compare Program." );

static const char version[] = VERSION;

static KCmdLineOptions options[] =
{
	{ "+[URL 1]", I18N_NOOP( "First URL to search" ), 0 },
	{ "+[URL 2]", I18N_NOOP( "Second URL to search" ), 0 },
		KCmdLineLastOption
};

int main( int argc, char **argv )
{
	KLocale::setMainCatalogue( "komparator" );

	KAboutData about( "komparator", "Komparator", version, description,
										KAboutData::License_GPL, "(C) 2005-2006 Georg Hennig", 0, 0, "georg.hennig@web.de" );
	about.addAuthor( "Georg Hennig", 0, "georg.hennig@web.de" );
	KCmdLineArgs::init( argc, argv, &about );
	KCmdLineArgs::addCmdLineOptions( options );
	KApplication app;
	Komparator *mainWin = 0;

	if ( app.isRestored() )
	{
		RESTORE( Komparator( KURL(), KURL() ) );
	}
	else
	{
		// no session.. just start up normally
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		KURL url1, url2;
		if ( args->count() > 0 ) url1 = args->url( 0 );
		if ( args->count() > 1 ) url2 = args->url( 1 );

		mainWin = new Komparator( url1, url2 );
		app.setMainWidget( mainWin );
		mainWin->show();

		args->clear();
	}

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	return app.exec();
}

