//                       -*- mode: C++ -*-
//
// Copyright(C) 2005 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KOPETESILC_SILCSERVERCONTACT_H
#define KOPETESILC_SILCSERVERCONTACT_H

#include "silccontact.h"

/**
 * @brief Reimplementation of Kopete::Contact class, used for SILC Servers
 *
 * The SilcServerContact class represents a SILC Server, it is used to
 * display server messages, etc.
 *
 * @author Stefan Siegl <stesie@brokenpipe.de>
 */
class SilcServerContact : public SilcContact {
  Q_OBJECT;

public:
  SilcServerContact(SilcAccount *, const QString &nickname, 
		    Kopete::MetaContact *meta,
		    const QString &icon = QString::null);
  virtual ~SilcServerContact();

  void appendMessage(const QString &);

  virtual KopeteView *view(void);

  /**
   * @brief return the primary message manager of this contact
   */
  virtual Kopete::ChatSession *manager(Kopete::Contact::CanCreateFlags =
				       Kopete::Contact::CannotCreate);

private:
  QList<Kopete::Message> msgBuffer;

private slots:
  /**
   * @brief send outgoing message
   */
  virtual void slotSendMessage(Kopete::Message &, Kopete::ChatSession *);

};

#endif // KOPETESILC_SILCSERVERCONTACT_H
