
#include <kore/version.h>
#include <kore/servicemanager.h>

#include "koredlg_mfc.h"

#define KDMFC_MAJOR 0
#define KDMFC_MINOR 0
#define KDMFC_REVISION 1
#define KDMFC_VERSION "0.0.1"
#define KDMFC_API_MAJOR 0
#define KDMFC_API_MINOR 0
#define KDMFC_API_REVISION 2
#define KDMFC_API_VERSION "0.0.2"
#define KDMFC_NAME "KoreDialog <mfc>"
#define KDMFC_TYPE KOREDLG_TYPE
#define KDMFC_DESCRIPTION "MFC-based implementation for KoreDialog"
#define KDMFC_SERVICE KOREDLG_SERVICE "/mfc"
#define KDMFC_SERVICE_DESCRIPTION "MFC-based '" KOREDLG_SERVICE "' service"

KoreDlg_mfc::KoreDlg_mfc()
{
    _kdmfcVersion = new Version(KDMFC_MAJOR,KDMFC_MINOR,KDMFC_REVISION,KDMFC_VERSION);
    _kdmfcAPIVersion = new Version(KDMFC_API_MAJOR,KDMFC_API_MINOR,KDMFC_API_REVISION,KDMFC_API_VERSION);
    _kdmfcInfo = new Info(this, KDMFC_NAME, KDMFC_TYPE, KDMFC_DESCRIPTION, _kdmfcVersion, _kdmfcAPIVersion);
    setInfo(_kdmfcInfo);
    _kdmfcService = new Service(this, KDMFC_SERVICE, KDMFC_SERVICE_DESCRIPTION);
    addService(_kdmfcService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDMFC_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_mfc::~KoreDlg_mfc()
{
    delete _kdmfcInfo;
    delete _kdmfcVersion;
    delete _kdmfcAPIVersion;
    delete _kdmfcService;
    delete _kdService;
}

void KoreDlg_mfc::showMessage(const char *msg)
{
    MessageBox(NULL, msg, KDMFC_NAME, MB_OK );
}
