
#include <qapp.h>

#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>

#include "modulebrowser.h"
//temporary
#include "modulebrowser_plugin.h"

int main(int argc, char**argv)
{
    QApplication app(argc, argv);

    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*> (sm->registeredProvider("Kore/Kernel/Module Manager"));
    Plugin* plugin = new ModuleBrowserPlugin( 0, 0, 0, 0); // Temporary
    if( mm )
        mm->registerModule(plugin);

    plugin->initPlugin();     // temp

    ModuleBrowser* browser = dynamic_cast<ModuleBrowser*> (sm->registeredProvider("Kore/UI/Module Browser"));

    app.setMainWidget(browser);
    browser->show();
    int ret =  app.exec();

    plugin->finalizePlugin(); // temp

    if( mm )
        mm->unregisterModule(plugin);
    delete plugin;
    delete Kernel::instance();
    return ret;
}
