
#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>

#include "modulebrowser_plugin.h"
#include "modulebrowser_impl.h"
#include "modviewfact_impl.h"

#define MODULEBROWSER_PLUGIN_MAJOR 0
#define MODULEBROWSER_PLUGIN_MINOR 0
#define MODULEBROWSER_PLUGIN_REVISION 1
#define MODULEBROWSER_PLUGIN_VERSION "0.0.1"
#define MODULEBROWSER_PLUGIN_API_MAJOR 0
#define MODULEBROWSER_PLUGIN_API_MINOR 0
#define MODULEBROWSER_PLUGIN_API_REVISION 2
#define MODULEBROWSER_PLUGIN_API_VERSION "0.0.2"
#define MODULEBROWSER_PLUGIN_NAME "ModuleBrowser Plugin"
#define MODULEBROWSER_PLUGIN_TYPE "Plugin"
#define MODULEBROWSER_PLUGIN_DESCRIPTION "This plugin registers the ModuleBrowser and ModuleViewFactory providers."

PLUGIN_MAIN_BODY(ModuleBrowserPlugin,libHandle,libName,libPath,libFlags);

ModuleBrowserPlugin::ModuleBrowserPlugin(HMODULE libhandle, const char* libname, const char* libpath, int flags):Plugin(libhandle,libname,libpath,flags)
{
    _pluginVersion = new Version(MODULEBROWSER_PLUGIN_MAJOR,MODULEBROWSER_PLUGIN_MINOR,MODULEBROWSER_PLUGIN_REVISION,MODULEBROWSER_PLUGIN_VERSION);
    _pluginAPIVersion = new Version(MODULEBROWSER_PLUGIN_API_MAJOR,MODULEBROWSER_PLUGIN_API_MINOR,MODULEBROWSER_PLUGIN_API_REVISION,MODULEBROWSER_PLUGIN_API_VERSION);
    _pluginInfo = new Info(this, MODULEBROWSER_PLUGIN_NAME, MODULEBROWSER_PLUGIN_TYPE, MODULEBROWSER_PLUGIN_DESCRIPTION, _pluginVersion, _pluginAPIVersion);
    setInfo(_pluginInfo);
}
ModuleBrowserPlugin::~ModuleBrowserPlugin()
{
    delete _pluginInfo;
    delete _pluginVersion;
    delete _pluginAPIVersion;
    delete browser;
    delete factory;
}
void ModuleBrowserPlugin::pluginLoaded()
{
    // Nothing to do here
}
void ModuleBrowserPlugin::initPlugin()
{
    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*>( sm->registeredProvider("Kore/Kernel/Module Manager") );
    browser = new ModuleBrowserImpl();
    factory = new ModViewFactImpl();
    if( mm )
    {
        mm->registerModule(factory);
        mm->registerModule(browser);
    }
    sm->registerProvider(factory);
    sm->registerProvider(browser);
}
void ModuleBrowserPlugin::finalizePlugin()
{
    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*>( sm->registeredProvider("Kore/Kernel/Module Manager") );
    factory->destroyViews();
    sm->unregisterProvider(browser);
    sm->unregisterProvider(factory);
    if( mm )
    {
        mm->unregisterModule(browser);
        mm->unregisterModule(factory);
    }
}
void ModuleBrowserPlugin::unloadingPlugin()
{
    finalizePlugin();
}
