//
// C++ Interface: kpgtableitemsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTABLEITEMSFOLDER_H
#define KPGTABLEITEMSFOLDER_H

#include "kpgtreeitem.h"

#include "kpgtable.h"

class QListBox;
class KListBox;
class KComboBox;

/**
  * Abstract folder for tables items - columns, indexes, 
  * rules, constraints and triggers
  *
  * @author Lumir Vanek
  */
class KPGTableItemsFolder : public KPGTreeItem
{
public:
    KPGTableItemsFolder(KPGTable *, const QString &);
	KPGTableItemsFolder(KPGTable *, KPGTableItemsFolder *, const QString &);
    ~KPGTableItemsFolder();

	virtual void activate();

	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	virtual void refresh(pqxx::oid) throw(const KPGSqlException &) = 0;
	    
    void fillListBoxWithChildItems(QListBox *);
    void fillListBoxWithChildItems(KListBox *);
    void fillComboBoxWithChildItems(KComboBox *);
		
protected:

	KPGTable * getParentItem() { return static_cast <KPGTable *> (parent()); }

protected:
	bool m_bIsLoaded;
};

#endif
