//
// C++ Implementation: kpguser
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpguser.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include <qdatetime.h>

#include "kpgusersfolder.h"


KPGUser::KPGUser(KPGUsersFolder *parent, const QString & name)
  : KPGTreeItem(parent, name)
{
  	setPixmap(0, *m_pIconUser);
}

KPGUser::KPGUser(KPGUsersFolder *parent, KPGUser *after, const QString & name)
  : KPGTreeItem(parent, after, name)
{
  	setPixmap(0, *m_pIconUser);
}

KPGUser::~KPGUser()
{
}

const QDate KPGUser::validUntil() const
{
	QDate dateValidUntil;
	
	if(m_strValUntil.length() > 9)
	{
		QString strYear(m_strValUntil.left(4));
		QString strMonth(m_strValUntil.mid(5, 2));
		QString strDay(m_strValUntil.mid(8, 2));
		
		QDate d(strYear.toInt(), strMonth.toInt(), strDay.toInt());
		dateValidUntil = d;
	}
	
	return dateValidUntil;
}

void KPGUser::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	pqxxTuple["usesysid"].to(m_iSysId);
    pqxxTuple["usecreatedb"].to(m_bCreateDb);
    pqxxTuple["usesuper"].to(m_bIsSuper);
    pqxxTuple["usecatupd"].to(m_bUCatUpd);
            
	m_strValUntil = pqxxTuple["valuntil"].c_str();
	
	if(m_bIsSuper)
		setPixmap(0, *m_pIconUserSuper);
	else
	{
		if(m_bCreateDb)
			setPixmap(0, *m_pIconUserCanCreateDb);
		else
			setPixmap(0, *m_pIconUser);
	}
}
