/***************************************************************************
                          kpgview.h  -  description
                             -------------------
    begin                : Po led 19 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGVIEW_H
#define KPGVIEW_H

#include <qwidget.h>

#include "kpgobject.h"

class KPGViewsFolder;

/**
  *	Item that represent database view
  * 
  * @author Lumir Vanek
  */
class KPGView : public KPGObject
{
public: 
	KPGView(KPGViewsFolder *, const QString, pqxx::oid);
	KPGView(KPGViewsFolder *, KPGView *, const QString, pqxx::oid);
	~KPGView();
	
	virtual eNodeType type() const { return nodeView; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "VIEW"; }
	
	void setProperties(const QString, const QString, const QString);
	void setDefinition(const QString strDefinition) { m_strDefinition = strDefinition; }
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
  	
  	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	/*
	 * Functions for accessing properties
	 */
	const QString & definition() const { return m_strDefinition; }
	const QString & owner() const { return m_strOwner; }
	const QString & acl() const { return m_strACL; }
	
protected:
	
	/*
	 * Properties
	 */
	QString m_strOwner;
	QString m_strACL;
	QString m_strDefinition;
};

#endif
