//
// C++ Interface: kpgpropertypagechildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGPROPERTYPAGECHILDVIEW_H
#define KPGPROPERTYPAGECHILDVIEW_H

// include files for KDE
#include <kmdichildview.h>
#include <kxmlguiclient.h>

// application specific includes
#include "kpgabstractpropertypage.h"

class KPGTreeItem;
class QBoxLayout;
class KPoGreView;

/**
  * MDI child view for property pages
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGPropertyPageChildView : public KMdiChildView, virtual public KXMLGUIClient
{
	Q_OBJECT
public:
    KPGPropertyPageChildView(KPoGreView *, KXMLGUIFactory *);
    ~KPGPropertyPageChildView();
    
    // Create Properties widget, with regards to selected type in tree
  	QWidget* createPropertiesWidget(KPGTreeItem *);
  	
  	// Display properties of underlying database object
	void displayProperties();
  	
  	// Return the Properties widget
  	KPGAbstractPropertyPage* getPropertyPage() const { return m_pPropertyPage; }

	// Return true, if window can be closed
	bool requestClose();
	
protected:
	// Destroy the Properties widget
	void destroyPropertiesWidget();
	
	// Add yourself to GUI factory
    void addToGuiFactory();
    
    // Remove yourself from GUI factory
    void removeFromGuiFactory();
	
public slots:

	// Add this GUI client to factory
	void slotActivated();

	// Remove this GUI client from factory
	void slotDeactivated();
	
protected slots:

	// Get request for context menu from property table
	void slotTablePropContextMenuRequested(int, int, const QPoint &);
	
	//--- Common clibpoard actions
    void slotCopyCell();
    void slotCopyRow();
    void slotCopyTableCsv();
    void slotCopyTableXml();
    
protected:

	// KPoGre main window
	KPoGreView* m_pPoGreView;
	
	// XML GUI factory
    KXMLGUIFactory * m_pXmlGuiFactory;
    
    // True, if this is in GUI factory
    bool m_bIsAddedToGuiFactory;
    
    // Common clipboard actions
    KAction* m_pActCopyCell;
	KAction* m_pActCopyRow;
	KAction* m_pActCopyTableCsv;
	KAction* m_pActCopyTableXml;

private:
	// Two same pointers to different base classes as property page
	QWidget*	m_pWidgetProperties;
	KPGAbstractPropertyPage* m_pPropertyPage;
	
	QBoxLayout* m_pLayout;
};

#endif
