//
// C++ Implementation: kpgcreatetriggerwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetriggerwizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "kpgcreatetriggerwidget1.h"


KPGCreateTriggerWizard::KPGCreateTriggerWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, const QString &strNamespace, const QString &strTable)
 : KPG3StepsWizard(parent, name)
{
	KPGCreateTriggerWidget1 *pCreateTriggerWidget1 = new KPGCreateTriggerWidget1(WizardPage1, "KPGCreateTriggerWidget1", pDatabase, strNamespace, strTable);
  m_pPageWidget1 = pCreateTriggerWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateTriggerWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
	languageChange();
}

KPGCreateTriggerWizard::~KPGCreateTriggerWizard()
{
}

void KPGCreateTriggerWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Add Trigger to Table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Trigger name and properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateTriggerWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		KPGCreateTriggerWidget1 *pCreateTriggerWidget1 = static_cast <KPGCreateTriggerWidget1 *> (m_pPageWidget1);
		m_pTextEditSQL->setText(pCreateTriggerWidget1->getSQL());
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}

#include "kpgcreatetriggerwizard.moc"
