//
// C++ Implementation: kpgcreateviewwidget4
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateviewwidget4.h"

// include files for Qt
#include <qpushbutton.h>
#include <qcheckbox.h>

// include files for KDE
#include <kcombobox.h>
#include <klineedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"


KPGCreateViewWidget4::KPGCreateViewWidget4(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateViewWidget4Base(parent, name)
{
	m_pDatabase = pDatabase;
  	m_bCheckBoxShowSysColumns = false;
	
	m_pListViewConditions->setSortColumn(-1);
}


KPGCreateViewWidget4::~KPGCreateViewWidget4()
{
}

void KPGCreateViewWidget4::slotCheckBoxShowSysColumnsToggled(bool bCheckBoxShowSysColumns)
{
	m_bCheckBoxShowSysColumns = bCheckBoxShowSysColumns;
	refreshAvailColumnsList(m_pComboBoxTables->currentText());
}

void KPGCreateViewWidget4::slotComboBoxTableActivated(const QString & strTableName)
{
	refreshAvailColumnsList(strTableName);
}

void KPGCreateViewWidget4::refreshAvailColumnsList(const QString & strTableName)
{
	m_pListBoxColumns->clear();
	m_listOfAvailableColumns.clear();
	m_pPushButtonConditionAdd->setEnabled(false);
	  
	// Fill list of columns to listbox
	KPGTreeItem *pItem = m_pDatabase->getChildByName(m_strNamespace);
	if(!pItem)
	{
		kdDebug() << k_funcinfo << " Noo item found: " << m_strNamespace << endl;
		return;
	}
			
	KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	KPGTablesFolder *pTablesFolder = pSchema->getTablesFolder();
	
	// Lookup pointer to table
	pItem = pTablesFolder->getChildByName(strTableName);
	if(!pItem)
	{
		kdDebug() << k_funcinfo << " No item found: " << strTableName << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pItem);
	pTable->getTableColumnsFolder()->fillListBoxWithChildItems(m_pListBoxColumns, m_bCheckBoxShowSysColumns);
	pTable->getTableColumnsFolder()->fillListColumnWizInfoWithChildItems(m_listOfAvailableColumns);
}

void KPGCreateViewWidget4::slotColumnsSelectChanged(QListBoxItem* pSelectedItem)
{
	enableAddConditionButton(
		pSelectedItem,
		m_pComboBoxCondition->currentItem(),
		m_pLineEditValue->text()
	);
}

void KPGCreateViewWidget4::slotComboBoxConditionActivated(int iIndex)
{
	m_pLineEditValue->setEnabled(iIndex <= 8);
	
	enableAddConditionButton(
		m_pListBoxColumns->selectedItem(),
		iIndex,
		m_pLineEditValue->text()
	);
}

void KPGCreateViewWidget4::slotLineEditValueTextChanged(const QString &strLineEditValueText)
{
	enableAddConditionButton(
		m_pListBoxColumns->selectedItem(),
		m_pComboBoxCondition->currentItem(),
		strLineEditValueText
	);
}

void KPGCreateViewWidget4::enableAddConditionButton(
	QListBoxItem* pSelectedColumns,
	int iComboBoxConditionIndex,
	const QString &strLineEditValueText
	)
{
	bool bEnable = (pSelectedColumns != 0) && ( (iComboBoxConditionIndex > 8) || ((iComboBoxConditionIndex <= 8) && (strLineEditValueText.length() > 0)) );
	
	m_pPushButtonConditionAdd->setEnabled(bEnable);
}

void KPGCreateViewWidget4::slotConditionsSelectionChanged(QListViewItem* pItem)
{
  m_pPushButtonConditionDel->setEnabled(pItem != 0);
}

void KPGCreateViewWidget4::slotConditionsCurrentChanged(QListViewItem* pItem)
{
  m_pPushButtonConditionDel->setEnabled(pItem != 0);
}

void KPGCreateViewWidget4::slotConditionAdd()
{
	QListBoxItem *pSelectedItem = m_pListBoxColumns->selectedItem();
	if(!pSelectedItem) return;
	
	QString strTableName(KPGUtil::quotedName(m_pComboBoxTables->currentText()));
  	QString strTableAlias = m_MapTableNameAlias[m_pComboBoxTables->currentText()];
	
	// set column name for view
	QString strColumn;
	
	if(strTableAlias.length() > 0)
	{
		strColumn = strTableAlias;
		strColumn.append(".");
		strColumn.append(KPGUtil::quotedName(pSelectedItem->text()));
	}
	else
	{
		strColumn = strTableName;
		strColumn.append(".");
		strColumn.append(KPGUtil::quotedName(pSelectedItem->text()));
	}
	
	// Build part of WHERE clause
	QString strSQL(strColumn);
	strSQL.append(" " + m_pComboBoxCondition->currentText());

	if(m_pComboBoxCondition->currentItem() <= 8)
	{
		strSQL.append(" ");
		
		if(m_pComboBoxCondition->currentText().find("LIKE") >= 0)
			strSQL.append("(");
		
					
		if(m_pCheckBoxQuotedValue->isChecked())
			strSQL.append("'");
			
		strSQL.append(m_pLineEditValue->text());
		
		if(m_pCheckBoxQuotedValue->isChecked())
			strSQL.append("'");
			
		if(m_pComboBoxCondition->currentText().find("LIKE") >= 0)
			strSQL.append(")");
	}

	// Add condition to list
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewConditions->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QListViewItem *pNewItem;
		
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewConditions, strSQL);
	else
		pNewItem = new QListViewItem(m_pListViewConditions, pLastItem, strSQL);
}

void KPGCreateViewWidget4::slotConditionDelete()
{
	QListViewItem *pSelectedItem = m_pListViewConditions->selectedItem();
	if(pSelectedItem)
			delete pSelectedItem;
	
	m_pPushButtonConditionDel->setEnabled(false);
}		

// Return part of SQL statement for CREATE VIEW
const QString KPGCreateViewWidget4::getSQL() const
{
	QString strSQL(" ");
	
	QListViewItem * pItem = m_pListViewConditions->firstChild();
	if(pItem)
	{
		strSQL.append("\nWHERE ");
	
		while(pItem)
		{
			strSQL.append(pItem->text(0));
							
			pItem = pItem->nextSibling();
			
			if(pItem)
				strSQL.append(" AND\n");
		}
	}
	
	return strSQL;
}

#include "kpgcreateviewwidget4.moc"
